/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.extractor;

import java.io.IOException;
import org.apache.poi.POITextExtractor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelExtractor
extends POITextExtractor {
    private HSSFWorkbook wb;
    private boolean includeSheetNames = true;
    private boolean formulasNotResults = false;

    public ExcelExtractor(HSSFWorkbook wb) {
        super(wb);
        this.wb = wb;
    }

    public ExcelExtractor(POIFSFileSystem fs) throws IOException {
        this(new HSSFWorkbook(fs));
    }

    public void setIncludeSheetNames(boolean includeSheetNames) {
        this.includeSheetNames = includeSheetNames;
    }

    public void setFormulasNotResults(boolean formulasNotResults) {
        this.formulasNotResults = formulasNotResults;
    }

    public String getText() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this.wb.getNumberOfSheets(); ++i) {
            String name;
            HSSFSheet sheet = this.wb.getSheetAt(i);
            if (sheet == null) continue;
            if (this.includeSheetNames && (name = this.wb.getSheetName(i)) != null) {
                text.append(name);
                text.append("\n");
            }
            int firstRow = sheet.getFirstRowNum();
            int lastRow = sheet.getLastRowNum();
            for (int j = firstRow; j <= lastRow; ++j) {
                HSSFRow row = sheet.getRow(j);
                if (row == null) continue;
                int firstCell = row.getFirstCellNum();
                short lastCell = row.getLastCellNum();
                for (int k = firstCell; k < lastCell; ++k) {
                    HSSFCell cell = row.getCell((short)k);
                    boolean outputContents = false;
                    if (cell == null) continue;
                    switch (cell.getCellType()) {
                        case 1: {
                            text.append(cell.getRichStringCellValue().getString());
                            outputContents = true;
                            break;
                        }
                        case 0: {
                            text.append(cell.getNumericCellValue());
                            outputContents = true;
                            break;
                        }
                        case 4: {
                            text.append(cell.getBooleanCellValue());
                            outputContents = true;
                            break;
                        }
                        case 2: {
                            if (this.formulasNotResults) {
                                text.append(cell.getCellFormula());
                            } else {
                                HSSFRichTextString str = cell.getRichStringCellValue();
                                if (str != null && str.length() > 0) {
                                    text.append(str.toString());
                                } else {
                                    double val = cell.getNumericCellValue();
                                    text.append(val);
                                }
                            }
                            outputContents = true;
                        }
                    }
                    if (!outputContents || k >= lastCell - 1) continue;
                    text.append("\t");
                }
                text.append("\n");
            }
        }
        return text.toString();
    }
}

