/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.xupdate;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.NodeSet;
import org.apache.xindice.xml.NamespaceMap;
import org.apache.xindice.xml.NodeSource;
import org.apache.xindice.xml.dom.CompressedNode;
import org.apache.xindice.xml.dom.DBNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xmldb.xupdate.lexus.XUpdateQueryImpl;
import org.xmldb.xupdate.lexus.commands.CommandObject;
import org.xmldb.xupdate.lexus.commands.DefaultCommand;

public class XUpdateImpl
extends XUpdateQueryImpl {
    private static final boolean API_NS_PRECEDENCE = true;
    protected int nodesModified;
    protected NamespaceMap nsMap;

    public void setNamespaceMap(NamespaceMap nsMap) {
        if (nsMap == null) {
            return;
        }
        if (this.nsMap == null) {
            this.nsMap = nsMap;
        } else {
            this.nsMap.includeNamespaces(nsMap, true);
        }
    }

    public void setQString(String query) throws SAXException {
        super.setQString(query);
        if (this.nsMap == null) {
            this.nsMap = new NamespaceMap();
        }
        this.nsMap.includeNamespaces(this.namespaces, false);
    }

    public void execute(Node contextNode) throws Exception {
        CompressedNode cn;
        DefaultCommand currentCommand = new DefaultCommand(contextNode);
        Enumeration commands = this.query[0].elements();
        Enumeration attributes = this.query[1].elements();
        Enumeration characters = this.query[2].elements();
        Node origNode = contextNode;
        CommandObject.getXPath().setNamespace(this.nsMap.getContextNode());
        while (commands.hasMoreElements()) {
            block8: {
                int id = (Integer)commands.nextElement();
                if (id == 200) {
                    currentCommand.submitAttributes((Hashtable)attributes.nextElement());
                    continue;
                }
                if (id == 300) {
                    currentCommand.submitCharacters((String)characters.nextElement());
                    continue;
                }
                if (id > 0) {
                    if (currentCommand.submitInstruction(id)) continue;
                    this.commandConstants.setContextNode(contextNode);
                    currentCommand = this.commandConstants.commandForID(id);
                    if (currentCommand == null) {
                        throw new Exception("Operation can not have any XUpdate-instruction!");
                    }
                    currentCommand.reset();
                    continue;
                }
                if (currentCommand.executeInstruction()) continue;
                try {
                    contextNode = currentCommand.execute();
                }
                catch (Exception e) {
                    if ("no nodes selected !".equals(e.getMessage())) break block8;
                    throw e;
                }
            }
            currentCommand = new DefaultCommand(contextNode);
        }
        if (origNode instanceof CompressedNode && (cn = (CompressedNode)origNode).isDirty()) {
            ++this.nodesModified;
        }
    }

    public void execute(Collection col) throws Exception {
        int attribIndex = 0;
        HashMap<Key, Document> docsUpdated = new HashMap<Key, Document>();
        int i = 0;
        while (i < this.query[0].size()) {
            int cmdID = (Integer)this.query[0].elementAt(i);
            if (cmdID == 200) {
                Hashtable attribs = (Hashtable)this.query[1].elementAt(attribIndex);
                String selector = (String)attribs.get("select");
                ++attribIndex;
                if (selector != null && !selector.startsWith("$")) {
                    NodeSet ns = col.queryCollection("XPath", selector, this.nsMap);
                    while (ns != null && ns.hasMoreNodes()) {
                        DBNode node = (DBNode)ns.getNextNode();
                        Document doc = node.getOwnerDocument();
                        NodeSource source = node.getSource();
                        if (docsUpdated.containsKey(source.getKey())) continue;
                        docsUpdated.put(source.getKey(), doc);
                        this.execute(doc.getDocumentElement());
                    }
                }
            }
            ++i;
        }
        Iterator i2 = docsUpdated.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry set = i2.next();
            col.setDocument(set.getKey(), (Document)set.getValue());
        }
    }

    public int getModifiedCount() {
        return this.nodesModified;
    }
}

