/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.event.impl;

import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.impl.DiffXEventBase;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;

public final class AttributeEventNSImpl
extends DiffXEventBase
implements AttributeEvent {
    private final String uri;
    private final String name;
    private final String value;

    public AttributeEventNSImpl(String string, String string2) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("Attribute must have a name.");
        }
        if (string2 == null) {
            throw new NullPointerException("The attribute value cannot be null, use \"\".");
        }
        this.name = string;
        this.value = string2;
        this.uri = null;
    }

    public AttributeEventNSImpl(String string, String string2, String string3) throws NullPointerException {
        if (string2 == null) {
            throw new NullPointerException("Attribute must have a name.");
        }
        if (string3 == null) {
            throw new NullPointerException("The attribute value cannot be null, use \"\".");
        }
        this.name = string2;
        this.value = string3;
        this.uri = string;
    }

    public String getName() {
        return this.name;
    }

    public String getURI() {
        return this.uri;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode();
    }

    public boolean equals(DiffXEvent diffXEvent) {
        if (diffXEvent.getClass() != this.getClass()) {
            return false;
        }
        AttributeEventNSImpl attributeEventNSImpl = (AttributeEventNSImpl)diffXEvent;
        if (!attributeEventNSImpl.name.equals(this.name)) {
            return false;
        }
        if (!AttributeEventNSImpl.equals(attributeEventNSImpl.uri, this.uri)) {
            return false;
        }
        return attributeEventNSImpl.value.equals(this.value);
    }

    public String toString() {
        return "attribute: " + this.name + "=" + this.value + " [" + this.uri + "]";
    }

    public void toXML(XMLWriter xMLWriter) throws IOException {
        xMLWriter.attribute(this.uri, this.name, this.value);
    }

    public StringBuffer toXML(StringBuffer stringBuffer) throws NullPointerException {
        stringBuffer.append(' ');
        stringBuffer.append(this.name);
        stringBuffer.append("=\"");
        stringBuffer.append(ESC.toAttributeValue(this.value));
        stringBuffer.append('\"');
        return stringBuffer;
    }

    private static boolean equals(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }
}

