/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.event.impl;

import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.DiffXEventBase;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;

public final class LineEvent
extends DiffXEventBase
implements TextEvent {
    private final CharSequence characters;
    private final int lineNumber;

    public LineEvent(CharSequence charSequence, int n) throws NullPointerException {
        if (charSequence == null) {
            throw new NullPointerException("The line cannot be null, use \"\"");
        }
        this.characters = charSequence;
        this.lineNumber = n;
    }

    public String toString() {
        return "line:" + this.lineNumber + ": \"" + this.getCharacters() + '\"';
    }

    public int hashCode() {
        return this.characters.hashCode();
    }

    public boolean equals(DiffXEvent diffXEvent) {
        if (this == diffXEvent) {
            return true;
        }
        if (diffXEvent.getClass() != LineEvent.class) {
            return false;
        }
        LineEvent lineEvent = (LineEvent)diffXEvent;
        return lineEvent.characters.equals(this.characters);
    }

    public String getCharacters() {
        return ((Object)this.characters).toString();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void toXML(XMLWriter xMLWriter) throws IOException {
        xMLWriter.writeXML(((Object)this.characters).toString());
    }

    public StringBuffer toXML(StringBuffer stringBuffer) throws NullPointerException {
        stringBuffer.append(this.characters);
        return stringBuffer;
    }
}

