/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.load.text;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.load.text.TextTokeniser;
import com.topologi.diffx.load.text.TextTokeniserByWord;
import com.topologi.diffx.load.text.TextTokeniserIgnoreSpace;
import com.topologi.diffx.load.text.TextTokeniserNoSpace;

public final class TokeniserFactory {
    private final DiffXConfig config;
    private final transient int tokeniserChoice;

    public TokeniserFactory(DiffXConfig diffXConfig) throws NullPointerException {
        if (diffXConfig == null) {
            throw new NullPointerException("Factory requires a tokeniser.");
        }
        this.config = diffXConfig;
        this.tokeniserChoice = (this.config.isIgnoreWhiteSpace() ? 2 : 0) + (this.config.isPreserveWhiteSpace() ? 0 : 1);
    }

    public TextTokeniser makeTokeniser(CharSequence charSequence) {
        switch (this.tokeniserChoice) {
            case 0: {
                return new TextTokeniserByWord(charSequence);
            }
            case 1: {
                return new TextTokeniserByWord(charSequence);
            }
            case 2: {
                return new TextTokeniserIgnoreSpace(charSequence);
            }
            case 3: {
                return new TextTokeniserNoSpace(charSequence);
            }
        }
        throw new IllegalStateException("Impossible whitespace configuration: " + this.tokeniserChoice);
    }

    public DiffXConfig getConfig() {
        return this.config;
    }
}

