/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.CacheFilePriority;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.internal.Dbc;

public class Cursor {
    Dbc dbc;
    Database database;
    CursorConfig config;

    protected Cursor(Database database, CursorConfig config) {
        this.database = database;
        this.config = config;
    }

    Cursor(Database database, Dbc dbc, CursorConfig config) throws DatabaseException {
        this.database = database;
        this.dbc = dbc;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws DatabaseException {
        if (this.dbc != null) {
            try {
                this.dbc.close();
            }
            finally {
                this.dbc = null;
            }
        }
    }

    public Cursor dup(boolean samePosition) throws DatabaseException {
        return new Cursor(this.database, this.dbc.dup(samePosition ? 22 : 0), this.config);
    }

    public CursorConfig getConfig() {
        return this.config;
    }

    public Database getDatabase() {
        return this.database;
    }

    public int count() throws DatabaseException {
        return this.dbc.count(0);
    }

    public OperationStatus delete() throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.del(0));
    }

    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 6 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 7 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 0xF | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 0x10 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 0x11 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 0x12 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 0x17 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 0x18 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 0x19 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getRecordNumber(DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(DatabaseEntry.IGNORE, data, 0xB | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 0x1A | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 0x1B | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 8 | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 0xA | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus getSearchRecordNumber(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(key, data, 0x1C | LockMode.getFlag(lockMode) | (data == null ? 0 : data.getMultiFlag())));
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(key, data, 14));
    }

    public OperationStatus putAfter(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(key, data, 1));
    }

    public OperationStatus putBefore(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(key, data, 3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        Dbc tempDbc = this.dbc.dup(0);
        try {
            int errCode = tempDbc.get(key, DatabaseEntry.IGNORE, 0x1A | this.database.rmwFlag);
            if (errCode == 0) {
                OperationStatus operationStatus = OperationStatus.KEYEXIST;
                return operationStatus;
            }
            if (errCode != -30989 && errCode != -30997) {
                OperationStatus operationStatus = OperationStatus.fromInt(errCode);
                return operationStatus;
            }
            Dbc tdbc = this.dbc;
            this.dbc = tempDbc;
            tempDbc = tdbc;
            OperationStatus operationStatus = OperationStatus.fromInt(this.dbc.put(key, data, 14));
            return operationStatus;
        }
        finally {
            tempDbc.close();
        }
    }

    public OperationStatus putKeyFirst(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(key, data, 13));
    }

    public OperationStatus putKeyLast(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(key, data, 14));
    }

    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(key, data, 19));
    }

    public OperationStatus putCurrent(DatabaseEntry data) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(DatabaseEntry.UNUSED, data, 6));
    }

    public CacheFilePriority getPriority() throws DatabaseException {
        return CacheFilePriority.fromFlag(this.dbc.get_priority());
    }

    public void setPriority(CacheFilePriority priority) throws DatabaseException {
        this.dbc.set_priority(priority.getFlag());
    }
}

