/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.MultipleEntry;
import com.sleepycat.db.internal.DbUtil;
import java.nio.ByteBuffer;

public class MultipleNIODataEntry
extends MultipleEntry {
    public MultipleNIODataEntry() {
        super((ByteBuffer)null);
    }

    public MultipleNIODataEntry(ByteBuffer data) {
        super(data);
    }

    int getMultiFlag() {
        this.pos = 0;
        return 0x10000000;
    }

    public boolean next(DatabaseEntry data) {
        if (this.pos == 0) {
            this.pos = this.ulen - 4;
        }
        if (this.data_nio.capacity() < 8) {
            return false;
        }
        byte[] intarr = new byte[8];
        int saveoffset = this.data_nio.position();
        this.data_nio.position(this.pos - 4);
        this.data_nio.get(intarr, 0, 8);
        this.data_nio.position(saveoffset);
        int dataoff = DbUtil.array2int(intarr, 4);
        if (dataoff < 0) {
            return false;
        }
        int datasz = DbUtil.array2int(intarr, 0);
        this.pos -= 8;
        data.setDataNIO(this.data_nio);
        data.setSize(datasz);
        data.setOffset(dataoff);
        return true;
    }
}

