/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.limit;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.limit.LimIndexReader;

class LimTermDocs
implements TermDocs {
    private LimIndexReader reader;
    private TermDocs wrapped;

    public LimTermDocs(LimIndexReader reader, TermDocs toWrap) {
        this.wrapped = toWrap;
        this.reader = reader;
    }

    public int read(int[] docs, int[] freqs) throws IOException {
        int nRead = this.wrapped.read(docs, freqs);
        this.reader.work(nRead);
        return nRead;
    }

    public void seek(Term term) throws IOException {
        this.reader.work(1);
        this.wrapped.seek(term);
    }

    public void seek(TermEnum termEnum) throws IOException {
        this.reader.work(1);
        this.wrapped.seek(termEnum);
    }

    public boolean next() throws IOException {
        this.reader.work(1);
        return this.wrapped.next();
    }

    public boolean skipTo(int target) throws IOException {
        this.reader.work(1);
        return this.wrapped.skipTo(target);
    }

    public void close() throws IOException {
        this.wrapped.close();
    }

    public int doc() {
        return this.wrapped.doc();
    }

    public boolean equals(Object obj) {
        return this.wrapped.equals(obj);
    }

    public int freq() {
        return this.wrapped.freq();
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

