/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.search.spans.FieldSpans;
import org.apache.lucene.search.spans.Span;
import org.apache.lucene.search.spans.SpanPosComparator;
import org.apache.lucene.search.spans.SpanRecordingScorer;

public class FieldSpanSource {
    String[] fields;
    SpanRecordingScorer[][] scorersPerField;
    ScoreOrder[] scoreOrder = new ScoreOrder[0];
    int curDoc = -1;
    private static ScoreComparator theScoreComparator = new ScoreComparator();

    FieldSpanSource(SpanRecordingScorer[] scorers) {
        HashMap<String, ArrayList<SpanRecordingScorer>> map = new HashMap<String, ArrayList<SpanRecordingScorer>>();
        int i = 0;
        while (i < scorers.length) {
            String field = scorers[i].getField();
            ArrayList<SpanRecordingScorer> list = (ArrayList<SpanRecordingScorer>)map.get(field);
            if (list == null) {
                list = new ArrayList<SpanRecordingScorer>();
                map.put(field, list);
            }
            list.add(scorers[i]);
            ++i;
        }
        this.fields = map.keySet().toArray(new String[map.size()]);
        this.scorersPerField = new SpanRecordingScorer[this.fields.length][];
        i = 0;
        while (i < this.fields.length) {
            ArrayList list = (ArrayList)map.get(this.fields[i]);
            this.scorersPerField[i] = list.toArray(new SpanRecordingScorer[list.size()]);
            ++i;
        }
    }

    public synchronized FieldSpans getSpans(int doc) {
        if (doc != this.curDoc) {
            throw new UnsupportedOperationException("FieldSpanSource can only retrieve spans for current document");
        }
        FieldSpans ret = new FieldSpans();
        int i = 0;
        while (i < this.fields.length) {
            this.addSpans(doc, this.fields[i], this.scorersPerField[i], ret);
            ++i;
        }
        return ret;
    }

    private void addSpans(int doc, String field, SpanRecordingScorer[] scorers, FieldSpans out) {
        ScoreOrder o;
        int nToDedupe = 0;
        int maxSpans = 0;
        HashSet terms = null;
        int i = 0;
        while (i < scorers.length) {
            if (scorers[i].getSpanDoc() == doc) {
                nToDedupe += scorers[i].getSpanCount();
                maxSpans = Math.max(maxSpans, scorers[i].getMaxSpans());
                if (terms == null) {
                    terms = scorers[i].getTerms();
                } else {
                    HashSet newTerms = new HashSet();
                    newTerms.addAll(terms);
                    newTerms.addAll(scorers[i].getTerms());
                    terms = newTerms;
                }
            }
            ++i;
        }
        if (nToDedupe == 0) {
            return;
        }
        Span[] toDedupe = new Span[nToDedupe];
        int start = 0;
        int i2 = 0;
        while (i2 < scorers.length) {
            if (scorers[i2].getSpanDoc() == doc) {
                int count = scorers[i2].getSpanCount();
                System.arraycopy(scorers[i2].getSpans(), 0, toDedupe, start, count);
                start += count;
            }
            ++i2;
        }
        assert (start == nToDedupe) : "internal error: mis-counted spans";
        Arrays.sort(toDedupe, SpanPosComparator.theInstance);
        int longestSpan = 0;
        int i3 = 0;
        while (i3 < nToDedupe) {
            longestSpan = Math.max(longestSpan, toDedupe[i3].end - toDedupe[i3].start);
            ++i3;
        }
        if (this.scoreOrder.length < nToDedupe) {
            ScoreOrder[] newScoreOrder = new ScoreOrder[nToDedupe + 5];
            System.arraycopy(this.scoreOrder, 0, newScoreOrder, 0, this.scoreOrder.length);
            int i4 = this.scoreOrder.length;
            while (i4 < newScoreOrder.length) {
                newScoreOrder[i4] = new ScoreOrder();
                ++i4;
            }
            this.scoreOrder = newScoreOrder;
        }
        i = 0;
        while (i < nToDedupe) {
            this.scoreOrder[i].span = toDedupe[i];
            this.scoreOrder[i].posOrder = i;
            this.scoreOrder[i].cancelled = false;
            this.scoreOrder[i].prevInPosOrder = i - 1 >= 0 ? this.scoreOrder[i - 1] : null;
            this.scoreOrder[i].nextInPosOrder = i + 1 < nToDedupe ? this.scoreOrder[i + 1] : null;
            this.scoreOrder[i].nextDeduped = null;
            ++i;
        }
        Arrays.sort(this.scoreOrder, 0, nToDedupe, theScoreComparator);
        int nDeduped = 0;
        int totalDeduped = 0;
        ScoreOrder firstDeduped = null;
        ScoreOrder lastDeduped = null;
        int i5 = 0;
        while (i5 < nToDedupe) {
            if (!this.scoreOrder[i5].cancelled) {
                ++totalDeduped;
                if (nDeduped < maxSpans) {
                    if (firstDeduped == null) {
                        firstDeduped = this.scoreOrder[i5];
                    } else {
                        lastDeduped.nextDeduped = this.scoreOrder[i5];
                    }
                    lastDeduped = this.scoreOrder[i5];
                    ++nDeduped;
                }
                Span scoreSpan = this.scoreOrder[i5].span;
                o = this.scoreOrder[i5].prevInPosOrder;
                while (o != null && o.span.start + longestSpan > scoreSpan.start) {
                    assert (o.span.start <= scoreSpan.start);
                    if (o.span.end > scoreSpan.start) {
                        o.cancelled = true;
                    }
                    assert (o.posOrder == 0 || o.prevInPosOrder.posOrder == o.posOrder - 1);
                    o = o.prevInPosOrder;
                }
                o = this.scoreOrder[i5].nextInPosOrder;
                while (o != null && o.span.start < scoreSpan.end) {
                    o.cancelled = true;
                    assert (o.posOrder == nToDedupe - 1 || o.nextInPosOrder.posOrder == o.posOrder + 1);
                    o = o.nextInPosOrder;
                }
            }
            ++i5;
        }
        Span[] outSpans = new Span[nDeduped];
        int rank = 0;
        float prevScore = Float.MAX_VALUE;
        int i6 = 0;
        o = firstDeduped;
        while (o != null) {
            assert (!o.cancelled) : "kept span was cancelled";
            Span s = (Span)o.span.clone();
            assert (s.score <= prevScore) : "incorrect dedupe list linking";
            if (rank == nDeduped - 1) assert (o == lastDeduped);
            prevScore = s.score;
            s.rank = rank++;
            outSpans[i6++] = s;
            o = o.nextDeduped;
        }
        assert (rank == nDeduped) : "incorrect dedupe list linking";
        Arrays.sort(outSpans, SpanPosComparator.theInstance);
        out.recordSpans(field, totalDeduped, outSpans, terms);
    }

    private static class ScoreComparator
    implements Comparator {
        private ScoreComparator() {
        }

        public int compare(Object o1, Object o2) {
            Span s1 = ((ScoreOrder)o1).span;
            Span s2 = ((ScoreOrder)o2).span;
            if (s1.score < s2.score) {
                return 1;
            }
            if (s1.score > s2.score) {
                return -1;
            }
            if (s1.start == s2.start) {
                return s2.end - s1.end;
            }
            return s1.start - s2.start;
        }
    }

    private class ScoreOrder {
        Span span;
        int posOrder;
        boolean cancelled;
        ScoreOrder nextInPosOrder;
        ScoreOrder prevInPosOrder;
        ScoreOrder nextDeduped;

        private ScoreOrder() {
        }
    }
}

