/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spelt;

import junit.framework.TestCase;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.spelt.SimpleQueryRewriter;

public class SimpleQueryRewriterTest
extends TestCase {
    private QueryParser parser = new QueryParser("text", new StandardAnalyzer());
    private SimpleQueryRewriter rewriter;

    public void testSimple() throws ParseException {
        this.rewriter = new SimpleRewriter();
        this.testQuery("happy", "foohappy");
        this.testQuery("happy bear", "foohappy foobear");
        this.testQuery("a:happy b:bear", "a:foohappy b:foobear");
        this.testQuery("+happy +bear", "+foohappy +foobear");
        this.testQuery("happy^5", "foohappy^5.0");
        this.testQuery("\"happy bear\"", "\"foohappy foobear\"");
    }

    public void testSplitting() throws ParseException {
        this.rewriter = new SplittingRewriter();
        this.testQuery("happy", "happy");
        this.testQuery("abxyz", "\"ab yz\"");
        this.testQuery("abxyz^5", "\"ab yz\"^5.0");
        this.testQuery("a:mxn b:pxq", "a:\"m n\" b:\"p q\"");
        this.testQuery("\"axb pxq\"", "\"a b p q\"");
    }

    public void testDropping() throws ParseException {
        this.rewriter = new DroppingRewriter();
        this.testQuery("happy bear times three", "happy times");
        this.testQuery("\"happy bear times three\"", "\"happy times\"");
    }

    private void testQuery(String inQuery, String outQuery) throws ParseException {
        Query inParsed = this.parser.parse(inQuery);
        Query rewritten = this.rewriter.rewriteQuery(inParsed);
        String rewrittenStr = rewritten.toString("text");
        SimpleQueryRewriterTest.assertEquals((String)outQuery, (String)rewrittenStr);
    }

    private class DroppingRewriter
    extends SimpleQueryRewriter {
        private int num = 0;

        private DroppingRewriter() {
        }

        public Term rewrite(Term t) {
            ++this.num;
            if (this.num % 2 == 1) {
                return t;
            }
            return null;
        }
    }

    private class SimpleRewriter
    extends SimpleQueryRewriter {
        private SimpleRewriter() {
        }

        public Term rewrite(Term t) {
            return new Term(t.field(), "foo" + t.text());
        }
    }

    private class SplittingRewriter
    extends SimpleQueryRewriter {
        private SplittingRewriter() {
        }

        public Term rewrite(Term t) {
            String text = t.text();
            int pos = text.indexOf(120);
            if (pos < 0) {
                return t;
            }
            return new Term(t.field(), text.replace('x', ' '));
        }
    }
}

