/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.StrippedNode;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.PatternFinder;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.StringValue;
import org.apache.lucene.util.Hash64;
import org.cdlib.xtf.lazyTree.FastNodeTestPattern;
import org.cdlib.xtf.lazyTree.LazyDocument;
import org.cdlib.xtf.lazyTree.LazyHashMap;
import org.cdlib.xtf.util.DiskHashReader;
import org.cdlib.xtf.util.Trace;

public class LazyKeyManager
extends KeyManager {
    private int nKeysStored;

    public LazyKeyManager(Configuration config, KeyManager prevMgr) {
        super(config);
        this.keyList = prevMgr.keyList;
    }

    public synchronized Map buildIndex(int keyNameFingerprint, BuiltInAtomicType itemType, Set foundItemTypes, DocumentInfo doc, XPathContext context) throws XPathException {
        LazyDocument document = LazyKeyManager.getDocumentImpl(doc);
        if (document == null) {
            return super.buildIndex(keyNameFingerprint, itemType, foundItemTypes, doc, context);
        }
        NamePool pool = context.getController().getNamePool();
        String fingerName = pool.getDisplayName(keyNameFingerprint);
        if (fingerName.indexOf("dynamic") >= 0) {
            if (document.getDebug()) {
                Trace.debug("Building dynamic (non-stored) index " + new File(doc.getSystemId()).getName() + ": '" + fingerName + ":" + itemType + "'");
            }
            Map index = super.buildIndex(keyNameFingerprint, itemType, foundItemTypes, doc, context);
            if (document.getDebug()) {
                Trace.debug("...done");
            }
            return index;
        }
        List definitions = this.getKeyDefinitions(keyNameFingerprint);
        String indexName = this.calcIndexName(pool, fingerName, definitions, document.config);
        DiskHashReader reader = document.getIndex(indexName);
        if (reader != null) {
            return new LazyHashMap(document, reader);
        }
        if (document.getDebug()) {
            Trace.info("Building key index " + new File(doc.getSystemId()).getName() + ": '" + fingerName + "' {" + indexName + "}...");
        }
        itemType = BuiltInAtomicType.STRING;
        Map index = super.buildIndex(keyNameFingerprint, itemType, foundItemTypes, doc, context);
        try {
            document.putIndex(indexName, index);
            ++this.nKeysStored;
        }
        catch (IOException e) {
            Trace.error("Error storing persistent index! " + e);
            return index;
        }
        if (document.getDebug()) {
            Trace.info("...done");
        }
        return new LazyHashMap(document, document.getIndex(indexName));
    }

    protected void constructIndex(DocumentInfo doc, Map index, KeyDefinition keydef, BuiltInAtomicType soughtItemType, Set foundItemTypes, XPathContext context, boolean isFirst) throws XPathException {
        PatternFinder match = keydef.getMatch();
        if (match instanceof NodeTestPattern) {
            match = new FastNodeTestPattern(((NodeTestPattern)match).getNodeTest());
            KeyDefinition oldDef = keydef;
            keydef = new KeyDefinition(match, oldDef.getUse(), oldDef.getCollationName(), oldDef.getCollation());
        }
        super.constructIndex(doc, index, keydef, soughtItemType, foundItemTypes, context, isFirst);
    }

    public boolean isEmpty() {
        return this.keyList.size() == 0;
    }

    public synchronized int createAllKeys(LazyDocument doc, XPathContext context) throws XPathException {
        StringValue val = new StringValue("1");
        NamePool pool = context.getController().getNamePool();
        if (Trace.getOutputLevel() == 8) {
            doc.setDebug(true);
        }
        this.nKeysStored = 0;
        IntIterator iter = this.keyList.keyIterator();
        while (iter.hasNext()) {
            int fingerprint = iter.next();
            String fingerName = pool.getDisplayName(fingerprint);
            if (fingerName.indexOf("dynamic") >= 0) continue;
            this.selectByKey(fingerprint, doc, val, context);
        }
        return this.nKeysStored;
    }

    public static LazyDocument getDocumentImpl(DocumentInfo doc) {
        while (doc instanceof StrippedNode) {
            doc = (DocumentInfo)((StrippedNode)((Object)doc)).getUnderlyingNode();
        }
        if (doc instanceof LazyDocument) {
            return (LazyDocument)doc;
        }
        return null;
    }

    private String calcIndexName(NamePool pool, String fingerName, List definitions, Configuration config) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("key|" + fingerName);
        int k = 0;
        while (k < definitions.size()) {
            KeyDefinition def = (KeyDefinition)definitions.get(k);
            String matchStr = def.getMatch().toString();
            sbuf.append("|" + Long.toString(Hash64.hash(matchStr), 16));
            if (def.getUse() instanceof Expression) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(bytes);
                ((Expression)def.getUse()).display(10, ps, config);
                ps.flush();
                String useStr = bytes.toString();
                sbuf.append("|" + Long.toString(Hash64.hash(useStr), 16));
            } else {
                sbuf.append("|non-exp");
            }
            ++k;
        }
        return sbuf.toString();
    }
}

