/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.HackedTinyBuilder;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyTree;
import org.cdlib.xtf.lazyTree.LazyDocument;
import org.cdlib.xtf.util.ConsecutiveMap;
import org.cdlib.xtf.util.PackedByteBuf;
import org.cdlib.xtf.util.StructuredStore;
import org.cdlib.xtf.util.SubStoreWriter;
import org.cdlib.xtf.util.XTFSaxonErrorListener;

public class LazyTreeBuilder {
    private TinyTree tree;
    private NamePool namePool;
    private ConsecutiveMap names = new ConsecutiveMap();
    private Configuration config;
    private PipelineConfiguration pipe;
    public static final String CURRENT_VERSION = "2.0";
    public static final String REQUIRED_VERSION = "2.0";

    public LazyTreeBuilder(Configuration config) {
        this.config = config;
        config.setErrorListener(new XTFSaxonErrorListener());
        this.pipe = new PipelineConfiguration();
        this.pipe.setConfiguration(config);
        this.pipe.setErrorListener(config.getErrorListener());
    }

    public void setNamePool(NamePool pool) {
        this.namePool = pool;
    }

    public NodeInfo load(StructuredStore treeStore) throws FileNotFoundException, IOException {
        LazyDocument targetDoc = new LazyDocument(this.config);
        this.load(treeStore, targetDoc);
        return targetDoc;
    }

    public void load(StructuredStore treeStore, LazyDocument emptyDoc) throws FileNotFoundException, IOException {
        String fileVer = treeStore.getUserVersion();
        if (fileVer.compareTo("2.0") < 0) {
            throw new IOException("Cannot use old version of LazyTree file... consider re-indexing with '-clean'.");
        }
        emptyDoc.init(this.namePool, treeStore);
        emptyDoc.setSystemId(treeStore.getSystemId());
    }

    public Receiver begin(StructuredStore treeStore) throws IOException {
        HackedTinyBuilder builder = new HackedTinyBuilder();
        if (this.namePool == null) {
            this.namePool = this.config.getNamePool();
        }
        builder.setPipelineConfiguration(this.pipe);
        builder.setTreeStore(treeStore);
        treeStore.setUserVersion("2.0");
        SubStoreWriter textFile = treeStore.createSubStore("text");
        builder.setTextStore(textFile);
        return builder;
    }

    public int getNodeNum(Receiver inBuilder) {
        HackedTinyBuilder builder = (HackedTinyBuilder)inBuilder;
        this.tree = builder.getTree();
        int nNodes = this.tree.getNumberOfNodes();
        while (nNodes > 0 && this.tree.getNodeKind(nNodes - 1) == 11) {
            --nNodes;
        }
        return nNodes;
    }

    public void finish(Receiver inBuilder, boolean closeStore) throws IOException {
        HackedTinyBuilder builder = (HackedTinyBuilder)inBuilder;
        StructuredStore treeStore = builder.getTreeStore();
        this.tree = builder.getTree();
        builder.getTextStore().close();
        builder.setTextStore(null);
        if (this.tree == null) {
            treeStore.delete();
            return;
        }
        this.checkSupport();
        this.writeNames(treeStore.createSubStore("names"));
        this.writeAttrs(treeStore.createSubStore("attributes"));
        this.writeNodes(treeStore.createSubStore("nodes"));
        if (closeStore) {
            treeStore.close();
        }
        this.tree = null;
        this.names = null;
    }

    public void abort(Receiver inBuilder) {
        HackedTinyBuilder builder = (HackedTinyBuilder)inBuilder;
        try {
            StructuredStore treeStore;
            if (builder.getTextStore() != null) {
                builder.getTextStore().close();
            }
            if ((treeStore = builder.getTreeStore()) != null) {
                treeStore.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeNames(SubStoreWriter out) throws IOException {
        PackedByteBuf buf = new PackedByteBuf(1000);
        assert (this.tree.getConfiguration().getNamePool() == this.namePool);
        buf.writeInt(this.tree.getNumberOfNamespaces());
        int[] namespaceCodes = this.tree.getNamespaceCodeArray();
        int[] namespaceParents = this.tree.getNamespaceParentArray();
        int i = 0;
        while (i < this.tree.getNumberOfNamespaces()) {
            int code = namespaceCodes[i];
            buf.writeString(this.namePool.getPrefixFromNamespaceCode(code));
            buf.writeString(this.namePool.getURIFromNamespaceCode(code));
            buf.writeInt(namespaceParents[i]);
            ++i;
        }
        int[] nameCodes = this.tree.getNameCodeArray();
        int i2 = 0;
        while (i2 < this.tree.getNumberOfNodes()) {
            if (nameCodes[i2] >= 0) {
                this.names.put(nameCodes[i2]);
            }
            ++i2;
        }
        int[] attCodes = this.tree.getAttributeNameCodeArray();
        int i3 = 0;
        while (i3 < this.tree.getNumberOfAttributes()) {
            if (attCodes[i3] >= 0) {
                this.names.put(attCodes[i3]);
            }
            ++i3;
        }
        Object[] nameArray = this.names.getArray();
        buf.writeInt(nameArray.length);
        int i4 = 0;
        while (i4 < nameArray.length) {
            int code = (Integer)nameArray[i4];
            buf.writeString(this.namePool.getPrefix(code));
            buf.writeString(this.namePool.getURI(code));
            buf.writeString(this.namePool.getLocalName(code));
            ++i4;
        }
        buf.output(out);
        out.close();
    }

    private void writeNodes(SubStoreWriter out) throws IOException {
        out.writeInt(0);
        int nNodes = this.tree.getNumberOfNodes();
        while (nNodes > 0 && this.tree.getNodeKind(nNodes - 1) == 11) {
            --nNodes;
        }
        int[] nameCodes = this.tree.getNameCodeArray();
        int[] nexts = this.tree.getNextPointerArray();
        int[] alphas = this.tree.getAlphaArray();
        int[] betas = this.tree.getBetaArray();
        int[] prior = new int[this.tree.getNumberOfNodes()];
        Arrays.fill(prior, 0, this.tree.getNumberOfNodes(), -1);
        int i = 0;
        while (i < this.tree.getNumberOfNodes()) {
            int nextNode = nexts[i];
            if (nextNode > i) {
                prior[nextNode] = i;
            }
            ++i;
        }
        PackedByteBuf[] nodeBufs = new PackedByteBuf[nNodes];
        int maxSize = 0;
        int i2 = 0;
        while (i2 < nNodes) {
            PackedByteBuf buf = nodeBufs[i2] = new PackedByteBuf(20);
            byte kind = this.tree.nodeKind[i2];
            if (kind == 8 || kind == 7) {
                throw new RuntimeException("Internal error: processing instructions and comments should have been filtered out");
            }
            buf.writeByte(this.tree.nodeKind[i2]);
            TinyNodeImpl node = this.tree.getNode(i2);
            int nameCode = nameCodes[i2];
            int parent = node.getParent() != null ? ((TinyNodeImpl)node.getParent()).getNodeNumber() : -1;
            int prevSib = prior[i2];
            int nextSib = nexts[i2] > i2 ? nexts[i2] : -1;
            int child = node.hasChildNodes() ? i2 + 1 : -1;
            int alpha = alphas[i2];
            int beta = betas[i2];
            int flags = (nameCode != -1 ? 1 : 0) | (parent != -1 ? 2 : 0) | (prevSib != -1 ? 4 : 0) | (nextSib != -1 ? 8 : 0) | (child != -1 ? 16 : 0) | (alpha != -1 ? 32 : 0) | (beta != -1 ? 64 : 0);
            buf.writeInt(flags);
            assert (prevSib != nextSib || prevSib < 0);
            if (nameCode >= 0) {
                int nameIdx = this.names.get(nameCode);
                assert (nameIdx >= 0) : "A name was missed when writing name codes";
                buf.writeInt(nameIdx);
            }
            if (parent >= 0) {
                buf.writeInt(parent);
            }
            if (prevSib >= 0) {
                buf.writeInt(prevSib);
            }
            if (nextSib >= 0) {
                buf.writeInt(nextSib);
            }
            if (child >= 0) {
                assert (child != 0);
                buf.writeInt(child);
            }
            if (alpha != -1) {
                buf.writeInt(alpha);
            }
            if (beta != -1) {
                buf.writeInt(beta);
            }
            buf.compact();
            maxSize = Math.max(maxSize, buf.length());
            ++i2;
        }
        out.writeInt(this.tree.getNumberOfNodes());
        out.writeInt(maxSize);
        i2 = 0;
        while (i2 < nNodes) {
            nodeBufs[i2].output(out, maxSize);
            ++i2;
        }
        out.close();
    }

    private void writeAttrs(SubStoreWriter out) throws IOException {
        int maxSize = 0;
        PackedByteBuf buf = new PackedByteBuf(100);
        int[] attParents = this.tree.getAttributeParentArray();
        int[] attCodes = this.tree.getAttributeNameCodeArray();
        CharSequence[] attValues = this.tree.getAttributeValueArray();
        int i = 0;
        while (i < this.tree.getNumberOfAttributes()) {
            int j = i + 1;
            while (j < this.tree.getNumberOfAttributes()) {
                if (attParents[j] != attParents[i]) break;
                ++j;
            }
            int nAttrs = j - i;
            buf.reset();
            buf.writeInt(nAttrs);
            j = i;
            while (j < i + nAttrs) {
                int nameIdx = this.names.get(attCodes[j]);
                assert (nameIdx >= 0) : "A name was missed when writing name codes";
                buf.writeInt(nameIdx);
                buf.writeString(attValues[j].toString());
                ++j;
            }
            maxSize = Math.max(maxSize, buf.length());
            i += nAttrs;
        }
        out.writeInt(maxSize);
        int[] alphas = this.tree.getAlphaArray();
        int i2 = 0;
        while (i2 < this.tree.getNumberOfAttributes()) {
            int j = i2 + 1;
            while (j < this.tree.getNumberOfAttributes()) {
                if (attParents[j] != attParents[i2]) break;
                ++j;
            }
            int nAttrs = j - i2;
            buf.reset();
            buf.writeInt(nAttrs);
            j = i2;
            while (j < i2 + nAttrs) {
                int nameIdx = this.names.get(attCodes[j]);
                assert (nameIdx >= 0) : "A name was missed when writing name codes";
                buf.writeInt(nameIdx);
                buf.writeString(attValues[j].toString());
                ++j;
            }
            int parent = attParents[i2];
            assert (this.tree.nodeKind[parent] == 1);
            alphas[parent] = (int)out.length();
            buf.output(out);
            i2 += nAttrs;
        }
        byte[] tmp = new byte[maxSize];
        out.write(tmp);
        out.close();
    }

    private void checkSupport() throws IOException {
        if (this.tree.getAttributeTypeCodeArray() == null) {
            this.tree.getTypeCodeArray();
        }
    }
}

