/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.pipe;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.saxonExt.ElementWithContent;
import org.cdlib.xtf.saxonExt.InstructionWithContent;
import org.cdlib.xtf.saxonExt.pipe.PipeBufferPool;
import org.cdlib.xtf.servletBase.TextServlet;
import org.cdlib.xtf.xslt.FileUtils;

public class PipeFileElement
extends ElementWithContent {
    public void prepareAttributes() throws XPathException {
        String[] mandatoryAtts = new String[]{"path", "mimeType"};
        String[] optionalAtts = new String[]{"fileName"};
        this.parseAttributes(mandatoryAtts, optionalAtts);
    }

    public Expression compile(Executable exec) throws XPathException {
        return new PipeFileInstruction(this.attribs, this.compileContent(exec));
    }

    public static void copyFileToStream(File inFilePath, OutputStream outStream) throws IOException {
        FileInputStream fileIn = null;
        try {
            fileIn = new FileInputStream(inFilePath);
            PipeFileElement.copyStreamToStream(fileIn, outStream);
        }
        finally {
            if (fileIn != null) {
                try {
                    ((InputStream)fileIn).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void copyStreamToStream(InputStream fileIn, OutputStream outStream) throws IOException {
        byte[] buf = null;
        try {
            int got;
            buf = PipeBufferPool.allocBuffer();
            while ((got = fileIn.read(buf)) >= 0) {
                outStream.write(buf, 0, got);
            }
            outStream.flush();
        }
        finally {
            if (buf != null) {
                PipeBufferPool.deallocBuffer(buf);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PipeFileInstruction
    extends InstructionWithContent {
        public PipeFileInstruction(Map<String, Expression> attribs, Expression content) {
            super("pipe:pipeFile", attribs, content);
        }

        @Override
        public TailCall processLeavingTail(XPathContext context) throws XPathException {
            String path = ((Expression)this.attribs.get("path")).evaluateAsString(context);
            File file = FileUtils.resolveFile(context, path);
            if (!file.canRead()) {
                this.dynamicError("Cannot read path '" + path + "' (resolved to '" + file.toString() + "'", "PIPE_FILE_001", context);
            }
            HttpServletResponse servletResponse = TextServlet.getCurResponse();
            servletResponse.setHeader("Content-length", Long.toString(file.length()));
            servletResponse.setHeader("Content-type", ((Expression)this.attribs.get("mimeType")).evaluateAsString(context));
            if (this.attribs.containsKey("fileName")) {
                String fileName = ((Expression)this.attribs.get("fileName")).evaluateAsString(context);
                servletResponse.setHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
            }
            try {
                PipeFileElement.copyFileToStream(file, (OutputStream)servletResponse.getOutputStream());
            }
            catch (IOException e) {
                this.dynamicError("IO Error while piping file: " + e.toString(), "PIPE_FILE_002", context);
            }
            return null;
        }
    }
}

