/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.cdlib.xtf.util.Trace;

public class BoostSet {
    private static WeakHashMap cache = new WeakHashMap();
    private String field;
    private int nWarnings = 0;
    private float[] boostByDoc;
    private static float DEFAULT_MARKER = -99.0f;

    public static BoostSet getCachedSet(IndexReader indexReader, File inFile, String field) throws IOException {
        BoostSet set;
        HashMap<File, BoostSet> readerCache = (HashMap<File, BoostSet>)cache.get(indexReader);
        if (readerCache == null) {
            readerCache = new HashMap<File, BoostSet>();
            cache.put(indexReader, readerCache);
        }
        if ((set = (BoostSet)readerCache.get(inFile)) == null || !set.field.equals(field)) {
            set = new BoostSet(indexReader, inFile, field);
            readerCache.put(inFile, set);
        }
        return set;
    }

    public final float getBoost(int docId, float defaultBoost) {
        if (docId < 0 || docId >= this.boostByDoc.length) {
            return defaultBoost;
        }
        float ret = this.boostByDoc[docId];
        if (ret == DEFAULT_MARKER) {
            return defaultBoost;
        }
        return ret;
    }

    private BoostSet(IndexReader indexReader, File inFile, String field) throws IOException {
        this.field = field;
        Trace.debug("Loading boost set '" + inFile + "'...");
        int maxDoc = indexReader.maxDoc();
        this.boostByDoc = new float[maxDoc + 1];
        Arrays.fill(this.boostByDoc, DEFAULT_MARKER);
        DocIter docIter = null;
        LineIter lineIter = null;
        try {
            docIter = new DocIter(indexReader, field);
            lineIter = new LineIter(new BufferedReader(new FileReader(inFile)));
            while (!docIter.done() && !lineIter.done()) {
                String lineKey;
                String docKey = docIter.key();
                int diff = docKey.compareTo(lineKey = lineIter.key());
                if (diff < 0) {
                    docIter.next();
                    continue;
                }
                if (diff > 0) {
                    this.warn("Boost document key '" + lineKey + "' not found in index");
                    lineIter.next();
                    continue;
                }
                int docId = docIter.docId();
                if (docId >= 0 && docId < this.boostByDoc.length) {
                    this.boostByDoc[docId] = lineIter.boost();
                }
                docIter.next();
                lineIter.next();
            }
            while (!docIter.done()) {
                docIter.next();
            }
            while (!lineIter.done()) {
                this.warn("Boost document key '" + lineIter.key() + "' not found in index");
                lineIter.next();
            }
            Trace.debug("... done loading boost set");
        }
        finally {
            if (docIter != null) {
                docIter.close();
            }
            if (lineIter != null) {
                lineIter.close();
            }
        }
    }

    private void warn(String msg) {
        ++this.nWarnings;
        if (this.nWarnings < 10) {
            Trace.warning(msg);
        } else if (this.nWarnings == 10) {
            Trace.warning("Further warnings suppressed.");
        }
    }

    private class DocIter {
        boolean done = false;
        String docKey;
        String field;
        TermPositions termPositions;
        TermEnum termEnum;

        DocIter(IndexReader indexReader, String field) throws IOException {
            this.field = field;
            this.termPositions = indexReader.termPositions();
            this.termEnum = indexReader.terms(new Term(field, ""));
            this.readDocKey();
        }

        boolean done() {
            return this.done;
        }

        String key() {
            return this.docKey;
        }

        int docId() throws IOException {
            this.termPositions.seek(this.termEnum);
            if (this.termPositions.next()) {
                return this.termPositions.doc();
            }
            assert (false) : "error reading term positions";
            return -1;
        }

        void next() throws IOException {
            if (!this.termEnum.next()) {
                this.done = true;
            }
            this.readDocKey();
        }

        void close() throws IOException {
            this.termPositions.close();
            this.termEnum.close();
        }

        private void readDocKey() {
            Term term = this.termEnum.term();
            if (!term.field().equals(this.field)) {
                this.done = true;
                return;
            }
            this.docKey = term.text();
        }
    }

    private class LineIter {
        BufferedReader reader;
        boolean done = false;
        String prevLineKey = "";
        String lineKey;
        float lineBoost;

        LineIter(BufferedReader reader) throws IOException {
            this.reader = reader;
            this.readLine();
        }

        boolean done() {
            return this.done;
        }

        String key() {
            return this.lineKey;
        }

        float boost() {
            return this.lineBoost;
        }

        void next() throws IOException {
            this.readLine();
        }

        void close() throws IOException {
            this.reader.close();
        }

        private void readLine() throws IOException {
            while (!this.done) {
                String line = this.reader.readLine();
                if (line == null) {
                    this.done = true;
                    break;
                }
                int sepPos = line.indexOf(124);
                if (sepPos < 0) {
                    BoostSet.this.warn("Boost line missing separator: '" + line + "'");
                    continue;
                }
                this.lineKey = line.substring(0, sepPos);
                this.lineBoost = Float.parseFloat(line.substring(sepPos + 1));
                if (this.lineKey.compareTo(this.prevLineKey) <= 0) {
                    Trace.error("Error: Boost set lines out of order: '" + this.prevLineKey + "' came before '" + this.lineKey + "', but should come after.");
                    this.done = true;
                    break;
                }
                this.prevLineKey = this.lineKey;
                break;
            }
        }
    }
}

