/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.chunk.DocNumMap;
import org.apache.lucene.chunk.SpanChunkedNotQuery;
import org.apache.lucene.chunk.SparseStringComparator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldSortedHitQueue;
import org.apache.lucene.search.FieldSpanSource;
import org.apache.lucene.search.FlippableStringComparator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RecordingSearcher;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SpanHitCollector;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.SpanNotNearQuery;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.spelt.SpellReader;
import org.apache.lucene.util.PriorityQueue;
import org.cdlib.xtf.textEngine.AccentFoldingRewriter;
import org.cdlib.xtf.textEngine.BoostSet;
import org.cdlib.xtf.textEngine.DocHit;
import org.cdlib.xtf.textEngine.DocHitImpl;
import org.cdlib.xtf.textEngine.HitQueue;
import org.cdlib.xtf.textEngine.IndexWarmer;
import org.cdlib.xtf.textEngine.PluralFoldingRewriter;
import org.cdlib.xtf.textEngine.QueryContext;
import org.cdlib.xtf.textEngine.QueryProcessor;
import org.cdlib.xtf.textEngine.QueryRequest;
import org.cdlib.xtf.textEngine.QueryResult;
import org.cdlib.xtf.textEngine.SlopFixupRewriter;
import org.cdlib.xtf.textEngine.SnippetMaker;
import org.cdlib.xtf.textEngine.SpanExactQuery;
import org.cdlib.xtf.textEngine.SpellSuggRewriter;
import org.cdlib.xtf.textEngine.SpellcheckParams;
import org.cdlib.xtf.textEngine.SpellingSuggestion;
import org.cdlib.xtf.textEngine.StdTermRewriter;
import org.cdlib.xtf.textEngine.TotalHitsComparator;
import org.cdlib.xtf.textEngine.UnicodeNormalizingRewriter;
import org.cdlib.xtf.textEngine.XtfBigramQueryRewriter;
import org.cdlib.xtf.textEngine.XtfLimIndexReader;
import org.cdlib.xtf.textEngine.XtfQueryTraverser;
import org.cdlib.xtf.textEngine.XtfSearcher;
import org.cdlib.xtf.textEngine.facet.DynamicGroupData;
import org.cdlib.xtf.textEngine.facet.FacetSpec;
import org.cdlib.xtf.textEngine.facet.GroupCounts;
import org.cdlib.xtf.textEngine.facet.GroupData;
import org.cdlib.xtf.textEngine.facet.ResultFacet;
import org.cdlib.xtf.textEngine.facet.ResultGroup;
import org.cdlib.xtf.textEngine.facet.StaticGroupData;
import org.cdlib.xtf.util.CharMap;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.WordMap;

public class DefaultQueryProcessor
extends QueryProcessor {
    private static HashMap searchers = new HashMap();
    private IndexReader indexReader;
    private SpellReader spellReader;
    private DocNumMap docNumMap;
    private int chunkSize;
    private int chunkOverlap;
    private Set stopSet;
    private WordMap pluralMap;
    private CharMap accentMap;
    private boolean isSparse;
    private Set tokFields;
    private int nDocsHit;
    private float maxDocScore;
    private float docScoreNorm;
    private IndexWarmer indexWarmer;
    private static final SparseStringComparator sparseStringComparator = new SparseStringComparator();
    private static final FlippableStringComparator compactStringComparator = new FlippableStringComparator();
    private static final TotalHitsComparator totalHitsComparator = new TotalHitsComparator();

    public void setIndexWarmer(IndexWarmer warmer) {
        this.indexWarmer = warmer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized QueryResult processRequest(final QueryRequest req) throws IOException {
        XtfSearcher xtfSearcher;
        this.nDocsHit = 0;
        this.maxDocScore = 0.0f;
        Vector<DocHitImpl> hitVec = new Vector<DocHitImpl>(10);
        if (this.indexWarmer == null) {
            throw new IOException("Fatal: must call setIndexWarmer() before DefaultQueryProcessor.processRequest()");
        }
        XtfSearcher xtfSearcher2 = xtfSearcher = this.indexWarmer.getSearcher(req.indexPath);
        synchronized (xtfSearcher2) {
            xtfSearcher.update();
            this.indexReader = xtfSearcher.indexReader();
            this.docNumMap = xtfSearcher.docNumMap();
            this.chunkSize = xtfSearcher.chunkSize();
            this.chunkOverlap = xtfSearcher.chunkOverlap();
            this.stopSet = xtfSearcher.stopSet();
            this.pluralMap = xtfSearcher.pluralMap();
            this.accentMap = xtfSearcher.accentMap();
            this.spellReader = xtfSearcher.spellReader();
            this.isSparse = xtfSearcher.isSparse();
            this.tokFields = xtfSearcher.tokenizedFields();
        }
        XtfLimIndexReader limReader = new XtfLimIndexReader(this.indexReader, req.workLimit > 0 ? req.workLimit : Integer.MAX_VALUE);
        int maxDocs = req.maxDocs;
        if (maxDocs < 0) {
            maxDocs = this.docNumMap.getDocCount();
        }
        final PriorityQueue docHitQueue = DefaultQueryProcessor.createHitQueue(this.indexReader, req.startDoc + req.maxDocs, req.sortMetaFields, this.isSparse);
        QueryResult result = new QueryResult();
        result.context = new QueryContext();
        result.context.accentMap = this.accentMap;
        result.context.pluralMap = this.pluralMap;
        result.context.stopSet = this.stopSet;
        result.scoresNormalized = req.normalizeScores;
        Query query = req.query;
        if (query == null) {
            result.docHits = new DocHit[0];
            return result;
        }
        query = new StdTermRewriter(this.tokFields).rewriteQuery(query);
        query = new UnicodeNormalizingRewriter(this.tokFields).rewriteQuery(query);
        if (this.accentMap != null) {
            query = new AccentFoldingRewriter(this.accentMap, this.tokFields).rewriteQuery(query);
        }
        if (this.pluralMap != null) {
            query = new PluralFoldingRewriter(this.pluralMap, this.tokFields).rewriteQuery(query);
        }
        if (this.stopSet != null) {
            query = new XtfBigramQueryRewriter(this.stopSet, this.chunkOverlap, this.tokFields).rewriteQuery(query);
        }
        if (query == null) {
            result.docHits = new DocHit[0];
            return result;
        }
        Query finalQuery = new SlopFixupRewriter(this.docNumMap, this.stopSet, this.pluralMap, this.accentMap).rewriteQuery(query);
        if (finalQuery != req.query) {
            Trace.debug("Rewritten query: " + finalQuery.toString());
        }
        final DocHitMakerImpl docHitMaker = new DocHitMakerImpl();
        final BoostSet boostSet = req.boostSetParams == null ? null : BoostSet.getCachedSet(this.indexReader, new File(req.boostSetParams.path), req.boostSetParams.field);
        RecordingSearcher searcher = new RecordingSearcher(limReader);
        final GroupCounts[] groupCounts = req.facetSpecs == null ? null : this.prepGroups(req, boostSet, searcher, finalQuery);
        searcher.search(finalQuery, null, new SpanHitCollector(){

            public void collect(int doc, float score, FieldSpanSource spanSource) {
                if ((score = DefaultQueryProcessor.this.applyBoost(doc, score, boostSet, req)) <= 0.0f) {
                    return;
                }
                DefaultQueryProcessor defaultQueryProcessor = DefaultQueryProcessor.this;
                defaultQueryProcessor.nDocsHit = defaultQueryProcessor.nDocsHit + 1;
                if (score > DefaultQueryProcessor.this.maxDocScore) {
                    DefaultQueryProcessor.this.maxDocScore = score;
                }
                docHitMaker.reset(doc, score, spanSource);
                if (req.maxDocs > 0) {
                    docHitMaker.insertInto(docHitQueue);
                }
                if (groupCounts != null) {
                    int i = 0;
                    while (i < groupCounts.length) {
                        groupCounts[i].addDoc(docHitMaker);
                        ++i;
                    }
                }
            }
        });
        int nFound = docHitQueue.size();
        DocHitImpl[] hitArray = new DocHitImpl[nFound];
        int i = 0;
        while (i < nFound) {
            int index = nFound - i - 1;
            hitArray[index] = (DocHitImpl)docHitQueue.pop();
            ++i;
        }
        this.docScoreNorm = 1.0f;
        if (req.normalizeScores && this.maxDocScore > 0.0f) {
            this.docScoreNorm = 1.0f / this.maxDocScore;
        }
        Weight weight = null;
        if (req.explainScores) {
            weight = finalQuery.weight(searcher);
        }
        SnippetMaker snippetMaker = new SnippetMaker(limReader, this.docNumMap, this.stopSet, this.pluralMap, this.accentMap, this.tokFields, req.maxContext, req.termMode, req.returnMetaFields);
        int i2 = req.startDoc;
        while (i2 < nFound) {
            if (req.explainScores) {
                hitArray[i2].finishWithExplain(snippetMaker, this.docScoreNorm, weight, boostSet, req.boostSetParams);
            } else {
                hitArray[i2].finish(snippetMaker, this.docScoreNorm);
            }
            if (result.textTerms == null) {
                result.textTerms = hitArray[i2].textTerms();
            }
            hitVec.add(hitArray[i2]);
            ++i2;
        }
        if (groupCounts != null) {
            result.facets = new ResultFacet[groupCounts.length];
            i2 = 0;
            while (i2 < groupCounts.length) {
                result.facets[i2] = groupCounts[i2].getResult();
                this.finishGroup(result.facets[i2].rootGroup, snippetMaker, req, weight, boostSet);
                ++i2;
            }
        }
        searcher.close();
        searcher = null;
        assert (req.maxDocs < 0 || hitVec.size() <= req.maxDocs);
        result.totalDocs = this.nDocsHit;
        result.startDoc = req.startDoc;
        result.endDoc = req.startDoc + hitVec.size();
        result.docHits = hitVec.toArray(new DocHit[hitVec.size()]);
        if (this.spellReader != null && req.spellcheckParams != null) {
            this.spellCheck(req, result, this.tokFields);
        }
        return result;
    }

    private void spellCheck(QueryRequest req, QueryResult res, Set tokFields) throws IOException {
        SpellcheckParams params = req.spellcheckParams;
        int totalDocs = res.totalDocs;
        if (res.facets != null) {
            int i = 0;
            while (i < res.facets.length) {
                if (res.facets[i].rootGroup != null) {
                    totalDocs = Math.max(totalDocs, res.facets[i].rootGroup.totalDocs);
                }
                ++i;
            }
        }
        if (params.docScoreCutoff > 0.0f && this.maxDocScore > params.docScoreCutoff) {
            return;
        }
        if (params.totalDocsCutoff > 0 && totalDocs > params.totalDocsCutoff) {
            return;
        }
        Set spellFieldSet = params.fields != null ? params.fields : tokFields;
        LinkedHashMap fieldsMap = this.gatherKeywords(req.query, spellFieldSet);
        LinkedHashMap<String, SpellingSuggestion> out = new LinkedHashMap<String, SpellingSuggestion>();
        for (LinkedHashSet fieldsSet : fieldsMap.keySet()) {
            String[] fields = fieldsSet.toArray(new String[fieldsSet.size()]);
            LinkedHashSet termsSet = (LinkedHashSet)fieldsMap.get(fieldsSet);
            String[] terms = termsSet.toArray(new String[termsSet.size()]);
            String[] suggested = this.spellReader.suggestKeywords(terms);
            if (suggested == null) continue;
            assert (suggested.length == terms.length);
            int i = 0;
            while (i < suggested.length) {
                if (!out.containsKey(terms[i]) && !terms[i].equals(suggested[i])) {
                    SpellingSuggestion sugg = new SpellingSuggestion();
                    sugg.origTerm = terms[i];
                    sugg.fields = fields;
                    sugg.suggestedTerm = suggested[i];
                    out.put(terms[i], sugg);
                }
                ++i;
            }
        }
        if (out.size() == 0) {
            return;
        }
        if (!this.spellingImprovesResults(req, res, spellFieldSet, out)) {
            return;
        }
        res.suggestions = out.values().toArray(new SpellingSuggestion[out.values().size()]);
    }

    private boolean spellingImprovesResults(QueryRequest origReq, QueryResult origRes, Set spellFieldSet, LinkedHashMap suggs) throws IOException {
        QueryRequest newReq = (QueryRequest)origReq.clone();
        newReq.spellcheckParams = null;
        float origMaxDocScore = this.maxDocScore;
        newReq.query = new SpellSuggRewriter(suggs, spellFieldSet).rewriteQuery(newReq.query);
        QueryResult newRes = this.processRequest(newReq);
        if (newRes.totalDocs == 0 && origRes.totalDocs == 0) {
            return false;
        }
        if (newRes.totalDocs < origRes.totalDocs) {
            return false;
        }
        return !(this.maxDocScore < origMaxDocScore);
    }

    private LinkedHashMap gatherKeywords(Query query, final Set desiredFields) {
        final LinkedHashMap termMap = new LinkedHashMap();
        XtfQueryTraverser trav = new XtfQueryTraverser(){

            private void add(Term t) {
                String field = t.field();
                String word = t.text();
                if (desiredFields != null && !desiredFields.contains(field)) {
                    return;
                }
                if (!termMap.containsKey(word)) {
                    termMap.put(word, new LinkedHashSet());
                }
                ((LinkedHashSet)termMap.get(word)).add(field);
            }

            public void traverseQuery(Query q) {
                if (q.getBoost() > 0.001f) {
                    super.traverseQuery(q);
                }
            }

            protected void traverse(TermQuery q) {
                this.add(q.getTerm());
            }

            protected void traverse(SpanTermQuery q) {
                this.add(q.getTerm());
            }

            protected void traverse(SpanExactQuery q) {
            }

            protected void traverse(BooleanQuery bq) {
                BooleanClause[] clauses = bq.getClauses();
                int i = 0;
                while (i < clauses.length) {
                    if (clauses[i].getOccur() != BooleanClause.Occur.MUST_NOT) {
                        this.traverseQuery(clauses[i].getQuery());
                    }
                    ++i;
                }
            }

            protected void traverse(SpanChunkedNotQuery nq) {
                this.traverseQuery(nq.getInclude());
            }

            protected void traverse(SpanNotQuery nq) {
                this.traverseQuery(nq.getInclude());
            }

            protected void traverse(SpanNotNearQuery nq) {
                this.traverseQuery(nq.getInclude());
            }
        };
        trav.traverseQuery(query);
        LinkedHashMap fieldsMap = new LinkedHashMap();
        for (String word : termMap.keySet()) {
            LinkedHashSet fieldsSet = (LinkedHashSet)termMap.get(word);
            if (!fieldsMap.containsKey(fieldsSet)) {
                fieldsMap.put(fieldsSet, new LinkedHashSet());
            }
            ((LinkedHashSet)fieldsMap.get(fieldsSet)).add(word);
        }
        return fieldsMap;
    }

    private GroupCounts[] prepGroups(final QueryRequest req, final BoostSet boostSet, RecordingSearcher searcher, Query query) throws IOException {
        GroupData[] groupData = new GroupData[req.facetSpecs.length];
        Vector<GroupData> dynamicGroupVec = new Vector<GroupData>();
        int i = 0;
        while (i < req.facetSpecs.length) {
            FacetSpec spec = req.facetSpecs[i];
            if (spec.field.startsWith("java:")) {
                groupData[i] = this.createDynamicGroup(this.indexReader, spec.field);
                dynamicGroupVec.add(groupData[i]);
            } else {
                groupData[i] = StaticGroupData.getCachedData(this.indexReader, spec.field);
            }
            ++i;
        }
        if (!dynamicGroupVec.isEmpty()) {
            final DynamicGroupData[] dynGroups = dynamicGroupVec.toArray(new DynamicGroupData[dynamicGroupVec.size()]);
            searcher.search(query, null, new SpanHitCollector(){

                public void collect(int doc, float score, FieldSpanSource spanSource) {
                    if ((score = DefaultQueryProcessor.this.applyBoost(doc, score, boostSet, req)) > 0.0f) {
                        int i = 0;
                        while (i < dynGroups.length) {
                            dynGroups[i].collect(doc, score);
                            ++i;
                        }
                    }
                }
            });
            int i2 = 0;
            while (i2 < dynGroups.length) {
                dynGroups[i2].finish();
                ++i2;
            }
        }
        GroupCounts[] groupCounts = new GroupCounts[req.facetSpecs.length];
        int i3 = 0;
        while (i3 < req.facetSpecs.length) {
            FacetSpec spec = req.facetSpecs[i3];
            HitQueueMakerImpl maker = new HitQueueMakerImpl(this.indexReader, spec.sortDocsBy, this.isSparse);
            groupCounts[i3] = new GroupCounts(groupData[i3], spec, maker);
            ++i3;
        }
        return groupCounts;
    }

    private GroupData createDynamicGroup(IndexReader indexReader, String field) throws IOException {
        Pattern pat = Pattern.compile("java:([\\w.]+)\\((.*)\\)");
        Matcher matcher = pat.matcher(field);
        if (!matcher.matches()) {
            throw new RuntimeException("Unrecognized dynamic facet field '" + field + "'");
        }
        String className = matcher.group(1);
        String params = matcher.group(2);
        DynamicGroupData dynData = null;
        try {
            Class<?> c = Class.forName(className);
            dynData = (DynamicGroupData)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Dynamic facet class '" + className + "' not found");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate dynamic facet class '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot instantiate dynamic facet class '" + className + "'", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Class '" + className + "' must be derived from DynamicGroupData");
        }
        dynData.init(indexReader, this.tokFields, params);
        return dynData;
    }

    private void finishGroup(ResultGroup group, SnippetMaker snippetMaker, QueryRequest req, Weight weight, BoostSet boostSet) throws IOException {
        if (group.docHits != null) {
            int k = 0;
            while (k < group.docHits.length) {
                DocHitImpl hit = (DocHitImpl)group.docHits[k];
                if (req.explainScores) {
                    hit.finishWithExplain(snippetMaker, this.docScoreNorm, weight, boostSet, req.boostSetParams);
                } else {
                    hit.finish(snippetMaker, this.docScoreNorm);
                }
                ++k;
            }
        }
        if (group.subGroups != null) {
            int j = 0;
            while (j < group.subGroups.length) {
                this.finishGroup(group.subGroups[j], snippetMaker, req, weight, boostSet);
                ++j;
            }
        }
    }

    public void resetCache() {
        searchers.clear();
    }

    private float applyBoost(int doc, float score, BoostSet boostSet, QueryRequest req) {
        if (score > 0.0f && boostSet != null) {
            float boost = boostSet.getBoost(doc, req.boostSetParams.defaultBoost);
            if (req.boostSetParams.exponent != 1.0f) {
                boost = (float)Math.pow(boost, req.boostSetParams.exponent);
            }
            score *= boost;
        }
        return score;
    }

    private static PriorityQueue createHitQueue(IndexReader reader, int inSize, String sortFields, boolean isSparse) throws IOException {
        PriorityQueue ret;
        int size;
        int n = size = inSize >= 999999 ? 1 : inSize;
        if (sortFields == null) {
            ret = new HitQueue(size);
        } else {
            Vector<String> fieldNames = new Vector<String>();
            StringTokenizer st = new StringTokenizer(sortFields, " \t\r\n,;");
            while (st.hasMoreTokens()) {
                fieldNames.add(st.nextToken());
            }
            if (fieldNames.size() == 0) {
                ret = new HitQueue(size);
            } else {
                SortField[] fields = new SortField[fieldNames.size() + 2];
                int i = 0;
                while (i < fieldNames.size()) {
                    String finalName;
                    String name = (String)fieldNames.elementAt(i);
                    boolean ascending = false;
                    boolean descending = false;
                    boolean emptyFirst = false;
                    boolean emptyLast = false;
                    if (name.startsWith("-")) {
                        descending = true;
                        name = name.substring(1);
                    } else if (name.startsWith("+")) {
                        ascending = true;
                        name = name.substring(1);
                    }
                    String[] parts = name.split(":");
                    name = parts[0];
                    int j = 1;
                    while (j < parts.length) {
                        if (parts[j].equalsIgnoreCase("ascending")) {
                            ascending = true;
                        } else if (parts[j].equalsIgnoreCase("descending")) {
                            descending = true;
                        } else if (parts[j].equalsIgnoreCase("emptyFirst")) {
                            emptyFirst = true;
                        } else if (parts[j].equalsIgnoreCase("emptyLast")) {
                            emptyLast = true;
                        } else {
                            throw new IOException("Unknown sort modifier: '" + parts[j] + "'");
                        }
                        ++j;
                    }
                    if (ascending && descending || emptyFirst && emptyLast) {
                        throw new IOException("Conflicting sort modifiers");
                    }
                    boolean reverse = ascending ? false : descending;
                    boolean flipEmpty = !reverse ? (emptyFirst ? true : (emptyLast ? false : false)) : (emptyFirst ? false : (emptyLast ? true : true));
                    String string = finalName = flipEmpty ? String.valueOf(name) + ":flipEmpty" : name;
                    if (name.equals("score") || name.equals("relevance")) {
                        if (reverse || flipEmpty) {
                            throw new RuntimeException("Illegal modifier on sortDocsBy 'score'");
                        }
                        fields[i] = SortField.FIELD_SCORE;
                    } else {
                        fields[i] = name.equals("totalHits") ? new SortField(finalName, totalHitsComparator, reverse) : (isSparse ? new SortField(finalName, sparseStringComparator, reverse) : new SortField(finalName, compactStringComparator, reverse));
                    }
                    ++i;
                }
                fields[fieldNames.size()] = SortField.FIELD_SCORE;
                fields[fieldNames.size() + 1] = SortField.FIELD_DOC;
                ret = new FieldSortedHitQueue(reader, fields, size);
            }
        }
        if (inSize >= 999999) {
            ret.setExpandable();
        }
        return ret;
    }

    private static class DocHitMakerImpl
    implements GroupCounts.DocHitMaker {
        private int doc;
        private float score;
        private FieldSpanSource spanSrc;
        private DocHitImpl docHit;

        private DocHitMakerImpl() {
        }

        public final void reset(int doc, float score, FieldSpanSource spanSrc) {
            this.doc = doc;
            this.score = score;
            this.spanSrc = spanSrc;
            this.docHit = null;
        }

        public final int getDocNum() {
            return this.doc;
        }

        public final float getScore() {
            return this.score;
        }

        public final boolean insertInto(PriorityQueue queue) {
            if (this.docHit == null) {
                this.docHit = new DocHitImpl(this.doc, this.score);
            }
            try {
                this.docHit.setSpanSource(this.spanSrc);
                boolean inserted = queue.insert(this.docHit);
                if (inserted) {
                    this.docHit.totalSnippets();
                }
                boolean bl = inserted;
                return bl;
            }
            finally {
                this.docHit.setSpanSource(null);
            }
        }
    }

    private static class HitQueueMakerImpl
    implements GroupCounts.HitQueueMaker {
        private IndexReader reader;
        private String sortFields;
        private boolean isSparse;

        public HitQueueMakerImpl(IndexReader reader, String sortFields, boolean isSparse) {
            this.reader = reader;
            this.sortFields = sortFields;
            this.isSparse = isSparse;
        }

        public PriorityQueue makeQueue(int size) {
            try {
                return DefaultQueryProcessor.createHitQueue(this.reader, size, this.sortFields, this.isSparse);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

