/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.SpanOrNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.PriorityQueue;
import org.cdlib.xtf.textIndexer.XTFTextAnalyzer;
import org.cdlib.xtf.util.CharMap;
import org.cdlib.xtf.util.Trace;
import org.cdlib.xtf.util.WordMap;

public class MoreLikeThisQuery
extends Query {
    private Query subQuery;
    private int targetDoc;
    private Set stopSet;
    private WordMap pluralMap;
    private CharMap accentMap;
    private int minTermFreq = 1;
    private int minDocFreq = 2;
    private int maxDocFreq = -1;
    private boolean boost = true;
    private String[] fieldNames = null;
    private float[] fieldBoosts = null;
    private Map boostMap = new HashMap();
    private int maxNumTokensParsed = 5000;
    private int minWordLen = 4;
    private int maxWordLen = 12;
    private int maxQueryTerms = 10;
    private Similarity similarity = new DefaultSimilarity();

    public MoreLikeThisQuery(Query subQuery) {
        this.subQuery = subQuery;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public void setSubQuery(Query subQuery) {
        this.subQuery = subQuery;
    }

    public void setStopWords(Set set) {
        this.stopSet = set;
    }

    public void setPluralMap(WordMap map) {
        this.pluralMap = map;
    }

    public void setAccentMap(CharMap map) {
        this.accentMap = map;
    }

    public void setMaxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
    }

    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldBoosts(float[] fieldBoosts) {
        this.fieldBoosts = fieldBoosts;
    }

    public float[] getFieldBoosts() {
        return this.fieldBoosts;
    }

    public void setMaxNumTokensParsed(int maxNumTokensParsed) {
        this.maxNumTokensParsed = maxNumTokensParsed;
    }

    public void setMaxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
    }

    public void setMaxWordLen(int maxWordLen) {
        this.maxWordLen = maxWordLen;
    }

    public void setMinDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public void setMinTermFreq(int minTermFreq) {
        this.minTermFreq = minTermFreq;
    }

    public void setMinWordLen(int minWordLen) {
        this.minWordLen = minWordLen;
    }

    public void setBoost(boolean boost) {
        this.boost = boost;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        int i;
        if (this.fieldBoosts != null && this.fieldBoosts.length != this.fieldNames.length) {
            throw new RuntimeException("Error: different number of boosts than fields specified to MoreLikeThisQuery");
        }
        IndexSearcher searcher = new IndexSearcher(reader);
        this.targetDoc = -1;
        HitCollector collector = new HitCollector(){

            public void collect(int doc, float score) {
                if (MoreLikeThisQuery.this.targetDoc < 0) {
                    MoreLikeThisQuery.this.targetDoc = doc;
                }
            }
        };
        searcher.search(this.subQuery, collector);
        if (this.targetDoc < 0) {
            return new TermQuery(new Term("fribbleSnarf", "!*@&#(*&"));
        }
        String[] fields = this.fieldNames;
        if (this.fieldBoosts != null) {
            ArrayList<String> filteredFields = new ArrayList<String>();
            i = 0;
            while (i < this.fieldNames.length) {
                if (this.fieldBoosts[i] > 0.0f) {
                    filteredFields.add(this.fieldNames[i]);
                    this.boostMap.put(this.fieldNames[i], new Float(this.fieldBoosts[i]));
                }
                ++i;
            }
            fields = filteredFields.toArray(new String[filteredFields.size()]);
        }
        if (this.maxDocFreq < 0) {
            int nDocs = reader.docFreq(new Term("docInfo", "1"));
            this.maxDocFreq = Math.max(5, nDocs / 20);
        }
        XTFTextAnalyzer analyzer = new XTFTextAnalyzer(null, this.pluralMap, this.accentMap);
        i = 0;
        while (i < fields.length) {
            if (fields[i].indexOf("facet") >= 0) {
                analyzer.addFacetField(fields[i]);
            }
            ++i;
        }
        PriorityQueue bestTerms = this.retrieveTerms(reader, this.targetDoc, analyzer);
        Query rawQuery = this.createQuery(reader, bestTerms);
        MoreLikeWrapper ret = new MoreLikeWrapper(this, rawQuery);
        if (Trace.getOutputLevel() >= 8) {
            Trace.debug("More-like query: " + ret);
        }
        return ret;
    }

    private Query createQuery(IndexReader indexReader, PriorityQueue q) throws IOException {
        QueryWord[] queryWords = new QueryWord[q.size()];
        int i = q.size() - 1;
        while (i >= 0) {
            queryWords[i] = (QueryWord)q.pop();
            --i;
        }
        BooleanQuery query = new BooleanQuery(true);
        int i2 = 0;
        while (i2 < this.fieldNames.length) {
            ArrayList<SpanTermQuery> fieldClauses = new ArrayList<SpanTermQuery>();
            int j = 0;
            while (j < queryWords.length) {
                QueryWord qw = queryWords[j];
                Term term = new Term(this.fieldNames[i2], qw.word);
                int docFreq = indexReader.docFreq(term);
                if (docFreq != 0) {
                    SpanTermQuery tq = new SpanTermQuery(term);
                    if (this.boost) {
                        tq.setBoost(qw.score);
                    }
                    fieldClauses.add(tq);
                }
                ++j;
            }
            if (!fieldClauses.isEmpty()) {
                SpanQuery[] clauses = fieldClauses.toArray(new SpanQuery[fieldClauses.size()]);
                SpanOrNearQuery fieldQuery = new SpanOrNearQuery(clauses, 10, false);
                if (this.fieldBoosts != null) {
                    fieldQuery.setBoost(this.fieldBoosts[i2]);
                }
                if (this.fieldNames[i2].equals("text")) {
                    throw new RuntimeException("MoreLikeThisQuery does not support 'text' field.");
                }
                query.add(fieldQuery, BooleanClause.Occur.SHOULD);
            }
            ++i2;
        }
        return query;
    }

    private PriorityQueue createQueue(IndexReader indexReader, Map words) throws IOException {
        int queueSize = Math.min(words.size(), this.maxQueryTerms);
        QueryWordQueue queue = new QueryWordQueue(queueSize);
        for (String word : words.keySet()) {
            float score = ((Flt)words.get((Object)word)).x;
            queue.insert(new QueryWord(word, score));
        }
        return queue;
    }

    private Map condenseTerms(IndexReader indexReader, Map words) throws IOException {
        HashMap<String, Flt> termScoreMap = new HashMap<String, Flt>();
        int numDocs = indexReader.numDocs();
        for (Term term : words.keySet()) {
            String word;
            int tf = ((Int)words.get((Object)term)).x;
            if (this.minTermFreq > 0 && tf < this.minTermFreq) continue;
            int docFreq = indexReader.docFreq(term);
            if (this.minDocFreq > 0 && docFreq < this.minDocFreq || this.maxDocFreq > 0 && docFreq > this.maxDocFreq || docFreq == 0) continue;
            float idf = this.similarity.idf(docFreq, numDocs);
            float score = (float)tf * idf;
            Float found = (Float)this.boostMap.get(term.field());
            if (found != null) {
                score *= found.floatValue();
            }
            if (!termScoreMap.containsKey(word = term.text())) {
                termScoreMap.put(word, new Flt());
            }
            Flt cnt = (Flt)termScoreMap.get(word);
            cnt.x += score;
        }
        return termScoreMap;
    }

    private PriorityQueue retrieveTerms(IndexReader indexReader, int docNum, Analyzer analyzer) throws IOException {
        HashMap termFreqMap = new HashMap();
        Document d = indexReader.document(docNum);
        int i = 0;
        while (i < this.fieldNames.length) {
            String fieldName = this.fieldNames[i];
            String[] text = d.getValues(fieldName);
            if (text != null) {
                int j = 0;
                while (j < text.length) {
                    TokenStream tokens = analyzer.tokenStream(fieldName, new StringReader(text[j]));
                    this.addTermFrequencies(tokens, fieldName, termFreqMap);
                    ++j;
                }
            }
            ++i;
        }
        Map termScoreMap = this.condenseTerms(indexReader, termFreqMap);
        return this.createQueue(indexReader, termScoreMap);
    }

    private void addTermFrequencies(TokenStream tokens, String field, Map termFreqMap) throws IOException {
        Token token;
        int tokenCount = 0;
        while ((token = tokens.next()) != null) {
            if (++tokenCount > this.maxNumTokensParsed) break;
            String word = token.termText();
            if (this.isNoiseWord(word)) continue;
            Term term = new Term(field, word.toLowerCase());
            Int cnt = (Int)termFreqMap.get(term);
            if (cnt == null) {
                termFreqMap.put(term, new Int());
                continue;
            }
            ++cnt.x;
        }
    }

    protected boolean isNoiseWord(String term) {
        int len = term.length();
        if (term.length() > 0 && (term.charAt(0) == '\uebeb' || term.charAt(term.length() - 1) == '\uee1d')) {
            return true;
        }
        if (this.minWordLen > 0 && len < this.minWordLen) {
            return true;
        }
        if (this.maxWordLen > 0 && len > this.maxWordLen) {
            return true;
        }
        return this.stopSet != null && this.stopSet.contains(term);
    }

    public String toString(String field) {
        return "moreLikeThis(" + this.subQuery.toString(field) + ")";
    }

    private static class Flt {
        public float x;

        private Flt() {
        }
    }

    private static class Int {
        public int x = 1;
    }

    public class MoreLikeWrapper
    extends Query {
        MoreLikeThisQuery outerQuery;
        String outerDescrip;
        Query innerQuery;
        String innerDescrip;

        public MoreLikeWrapper(MoreLikeThisQuery outerQuery, Query innerQuery) {
            this.outerQuery = outerQuery;
            this.innerQuery = innerQuery;
            this.innerDescrip = "weight(" + innerQuery.toString() + ")";
            this.outerDescrip = "weight(" + outerQuery.toString() + ")";
        }

        public Weight createWeight(final Searcher searcher) {
            Weight x = null;
            try {
                x = this.innerQuery.weight(searcher);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            final Weight weight = x;
            return new Weight(){

                public float getValue() {
                    return weight.getValue();
                }

                public float sumOfSquaredWeights() throws IOException {
                    return weight.sumOfSquaredWeights();
                }

                public void normalize(float v) {
                    weight.normalize(v);
                }

                public Explanation explain(IndexReader ir, int i) throws IOException {
                    Explanation innerExpl = weight.explain(ir, i);
                    Explanation wrapperExpl = new Explanation(innerExpl.getValue(), MoreLikeWrapper.this.innerDescrip);
                    wrapperExpl.addDetail(innerExpl);
                    Explanation outerExpl = new Explanation(innerExpl.getValue(), MoreLikeWrapper.this.outerDescrip);
                    outerExpl.addDetail(wrapperExpl);
                    return outerExpl;
                }

                public Query getQuery() {
                    return MoreLikeWrapper.this;
                }

                public Scorer scorer(IndexReader indexReader) throws IOException {
                    final Scorer scorer = weight.scorer(indexReader);
                    return new Scorer(MoreLikeWrapper.this.innerQuery.getSimilarity(searcher)){

                        public boolean next() throws IOException {
                            return scorer.next();
                        }

                        public int doc() {
                            return scorer.doc();
                        }

                        public boolean skipTo(int i) throws IOException {
                            return scorer.skipTo(i);
                        }

                        public float score() throws IOException {
                            return MoreLikeThisQuery.this.targetDoc != scorer.doc() ? scorer.score() : 0.0f;
                        }

                        public Explanation explain(int i) throws IOException {
                            Explanation exp = scorer.explain(i);
                            if (MoreLikeThisQuery.this.targetDoc != i) {
                                exp.setDescription("allowed by filter: " + exp.getDescription());
                            } else {
                                exp.setDescription("removed by filter: " + exp.getDescription());
                            }
                            return exp;
                        }
                    };
                }
            };
        }

        public Query getQuery() {
            return this.innerQuery;
        }

        public String toString(String s) {
            return "excludeDoc(" + MoreLikeThisQuery.this.targetDoc + "," + this.innerQuery.toString(s) + ")";
        }

        public boolean equals(Object o) {
            if (o instanceof MoreLikeWrapper) {
                MoreLikeWrapper fq = (MoreLikeWrapper)o;
                return this.innerQuery.equals(fq.innerQuery);
            }
            return false;
        }

        public int hashCode() {
            return this.innerQuery.hashCode();
        }
    }

    private static class QueryWord {
        public String word;
        public float score;

        public QueryWord(String word, float score) {
            this.word = word;
            this.score = score;
        }
    }

    private static class QueryWordQueue
    extends PriorityQueue {
        QueryWordQueue(int s) {
            this.initialize(s);
        }

        protected boolean lessThan(Object a, Object b) {
            QueryWord aa = (QueryWord)a;
            QueryWord bb = (QueryWord)b;
            return aa.score < bb.score;
        }
    }
}

