/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.lucene.search.Explanation;
import org.cdlib.xtf.servletBase.TextServlet;
import org.cdlib.xtf.textEngine.DocHit;
import org.cdlib.xtf.textEngine.QueryContext;
import org.cdlib.xtf.textEngine.Snippet;
import org.cdlib.xtf.textEngine.SpellingSuggestion;
import org.cdlib.xtf.textEngine.facet.ResultFacet;
import org.cdlib.xtf.textEngine.facet.ResultGroup;
import org.cdlib.xtf.util.Attrib;

public class QueryResult {
    public QueryContext context;
    public Set textTerms;
    public int totalDocs;
    public int startDoc;
    public int endDoc;
    public boolean scoresNormalized;
    public DocHit[] docHits;
    public ResultFacet[] facets;
    public SpellingSuggestion[] suggestions;
    private DecimalFormat decFormat;

    public Source hitsToSource(String mainTagName, String extraStuff) {
        String str = this.hitsToString(mainTagName, extraStuff);
        return new StreamSource(new StringReader(str));
    }

    public String hitsToString(String mainTagName, String extraStuff) {
        StringBuffer buf = new StringBuffer(1000);
        buf.append("<" + mainTagName + " totalDocs=\"" + this.totalDocs + "\" " + " startDoc=\"" + Math.min(this.startDoc + 1, this.endDoc) + "\" " + " endDoc=\"" + this.endDoc + "\">");
        if (extraStuff != null) {
            buf.append(extraStuff);
        }
        if (this.suggestions != null) {
            this.structureSuggestions(buf);
        }
        this.structureDocHits(this.docHits, this.startDoc, buf);
        if (this.facets != null) {
            int i = 0;
            while (i < this.facets.length) {
                ResultFacet facet = this.facets[i];
                buf.append("<facet field=\"" + facet.field + "\" " + "totalGroups=\"" + facet.rootGroup.totalSubGroups + "\" " + "totalDocs=\"" + facet.rootGroup.totalDocs + "\">");
                if (facet.rootGroup.subGroups != null) {
                    int j = 0;
                    while (j < facet.rootGroup.subGroups.length) {
                        this.structureGroup(facet.rootGroup.subGroups[j], buf);
                        ++j;
                    }
                }
                buf.append("</facet>");
                ++i;
            }
        }
        buf.append("</" + mainTagName + ">\n");
        return buf.toString();
    }

    private void structureGroup(ResultGroup group, StringBuffer buf) {
        String groupValue = group.value;
        if (groupValue.equals("<empty>")) {
            groupValue = "";
        }
        buf.append("<group value=\"" + TextServlet.makeHtmlString(groupValue) + "\" " + "rank=\"" + (group.rank + 1) + "\" " + "totalSubGroups=\"" + group.totalSubGroups + "\" " + "totalDocs=\"" + group.totalDocs + "\" " + "startDoc=\"" + (group.endDoc > 0 ? group.startDoc + 1 : 0) + "\" " + "endDoc=\"" + group.endDoc + "\">");
        if (group.docHits != null) {
            this.structureDocHits(group.docHits, group.startDoc, buf);
        }
        if (group.subGroups != null) {
            int i = 0;
            while (i < group.subGroups.length) {
                this.structureGroup(group.subGroups[i], buf);
                ++i;
            }
        }
        buf.append("</group>");
    }

    private void structureDocHits(DocHit[] docHits, int startDoc, StringBuffer buf) {
        if (docHits == null) {
            return;
        }
        int i = 0;
        while (i < docHits.length) {
            String scoreStr;
            DocHit docHit = docHits[i];
            if (this.scoresNormalized) {
                scoreStr = Integer.toString(Math.round(docHit.score * 100.0f));
            } else {
                if (this.decFormat == null) {
                    this.decFormat = (DecimalFormat)DecimalFormat.getInstance();
                }
                scoreStr = this.decFormat.format(docHit.score);
            }
            buf.append("<docHit rank=\"" + (i + startDoc + 1) + "\"" + " path=\"" + TextServlet.makeHtmlString(docHit.filePath()) + "\"" + " score=\"" + scoreStr + "\"" + " totalHits=\"" + docHit.totalSnippets() + "\"");
            if (docHit.recordNum() > 0) {
                buf.append(" recordNum=\"" + docHit.recordNum() + "\"");
            }
            if (docHit.subDocument() != null) {
                buf.append(" subDocument=\"" + TextServlet.makeHtmlString(docHit.subDocument()) + "\"");
            }
            buf.append(">\n");
            Explanation explanation = docHit.explanation();
            if (explanation != null) {
                this.structureExplanation(explanation, buf);
            }
            if (!docHit.metaData().isEmpty()) {
                buf.append("<meta>\n");
                Iterator atts = docHit.metaData().iterator();
                while (atts.hasNext()) {
                    Attrib attrib = (Attrib)atts.next();
                    buf.append(attrib.value);
                }
                buf.append("</meta>\n");
            }
            int j = 0;
            while (j < docHit.nSnippets()) {
                Snippet snippet = docHit.snippet(j, true);
                buf.append("<snippet rank=\"" + (j + 1) + "\" score=\"" + Math.round(snippet.score * 100.0f) + "\"");
                if (snippet.sectionType != null) {
                    buf.append(" sectionType=\"" + snippet.sectionType + "\"");
                }
                buf.append(">" + TextServlet.makeHtmlString(snippet.text, true) + "</snippet>\n");
                ++j;
            }
            buf.append("</docHit>\n");
            ++i;
        }
    }

    private void structureExplanation(Explanation exp, StringBuffer buf) {
        buf.append("<explanation value=\"");
        buf.append(exp.getValue());
        buf.append("\" description=\"");
        buf.append(exp.getDescription());
        buf.append("\">\n");
        Explanation[] subs = exp.getDetails();
        if (subs != null) {
            int i = 0;
            while (i < subs.length) {
                this.structureExplanation(subs[i], buf);
                ++i;
            }
        }
        buf.append("</explanation>\n");
    }

    private void structureSuggestions(StringBuffer buf) {
        buf.append("<spelling>\n");
        int i = 0;
        while (i < this.suggestions.length) {
            SpellingSuggestion sugg = this.suggestions[i];
            StringBuffer fieldsBuf = new StringBuffer();
            int j = 0;
            while (j < sugg.fields.length) {
                if (fieldsBuf.length() > 0) {
                    fieldsBuf.append(",");
                }
                fieldsBuf.append(sugg.fields[j]);
                ++j;
            }
            buf.append("  <suggestion originalTerm=\"" + TextServlet.makeHtmlString(sugg.origTerm) + "\"" + " fields=\"" + fieldsBuf + "\"" + " suggestedTerm=\"" + (sugg.suggestedTerm != null ? TextServlet.makeHtmlString(sugg.suggestedTerm) : "") + "\"" + "/>\n");
            ++i;
        }
        buf.append("</spelling>\n");
    }
}

