/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;

public class SpanSectionTypeQuery
extends SpanQuery {
    private SpanQuery textQuery;
    private SpanQuery typeQuery;

    public SpanSectionTypeQuery(SpanQuery textQuery, SpanQuery sectionTypeQuery) {
        this.typeQuery = sectionTypeQuery;
        this.textQuery = textQuery;
    }

    public SpanQuery getTextQuery() {
        return this.textQuery;
    }

    public SpanQuery getSectionTypeQuery() {
        return this.typeQuery;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        SpanQuery rewrittenText = (SpanQuery)this.textQuery.rewrite(reader);
        SpanQuery rewrittenType = (SpanQuery)this.typeQuery.rewrite(reader);
        if (rewrittenText == this.textQuery && rewrittenType == this.typeQuery) {
            return this;
        }
        SpanSectionTypeQuery clone = (SpanSectionTypeQuery)this.clone();
        clone.textQuery = rewrittenText;
        clone.typeQuery = rewrittenType;
        return clone;
    }

    public Spans getSpans(IndexReader reader, Searcher searcher) throws IOException {
        return new Spans(reader, searcher){
            private Spans typeSpans;
            private boolean moreType;
            private Spans textSpans;
            private boolean moreText;
            private boolean firstTime;
            {
                this.typeSpans = SpanSectionTypeQuery.this.typeQuery.getSpans(indexReader, searcher);
                this.moreType = true;
                this.textSpans = SpanSectionTypeQuery.this.textQuery.getSpans(indexReader, searcher);
                this.moreText = true;
                this.firstTime = true;
            }

            public boolean next() throws IOException {
                if (this.moreText) {
                    this.moreText = this.textSpans.next();
                }
                if (this.firstTime) {
                    this.moreType = this.typeSpans.next();
                    this.firstTime = false;
                }
                return this.advance();
            }

            public boolean skipTo(int target) throws IOException {
                this.moreText = this.textSpans.skipTo(target);
                this.moreType = this.typeSpans.skipTo(target);
                return this.advance();
            }

            private boolean advance() throws IOException {
                while (this.moreText && this.moreType) {
                    int typeChunk;
                    int textChunk = this.textSpans.doc();
                    if (textChunk < (typeChunk = this.typeSpans.doc())) {
                        this.moreText = this.textSpans.skipTo(typeChunk);
                        continue;
                    }
                    if (textChunk <= typeChunk) break;
                    this.moreType = this.typeSpans.skipTo(textChunk);
                }
                return this.moreText && this.moreType;
            }

            public int doc() {
                return this.textSpans.doc();
            }

            public int start() {
                return this.textSpans.start();
            }

            public int end() {
                return this.textSpans.end();
            }

            public float score() {
                return this.textSpans.score() * SpanSectionTypeQuery.this.getBoost();
            }

            public String toString() {
                return this.textSpans.toString();
            }

            public Explanation explain() throws IOException {
                if (SpanSectionTypeQuery.this.getBoost() == 1.0f) {
                    return this.textSpans.explain();
                }
                Explanation result = new Explanation(0.0f, "weight(" + this.toString() + "), product of:");
                Explanation boostExpl = new Explanation(SpanSectionTypeQuery.this.getBoost(), "boost");
                result.addDetail(boostExpl);
                Explanation inclExpl = this.textSpans.explain();
                result.addDetail(inclExpl);
                result.setValue(boostExpl.getValue() * inclExpl.getValue());
                return result;
            }
        };
    }

    public String getField() {
        return this.textQuery.getField();
    }

    public Collection getTerms() {
        return this.textQuery.getTerms();
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("spanSectionType(");
        buffer.append(this.textQuery.toString(field));
        buffer.append(",");
        buffer.append(this.typeQuery.toString(field));
        buffer.append(")");
        return buffer.toString();
    }
}

