/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.IOException;
import org.apache.lucene.chunk.DocNumMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;

public class XtfDocNumMap
implements DocNumMap {
    private IndexReader reader;
    private int chunkSize;
    private int chunkOverlap;
    private int nDocs;
    private int[] docNums = null;
    private int prevNum = -1;
    private int low = -1;
    private int high = -1;

    public XtfDocNumMap(IndexReader reader, int chunkSize, int chunkOverlap) throws IOException {
        this.reader = reader;
        this.chunkSize = chunkSize;
        this.chunkOverlap = chunkOverlap;
    }

    private synchronized void load() {
        if (this.docNums != null) {
            return;
        }
        try {
            Term term = new Term("docInfo", "1");
            this.nDocs = this.reader.docFreq(term);
            this.docNums = new int[this.nDocs];
            TermDocs docHeaders = this.reader.termDocs(term);
            int i = 0;
            while (docHeaders.next()) {
                this.docNums[i++] = docHeaders.doc();
            }
            this.nDocs = i;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public int getChunkOverlap() {
        return this.chunkOverlap;
    }

    public final int getDocCount() {
        return this.nDocs;
    }

    public final synchronized int getDocNum(int chunkNumber) {
        this.scan(chunkNumber);
        if (this.high == this.nDocs) {
            return -1;
        }
        return this.docNums[this.high];
    }

    public final synchronized int getFirstChunk(int docNum) {
        this.scan(docNum);
        if (this.low < 0 || this.docNums[this.low] != docNum) {
            return -1;
        }
        if (this.low == 0) {
            return 1;
        }
        return this.docNums[this.low - 1] + 1;
    }

    public final int getLastChunk(int docNum) {
        return docNum - 1;
    }

    private void scan(int num) {
        if (num == this.prevNum) {
            return;
        }
        this.load();
        int high = this.nDocs;
        int low = -1;
        while (high - low > 1) {
            int probe = (high + low) / 2;
            if (this.docNums[probe] > num) {
                high = probe;
                continue;
            }
            low = probe;
        }
        assert (low == -1 || this.docNums[low] <= num);
        assert (high == this.nDocs || this.docNums[high] > num);
        this.low = low;
        this.high = high;
    }
}

