/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.bigram.BigramQueryRewriter;
import org.apache.lucene.chunk.DocNumMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.spelt.SpellReader;
import org.apache.lucene.store.Directory;
import org.cdlib.xtf.textEngine.NativeFSDirectory;
import org.cdlib.xtf.textEngine.XtfDocNumMap;
import org.cdlib.xtf.textEngine.XtfWordEquiv;
import org.cdlib.xtf.util.CharMap;
import org.cdlib.xtf.util.Path;
import org.cdlib.xtf.util.WordMap;

public class XtfSearcher {
    private String indexPath;
    private Directory directory;
    private long updatePeriod;
    private long lastCheckTime;
    private long curVersion;
    private long newVersion;
    private IndexReader indexReader;
    private DocNumMap docNumMap;
    private SpellReader spellReader;
    private int chunkSize;
    private int chunkOverlap;
    private Set stopSet;
    private WordMap pluralMap;
    private CharMap accentMap;
    private Set indexedFields;
    private Set tokenizedFields;
    private boolean isSparse;

    public XtfSearcher(String indexPath, int updateCheckSeconds) throws IOException {
        this(indexPath, NativeFSDirectory.getDirectory(indexPath), updateCheckSeconds);
    }

    public XtfSearcher(String indexPath, Directory dir, int updateCheckSeconds) throws IOException {
        this.indexPath = indexPath;
        this.directory = dir;
        this.curVersion = -99L;
        this.updatePeriod = (long)updateCheckSeconds * 1000L;
        this.update();
    }

    public boolean isUpToDate() throws IOException {
        this.newVersion = IndexReader.getCurrentVersion(this.directory);
        return this.newVersion == this.curVersion;
    }

    public void update() throws IOException {
        File spellDir;
        String pluralMapName;
        String accentMapName;
        if (this.curVersion >= 0L) {
            long time = System.currentTimeMillis();
            if (time - this.lastCheckTime < this.updatePeriod) {
                return;
            }
            this.lastCheckTime = time;
        }
        if (this.isUpToDate()) {
            return;
        }
        if (this.curVersion >= 0L && this.updatePeriod == 0L) {
            return;
        }
        this.close();
        this.indexReader = IndexReader.open(this.directory);
        Hits match = new IndexSearcher(this.indexReader).search(new TermQuery(new Term("indexInfo", "1")));
        if (match.length() == 0) {
            throw new IOException("Index missing indexInfo doc");
        }
        assert (match.id(0) == 0) : "indexInfo chunk must be first in index";
        Document doc = match.doc(0);
        String indexVersion = doc.get("xtfIndexVersion");
        if (indexVersion == null) {
            indexVersion = "1.0";
        }
        if (indexVersion.compareTo("2.2b") < 0) {
            throw new IOException("Incompatible index version " + indexVersion + "; require at least " + "2.2b" + "... consider re-indexing with '-clean'.");
        }
        this.chunkSize = Integer.parseInt(doc.get("chunkSize"));
        this.chunkOverlap = Integer.parseInt(doc.get("chunkOvlp"));
        if (this.chunkSize <= 0 || this.chunkOverlap <= 0 || this.chunkOverlap >= this.chunkSize) {
            throw new IOException("Invalid chunkSize/overlap in index");
        }
        this.docNumMap = new XtfDocNumMap(this.indexReader, this.chunkSize, this.chunkOverlap);
        String stopWords = doc.get("stopWords");
        this.stopSet = null;
        if (stopWords != null && stopWords.length() > 0) {
            this.stopSet = BigramQueryRewriter.makeStopSet(stopWords);
        }
        if ((accentMapName = doc.get("accentMap")) != null && accentMapName.length() > 0) {
            File accentFile = new File(this.indexPath, accentMapName);
            InputStream stream = new FileInputStream(accentFile);
            if (accentMapName.endsWith(".gz")) {
                stream = new GZIPInputStream(stream);
            }
            this.accentMap = new CharMap(stream);
        }
        if ((pluralMapName = doc.get("pluralMap")) != null && pluralMapName.length() > 0) {
            File pluralFile = new File(this.indexPath, pluralMapName);
            InputStream stream = new FileInputStream(pluralFile);
            if (pluralMapName.endsWith(".gz")) {
                stream = new GZIPInputStream(stream);
            }
            this.pluralMap = new WordMap(stream, this.accentMap);
        }
        if (SpellReader.isValidDictionary(spellDir = new File(this.indexPath, "spellDict"))) {
            this.spellReader = SpellReader.open(spellDir);
            this.spellReader.setStopwords(this.stopSet);
            this.spellReader.setWordEquiv(new XtfWordEquiv(this.accentMap, this.pluralMap));
        }
        int nDocs = this.indexReader.docFreq(new Term("docInfo", "1"));
        int nChunks = this.indexReader.maxDoc();
        this.isSparse = nChunks > nDocs * 5;
        this.indexedFields = new LinkedHashSet(this.indexReader.getFieldNames(IndexReader.FieldOption.ALL));
        this.tokenizedFields = XtfSearcher.readTokenizedFields(this.indexPath, this.indexReader);
        this.curVersion = this.newVersion;
    }

    public static LinkedHashSet readTokenizedFields(String indexPath, IndexReader indexReader) throws IOException {
        Term t;
        LinkedHashSet<String> tokenizedFields = new LinkedHashSet<String>();
        File tokFieldsFile = new File(Path.normalizePath(String.valueOf(indexPath) + "/tokenizedFields.txt"));
        if (tokFieldsFile.canRead()) {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(tokFieldsFile));
            while ((line = reader.readLine()) != null) {
                tokenizedFields.add(line);
            }
            reader.close();
        }
        TermEnum tokTerms = indexReader.terms(new Term("tokenizedFields", ""));
        while ((t = tokTerms.term()) != null && t.field().equals("tokenizedFields")) {
            tokenizedFields.add(t.text());
            if (tokTerms.next()) continue;
        }
        tokenizedFields.add("text");
        tokenizedFields.add("sectionType");
        return tokenizedFields;
    }

    public Set tokenizedFields() {
        return this.tokenizedFields;
    }

    public IndexReader indexReader() {
        return this.indexReader;
    }

    public Set indexedFields() {
        return this.indexedFields;
    }

    public DocNumMap docNumMap() {
        return this.docNumMap;
    }

    public int chunkSize() {
        return this.chunkSize;
    }

    public int chunkOverlap() {
        return this.chunkOverlap;
    }

    public Set stopSet() {
        return this.stopSet;
    }

    public WordMap pluralMap() {
        return this.pluralMap;
    }

    public CharMap accentMap() {
        return this.accentMap;
    }

    public SpellReader spellReader() {
        return this.spellReader;
    }

    public boolean isSparse() {
        return this.isSparse;
    }

    public void close() throws IOException {
        this.docNumMap = null;
        if (this.indexReader != null) {
            this.indexReader.close();
            this.indexReader = null;
        }
        if (this.spellReader != null) {
            this.spellReader.close();
            this.spellReader = null;
        }
        this.curVersion = -99L;
    }
}

