/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import org.apache.lucene.util.Prime;
import org.cdlib.xtf.util.Tester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastHashMap<K, V> {
    private final int hashSize;
    private final Ent[] ents;
    private int curSize;
    public static final Tester tester = new Tester("FastHashMap"){

        protected void testImpl() {
            FastHashMap<String, String> hash = new FastHashMap<String, String>(5);
            hash.put("100", "hello");
            if (!$assertionsDisabled && !hash.contains("100")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hash.contains("111")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !hash.get("100").equals("hello")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hash.size() != 1) {
                throw new AssertionError();
            }
            hash.put("200", "foo");
            hash.put("211", "bar");
            if (!$assertionsDisabled && !hash.contains("100")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !hash.contains("200")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !hash.contains("211")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hash.contains("111")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hash.contains("212")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && hash.size() != 3) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !hash.get("100").equals("hello")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !hash.get("200").equals("foo")) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !hash.get("211").equals("bar")) {
                throw new AssertionError();
            }
        }
    };

    public FastHashMap(int maxSize) {
        this.hashSize = Prime.findAfter(maxSize * 2);
        this.ents = new Ent[this.hashSize];
        this.curSize = 0;
    }

    public void put(K key, V val) {
        int bucket = this.hashSlot(key);
        Ent e = this.ents[bucket];
        while (e != null) {
            if (key.equals(e.key)) {
                e.val = val;
                return;
            }
            e = e.next;
        }
        e = new Ent();
        e.key = key;
        e.val = val;
        e.next = this.ents[bucket];
        this.ents[bucket] = e;
        ++this.curSize;
    }

    private final int hashSlot(K key) {
        int code = key.hashCode();
        if (code >= 0) {
            return code % this.hashSize;
        }
        return -code % this.hashSize;
    }

    public boolean contains(K key) {
        Ent e = this.ents[this.hashSlot(key)];
        while (e != null) {
            if (key.equals(e.key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public V get(K key) {
        Ent e = this.ents[this.hashSlot(key)];
        while (e != null) {
            if (key.equals(e.key)) {
                return e.val;
            }
            e = e.next;
        }
        return null;
    }

    public int size() {
        return this.curSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ent<K, V> {
        K key;
        V val;
        Ent next;

        private Ent() {
        }
    }
}

