/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.dtdschema;

import com.japisoft.editix.action.dtdschema.generator.MetaAttribute;
import com.japisoft.editix.action.dtdschema.generator.MetaNode;
import com.japisoft.editix.action.dtdschema.generator.MetaObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class MetaModelUpdatePanel
extends JPanel
implements TreeSelectionListener {
    private JTree tree = null;
    private JTable table = null;
    private DefaultTableModel model = null;

    public MetaModelUpdatePanel(MetaNode metaNode) {
        this.setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(this.getMetaModelComponent(metaNode));
        jSplitPane.setRightComponent(this.getAttributeComponent());
        this.add(jSplitPane);
    }

    public void addNotify() {
        super.addNotify();
        this.tree.addTreeSelectionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.tree.removeTreeSelectionListener(this);
    }

    private JComponent getMetaModelComponent(MetaNode metaNode) {
        JScrollPane jScrollPane = new JScrollPane();
        this.tree = new JTree(metaNode);
        jScrollPane.setViewportView(this.tree);
        this.tree.setShowsRootHandles(false);
        return jScrollPane;
    }

    private JComponent getAttributeComponent() {
        this.model = new DefaultTableModel(new String[]{"Attribute name", "Attribute type"}, 0);
        this.table = new JTable(){

            public boolean isCellEditable(int n, int n2) {
                return n2 != 0;
            }
        };
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setModel(this.model);
        this.table.getColumnModel().getColumn(1).setCellRenderer(new DefaultRenderer());
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultEditor());
        return new JScrollPane(this.table);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.model = new DefaultTableModel(new String[]{"Attribute name", "Attribute type"}, 0);
        this.table.setModel(this.model);
        this.table.getColumnModel().getColumn(1).setCellRenderer(new DefaultRenderer());
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultEditor());
        MetaNode metaNode = (MetaNode)this.tree.getSelectionPath().getLastPathComponent();
        Vector vector = metaNode.getAttributes();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                MetaAttribute metaAttribute = (MetaAttribute)vector.get(i);
                this.model.addRow(new Object[]{metaAttribute.getName(), metaAttribute.getType()});
            }
        }
    }

    class DefaultRenderer
    implements TableCellRenderer {
        private JComboBox secondColumn = new JComboBox<String>(MetaObject.AVAILABLE_TYPES);

        DefaultRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.secondColumn.setSelectedItem((String)object);
            this.secondColumn.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.secondColumn.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            return this.secondColumn;
        }
    }

    class DefaultEditor
    implements TableCellEditor,
    ActionListener {
        private JComboBox secondColumn = new JComboBox<String>(MetaObject.AVAILABLE_TYPES);
        private int currentRow = -1;

        DefaultEditor() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.stopCellEditing();
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.secondColumn.addActionListener(this);
        }

        public void cancelCellEditing() {
        }

        public Object getCellEditorValue() {
            return this.secondColumn.getSelectedItem();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentRow = n;
            this.secondColumn.setSelectedItem((String)object);
            return this.secondColumn;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.secondColumn.removeActionListener(this);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }

        public boolean stopCellEditing() {
            if (this.currentRow != -1) {
                MetaNode metaNode = (MetaNode)MetaModelUpdatePanel.this.tree.getSelectionPath().getLastPathComponent();
                int n = this.currentRow;
                ((MetaAttribute)metaNode.getAttributes().get(n)).setType((String)this.secondColumn.getSelectedItem());
                MetaModelUpdatePanel.this.model.setValueAt(this.secondColumn.getSelectedItem(), this.currentRow, 1);
            }
            return true;
        }
    }
}

