/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.file.imp;

import com.japisoft.editix.action.file.imp.CSVPanel;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.dialog.DialogManager;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.framework.xml.XMLToolkit;
import com.japisoft.p.Manager;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class CSVImport
extends AbstractAction {
    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            CSVPanel cSVPanel = new CSVPanel();
            if (jFileChooser.showOpenDialog(EditixFrame.ACCESSOR) == 0) {
                File file = jFileChooser.getSelectedFile();
                if (DialogManager.showDialog(EditixFrame.ACCESSOR, "CSV Import", "CSV Import", "Import a CSV document to XML", null, cSVPanel, new Dimension(400, 550)) == DialogManager.OK_ID) {
                    this.impCSV(file, cSVPanel);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void impCSV(File file, CSVPanel cSVPanel) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>\n\n<document>\n");
        char c = ',';
        if (cSVPanel.cbArobas.isSelected()) {
            c = '@';
        } else if (cSVPanel.cbDash.isSelected()) {
            c = '-';
        } else if (cSVPanel.cbDoubleDot.isSelected()) {
            c = ':';
        } else if (cSVPanel.cbExclamationMark.isSelected()) {
            c = '!';
        } else if (cSVPanel.cbSlash.isSelected()) {
            c = '/';
        } else if (cSVPanel.cbVerticalBar.isSelected()) {
            c = '|';
        } else if (cSVPanel.cbSemiColon.isSelected()) {
            c = ';';
        } else if (cSVPanel.cbSpace.isSelected()) {
            c = ' ';
        } else if (cSVPanel.cbTab.isSelected()) {
            c = '\t';
        } else if (cSVPanel.cbOther.isSelected() && cSVPanel.tfOther.getText() != null && cSVPanel.tfOther.getText().length() > 0) {
            c = cSVPanel.tfOther.getText().charAt(0);
        }
        char c2 = '\u0000';
        if (cSVPanel.cbTextQualifier.getSelectedIndex() > 0) {
            c2 = ((String)cSVPanel.cbTextQualifier.getSelectedItem()).charAt(0);
        }
        String string = "row";
        String string2 = "col";
        if (cSVPanel.tfRow.getText() != null && cSVPanel.tfRow.getText().length() > 0) {
            string = cSVPanel.tfRow.getText();
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                String string3 = null;
                int n = (Integer)cSVPanel.spStartingRow.getValue();
                int n2 = 1;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (--n <= 0) {
                        stringBuffer.append("\t<" + string + " id=\"" + n2 + "\">\n");
                        int n3 = 0;
                        StringBuffer stringBuffer2 = null;
                        boolean bl = false;
                        for (int i = 0; i < string3.length(); ++i) {
                            char c3 = string3.charAt(i);
                            if (stringBuffer2 == null) {
                                stringBuffer2 = new StringBuffer();
                            }
                            if (c3 == c && !bl) {
                                String string4 = "" + (n3 + 1);
                                if (cSVPanel.lstColumnName.getModel().getSize() > n3) {
                                    string4 = (String)cSVPanel.lstColumnName.getModel().getElementAt(n3);
                                }
                                stringBuffer.append("\t\t<" + string2 + " id=\"" + string4 + "\">");
                                stringBuffer.append(XMLToolkit.resolveCharEntities(stringBuffer2.toString()));
                                stringBuffer.append("</" + string2 + ">\n");
                                stringBuffer2 = null;
                                ++n3;
                                continue;
                            }
                            if (c2 != '\u0000') {
                                if (c3 == c2) {
                                    bl = !bl;
                                    continue;
                                }
                                stringBuffer2.append(c3);
                                continue;
                            }
                            stringBuffer2.append(c3);
                        }
                        if (stringBuffer2 != null) {
                            String string5 = "" + (n3 + 1);
                            if (cSVPanel.lstColumnName.getModel().getSize() > n3) {
                                string5 = (String)cSVPanel.lstColumnName.getModel().getElementAt(n3);
                            }
                            stringBuffer.append("\t\t<" + string2 + " id=\"" + string5 + "\">");
                            stringBuffer.append(XMLToolkit.resolveCharEntities(stringBuffer2.toString()));
                            stringBuffer.append("</" + string2 + ">\n");
                        }
                        stringBuffer.append("\t</" + string + ">\n");
                    }
                    ++n2;
                }
                stringBuffer.append("\n</document>");
                IXMLPanel iXMLPanel = EditixFactory.buildNewContainer("XML", (String)null);
                XMLContainer xMLContainer = iXMLPanel.getMainContainer();
                xMLContainer.setText(stringBuffer.toString());
                EditixFrame.ACCESSOR.addContainer(iXMLPanel);
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            EditixFactory.buildAndShowErrorDialog("File error : " + file);
        }
        catch (IOException iOException) {
            EditixFactory.buildAndShowErrorDialog("Can't parse : " + file);
        }
    }
}

