/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.search;

import com.japisoft.editix.action.search.BookmarkGoToAction;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.actions.SynchronizableAction;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class BookmarkAction
extends AbstractAction
implements SynchronizableAction {
    public void actionPerformed(ActionEvent actionEvent) {
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            return;
        }
        SimpleNode simpleNode = xMLContainer.getCurrentNode();
        String string = null;
        string = simpleNode == null ? "Cursor at " + xMLContainer.getEditor().getCaretPosition() : simpleNode.getXPathLocation();
        BookmarkAction.addBookmarkToMenu(string);
        BookmarkAction.storeBookmarksInContainer(xMLContainer);
    }

    public void synchronizeState(Object object) {
        if (object instanceof XMLContainer) {
            XMLContainer xMLContainer = (XMLContainer)object;
            String string = (String)xMLContainer.getProperty("bookmarks", "");
            EditixFrame.ACCESSOR.getBuilder().cleanMenuItems("listOfBookmarks");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "!!");
            while (stringTokenizer.hasMoreTokens()) {
                BookmarkAction.addBookmarkToMenu(stringTokenizer.nextToken());
            }
        }
    }

    public static void storeBookmarksInContainer(XMLContainer xMLContainer) {
        JMenu jMenu = EditixFrame.ACCESSOR.getBuilder().getMenu("listOfBookmarks");
        if (jMenu == null) {
            System.err.println("Can't find sub menu listOfBookmarks ??");
        } else {
            StringBuffer stringBuffer = null;
            for (int i = 0; i < jMenu.getItemCount(); ++i) {
                JMenuItem jMenuItem = jMenu.getItem(i);
                String string = jMenuItem.getText();
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                } else {
                    stringBuffer.append("!!");
                }
                stringBuffer.append(string);
            }
            if (stringBuffer != null) {
                xMLContainer.setProperty("bookmarks", stringBuffer.toString());
            }
        }
    }

    public static void addBookmarkToMenu(String string) {
        BookmarkGoToAction bookmarkGoToAction = new BookmarkGoToAction();
        bookmarkGoToAction.putValue("Name", string);
        bookmarkGoToAction.putValue("param", string);
        bookmarkGoToAction.putValue("iconPath", "images/bookmark.png");
        EditixFrame.ACCESSOR.getBuilder().insertMenuItemAtFirst("listOfBookmarks", bookmarkGoToAction, 20);
    }
}

