/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.document.xslt;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.error.ErrorManager;
import com.japisoft.xmlpad.xml.validator.Validator;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltCompiler;
import org.xml.sax.SAXParseException;

public class XSLT2Validator
implements Validator,
ErrorListener {
    ErrorManager currentErrorManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(XMLContainer xMLContainer, boolean bl) {
        if (EditixFactory.mustSaveDialog(xMLContainer)) {
            return false;
        }
        this.currentErrorManager = xMLContainer.getErrorManager();
        this.currentErrorManager.initErrorProcessing();
        try {
            ActionModel.activeActionById("save", null);
            Processor processor = new Processor(false);
            XsltCompiler xsltCompiler = processor.newXsltCompiler();
            xsltCompiler.setErrorListener((ErrorListener)this);
            try {
                xsltCompiler.compile((Source)new StreamSource(xMLContainer.getCurrentDocumentLocation()));
            }
            catch (SaxonApiException saxonApiException) {
                boolean bl2 = false;
                boolean bl3 = this.currentErrorManager.hasLastError();
                this.currentErrorManager.stopErrorProcessing();
                this.currentErrorManager = null;
                if (bl3) {
                    return false;
                }
                return bl2;
            }
        }
        finally {
            boolean bl4 = this.currentErrorManager.hasLastError();
            this.currentErrorManager.stopErrorProcessing();
            this.currentErrorManager = null;
            if (bl4) {
                return false;
            }
        }
        return true;
    }

    public void error(TransformerException transformerException) throws TransformerException {
        SourceLocator sourceLocator = transformerException.getLocator();
        if (sourceLocator == null) {
            sourceLocator = new SourceLocator(){

                public int getColumnNumber() {
                    return -1;
                }

                public int getLineNumber() {
                    return -1;
                }

                public String getPublicId() {
                    return null;
                }

                public String getSystemId() {
                    return null;
                }
            };
        }
        int n = sourceLocator.getLineNumber();
        int n2 = sourceLocator.getColumnNumber();
        int n3 = 0;
        for (Throwable throwable = transformerException.getCause(); throwable != null; throwable = throwable.getCause()) {
            if (throwable instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                n2 = sAXParseException.getColumnNumber();
                n = sAXParseException.getLineNumber();
                break;
            }
            if (throwable.getCause() == throwable) break;
            if (++n3 <= 10) continue;
        }
        this.currentErrorManager.notifyError(this, true, null, n, n2, -1, transformerException.getMessage(), false);
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        this.error(transformerException);
    }

    public void warning(TransformerException transformerException) throws TransformerException {
    }
}

