/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels.charref;

import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.panels.charref.CharRefAllTableModel;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class CharRefUI
extends JPanel
implements ListSelectionListener,
MouseListener,
ActionListener {
    private JScrollPane spTable = new JScrollPane();
    private JTable tbChar = new JTable(){

        public TableCellRenderer getDefaultRenderer(Class clazz) {
            return new CustomCellRenderer();
        }
    };
    private JPanel pnlInfo = new JPanel();
    private TitledBorder titledBorder1;
    private JLabel lbHexa = new JLabel();
    private JLabel lbDec = new JLabel();
    private JTextField tfHexa = new JTextField();
    private JTextField tfDec = new JTextField();
    private JButton btn = new JButton("Insert");
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    boolean enabledDeci = true;
    boolean enabledHexa = true;

    public CharRefUI() {
        this.init(new CharRefAllTableModel());
    }

    void init(TableModel tableModel) {
        this.tbChar.getSelectionModel().setSelectionMode(0);
        this.titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), "CharRef");
        this.setLayout(this.gridBagLayout2);
        this.pnlInfo.setBorder(this.titledBorder1);
        this.pnlInfo.setLayout(this.gridBagLayout1);
        this.lbHexa.setText("Hexa (&#x...;)");
        this.lbDec.setText("Dec (&#...;)");
        this.tfHexa.setText("");
        this.add((Component)this.spTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 4.0, 10, 1, new Insets(13, 12, 0, 16), 0, 0));
        this.spTable.getViewport().add((Component)this.tbChar, null);
        this.add((Component)this.pnlInfo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 1, new Insets(6, 12, 10, 16), 0, 0));
        this.pnlInfo.add((Component)this.lbDec, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 9, 15, 35), 0, 0));
        this.pnlInfo.add((Component)this.lbHexa, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 9, 0, 0), 0, 0));
        this.pnlInfo.add((Component)this.tfHexa, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlInfo.add((Component)this.tfDec, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlInfo.add((Component)this.btn, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, -1, new Insets(0, 0, 0, 0), 0, 0));
        this.tbChar.setModel(tableModel);
        this.tfDec.setDocument(new DeciDocument());
        this.tfHexa.setDocument(new HexaDocument());
        this.setPreferredSize(new Dimension(50, 50));
    }

    public void addNotify() {
        super.addNotify();
        this.tbChar.addMouseListener(this);
        this.btn.addActionListener(this);
        this.tbChar.getSelectionModel().addListSelectionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.tbChar.removeMouseListener(this);
        this.btn.removeActionListener(this);
        this.tbChar.getSelectionModel().removeListSelectionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            return;
        }
        xMLContainer.getEditor().insertText(this.getSelectedChar());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.valueChanged(null);
        if (mouseEvent.getClickCount() > 1) {
            this.actionPerformed(null);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.tbChar.getSelectedColumn();
        int n2 = this.tbChar.getSelectedRow();
        Character c = (Character)this.tbChar.getModel().getValueAt(n2, n);
        this.enabledDeci = false;
        this.tfDec.setText("" + c.charValue());
        this.enabledDeci = true;
        this.enabledHexa = false;
        this.tfHexa.setText(Integer.toHexString(c.charValue()));
        this.enabledHexa = true;
    }

    public String getSelectedChar() {
        return "&#x" + Integer.toHexString(((Character)this.tbChar.getModel().getValueAt(this.tbChar.getSelectedRow(), this.tbChar.getSelectedColumn())).charValue()) + ";";
    }

    public void scrollToCenter(JTable jTable, int n, int n2) {
        if (!(jTable.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)jTable.getParent();
        Rectangle rectangle = jTable.getCellRect(n, n2, true);
        Rectangle rectangle2 = jViewport.getViewRect();
        rectangle.setLocation(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
        int n3 = (rectangle2.width - rectangle.width) / 2;
        int n4 = (rectangle2.height - rectangle.height) / 2;
        if (rectangle.x < n3) {
            n3 = -n3;
        }
        if (rectangle.y < n4) {
            n4 = -n4;
        }
        rectangle.translate(n3, n4);
        jViewport.scrollRectToVisible(rectangle);
    }

    class CustomCellRenderer
    extends DefaultTableCellRenderer {
        CustomCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            char c = ((Character)object).charValue();
            if (c == '\n') {
                object = "\\n";
            }
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl2) {
                component.setBackground(Color.BLACK);
                component.setForeground(Color.WHITE);
            } else {
                component.setBackground(Color.WHITE);
                component.setForeground(Color.BLACK);
                if (!this.getFont().canDisplay(c)) {
                    component.setBackground(Color.LIGHT_GRAY);
                }
            }
            return component;
        }
    }

    class HexaDocument
    extends PlainDocument {
        HexaDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            if (!CharRefUI.this.enabledHexa) {
                return;
            }
            try {
                String string2 = CharRefUI.this.tfHexa.getText();
                int n2 = Integer.parseInt(string2, 16);
                int n3 = CharRefUI.this.tbChar.getModel().getColumnCount();
                int n4 = n2 / n3;
                int n5 = n2 % n3;
                CharRefUI.this.tbChar.getSelectionModel().setSelectionInterval(n4, n4);
                CharRefUI.this.tbChar.getColumnModel().getSelectionModel().setSelectionInterval(n5, n5);
                CharRefUI.this.scrollToCenter(CharRefUI.this.tbChar, n4, n5);
                CharRefUI.this.tbChar.requestFocus();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    class DeciDocument
    extends PlainDocument {
        DeciDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            if (!CharRefUI.this.enabledDeci) {
                return;
            }
            try {
                String string2 = CharRefUI.this.tfDec.getText();
                int n2 = Integer.parseInt(string2);
                int n3 = CharRefUI.this.tbChar.getModel().getColumnCount();
                int n4 = n2 / n3;
                int n5 = n2 % n3;
                CharRefUI.this.tbChar.getSelectionModel().setSelectionInterval(n4, n4);
                CharRefUI.this.tbChar.getColumnModel().getSelectionModel().setSelectionInterval(n5, n5);
                CharRefUI.this.scrollToCenter(CharRefUI.this.tbChar, n4, n5);
                CharRefUI.this.tbChar.requestFocus();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

