/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser.fio;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FastBufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;

    public FastBufferedOutputStream(OutputStream outputStream) {
        this(outputStream, 4096);
    }

    FastBufferedOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.buf = new byte[n];
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void write(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)n;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 >= this.buf.length) {
            this.flushBuffer();
            this.out.write(byArray, n, n2);
            return;
        }
        if (n2 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

