/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.findreplace;

import com.japisoft.findreplace.FindReplaceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.jdesktop.layout.GroupLayout;

public class FindReplacePanel
extends JPanel {
    JTextComponent source = null;
    private boolean replaceMode = true;
    private ButtonGroup bgDirection;
    private ButtonGroup bgScope;
    private JButton btnFind;
    private JButton btnReplace;
    private JButton btnReplaceAll;
    private JButton btnReplaceFind;
    private JCheckBox cbCaseSensitive;
    private JComboBox cbFind;
    private JCheckBox cbIncremental;
    private JCheckBox cbRegularExpressions;
    private JComboBox cbReplace;
    private JCheckBox cbWholeWord;
    private JCheckBox cbWrapSearch;
    private JLabel jLabel1;
    private JLabel lbInfo;
    private JLabel jLabel2;
    private JPanel jPanel2;
    private JPanel pnlDirection;
    private JPanel pnlOptions;
    private JRadioButton rbAll;
    private JRadioButton rbBackward;
    private JRadioButton rbForward;
    private JRadioButton rbSelectedLines;
    private CustomActionListener customActionListener = new CustomActionListener();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    private FindReplaceManager manager = null;
    private ArrayList al = null;
    int oldSelectionStart = -1;
    int oldSelectionEnd = -1;
    int deltaPerf = 0;
    CustomFindPlainDocument documentFind = new CustomFindPlainDocument();
    CustomReplacePlainDocument documentReplace = new CustomReplacePlainDocument();

    public FindReplacePanel(JTextComponent jTextComponent) {
        this(jTextComponent, false);
    }

    public FindReplacePanel(JTextComponent jTextComponent, boolean bl) {
        if (jTextComponent == null) {
            throw new RuntimeException("Can't use a null textComponent !");
        }
        this.initComponents();
        this.btnFind.setEnabled(false);
        this.btnReplace.setEnabled(false);
        this.btnReplaceAll.setEnabled(false);
        this.btnReplaceFind.setEnabled(false);
        this.cbFind.setEditable(true);
        this.cbReplace.setEditable(true);
        ((JTextComponent)this.cbFind.getEditor().getEditorComponent()).setDocument(this.documentFind);
        ((JTextComponent)this.cbReplace.getEditor().getEditorComponent()).setDocument(this.documentReplace);
        this.source = jTextComponent;
        this.updateTextComponent(jTextComponent, bl);
    }

    public void updateTextComponent(JTextComponent jTextComponent, boolean bl) {
        String string;
        this.source = jTextComponent;
        this.manager = null;
        if (bl && jTextComponent != null && (string = jTextComponent.getSelectedText()) != null) {
            this.cbFind.setSelectedItem(string);
        }
    }

    public JTextComponent getCurrentTextComponent() {
        return this.source;
    }

    public void setReplaceMode(boolean bl) {
        this.replaceMode = bl;
        this.cbReplace.setEnabled(bl);
    }

    public boolean isReplaceMode() {
        return this.replaceMode;
    }

    public FindReplacePanel(String string, JTextComponent jTextComponent) {
        this(jTextComponent);
        this.cbFind.setSelectedItem(string);
    }

    private void initComponents() {
        this.bgDirection = new ButtonGroup();
        this.bgScope = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.cbFind = new JComboBox();
        this.jLabel2 = new JLabel();
        this.cbReplace = new JComboBox();
        this.pnlDirection = new JPanel();
        this.rbForward = new JRadioButton();
        this.rbBackward = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.rbAll = new JRadioButton();
        this.rbSelectedLines = new JRadioButton();
        this.pnlOptions = new JPanel();
        this.cbCaseSensitive = new JCheckBox();
        this.cbWholeWord = new JCheckBox();
        this.cbRegularExpressions = new JCheckBox();
        this.cbWrapSearch = new JCheckBox();
        this.cbIncremental = new JCheckBox();
        this.btnFind = new JButton();
        this.btnReplaceFind = new JButton();
        this.btnReplace = new JButton();
        this.btnReplaceAll = new JButton();
        this.lbInfo = new JLabel();
        this.jLabel1.setText("Find:");
        this.jLabel2.setText("Replace with:");
        this.pnlDirection.setBorder(BorderFactory.createTitledBorder("Direction"));
        this.bgDirection.add(this.rbForward);
        this.rbForward.setSelected(true);
        this.rbForward.setText("Forward");
        this.rbForward.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbForward.setMargin(new Insets(0, 0, 0, 0));
        this.bgDirection.add(this.rbBackward);
        this.rbBackward.setText("Backward");
        this.rbBackward.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbBackward.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this.pnlDirection);
        this.pnlDirection.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.rbForward).add((Component)this.rbBackward)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rbForward).addPreferredGap(0).add((Component)this.rbBackward)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Scope"));
        this.bgScope.add(this.rbAll);
        this.rbAll.setSelected(true);
        this.rbAll.setText("All");
        this.rbAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbAll.setMargin(new Insets(0, 0, 0, 0));
        this.bgScope.add(this.rbSelectedLines);
        this.rbSelectedLines.setText("Selected lines");
        this.rbSelectedLines.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbSelectedLines.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.rbAll).add((Component)this.rbSelectedLines)).addContainerGap(35, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.rbAll).addPreferredGap(0).add((Component)this.rbSelectedLines)));
        this.pnlOptions.setBorder(BorderFactory.createTitledBorder("Option"));
        this.cbCaseSensitive.setText("Case sensitive");
        this.cbCaseSensitive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbCaseSensitive.setMargin(new Insets(0, 0, 0, 0));
        this.cbWholeWord.setText("Whole word");
        this.cbWholeWord.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbWholeWord.setMargin(new Insets(0, 0, 0, 0));
        this.cbRegularExpressions.setText("Regular expressions");
        this.cbRegularExpressions.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbRegularExpressions.setMargin(new Insets(0, 0, 0, 0));
        this.cbWrapSearch.setText("Wrap search");
        this.cbWrapSearch.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbWrapSearch.setMargin(new Insets(0, 0, 0, 0));
        this.cbIncremental.setText("Incremental");
        this.cbIncremental.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbIncremental.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.pnlOptions);
        this.pnlOptions.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.cbRegularExpressions).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.cbCaseSensitive).add((Component)this.cbWholeWord)).add(37, 37, 37).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.cbIncremental).add((Component)this.cbWrapSearch)).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.cbCaseSensitive).add((Component)this.cbWrapSearch)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.cbWholeWord).add((Component)this.cbIncremental)).addPreferredGap(0).add((Component)this.cbRegularExpressions).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnFind.setText("Find");
        this.btnReplaceFind.setText("Replace/Find");
        this.btnReplace.setText("Replace");
        this.btnReplaceAll.setText("Replace All");
        GroupLayout groupLayout4 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.pnlOptions, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((Component)this.pnlDirection, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).add(15, 15, 15).add((GroupLayout.Group)groupLayout4.createParallelGroup(2).add((Component)this.cbReplace, 0, 159, Short.MAX_VALUE).add((Component)this.cbFind, 0, 159, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add((GroupLayout.Group)groupLayout4.createParallelGroup(1, false).add((Component)this.btnReplace, -1, -1, Short.MAX_VALUE).add((Component)this.btnFind, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout4.createParallelGroup(1, false).add((GroupLayout.Group)groupLayout4.createSequentialGroup().add(5, 5, 5).add((Component)this.btnReplaceFind)).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addPreferredGap(0).add((Component)this.btnReplaceAll, -1, -1, Short.MAX_VALUE)))).add((Component)this.lbInfo, -1, 239, Short.MAX_VALUE)).addContainerGap()));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.cbFind, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.cbReplace, -2, -1, -2)).add(14, 14, 14).add((GroupLayout.Group)groupLayout4.createParallelGroup(1, false).add((Component)this.jPanel2, 0, -1, Short.MAX_VALUE).add((Component)this.pnlDirection, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.pnlOptions, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.btnFind).add((Component)this.btnReplaceFind)).addPreferredGap(0).add((GroupLayout.Group)groupLayout4.createParallelGroup(3).add((Component)this.btnReplace).add((Component)this.btnReplaceAll)).addPreferredGap(0, 20, Short.MAX_VALUE).add((Component)this.lbInfo)));
    }

    public void addNotify() {
        super.addNotify();
        this.btnFind.addActionListener(this.customActionListener);
        this.btnReplace.addActionListener(this.customActionListener);
        this.btnReplaceAll.addActionListener(this.customActionListener);
        this.btnReplaceFind.addActionListener(this.customActionListener);
        this.rbForward.addActionListener(this.customActionListener);
        this.rbBackward.addActionListener(this.customActionListener);
        this.rbAll.addActionListener(this.customActionListener);
        this.rbSelectedLines.addActionListener(this.customActionListener);
        this.cbIncremental.addActionListener(this.customActionListener);
        this.cbRegularExpressions.addActionListener(this.customActionListener);
        if (this.getMotif().length > 0) {
            this.btnFind.requestFocus();
        } else {
            this.cbFind.getEditor().getEditorComponent().requestFocus();
        }
        this.initReplaceManager();
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null && window instanceof JWindow) {
            JWindow jWindow = (JWindow)window;
            jWindow.getRootPane().setDefaultButton(this.btnFind);
        }
        if (this.cbFind.getEditor().getEditorComponent() instanceof JTextField) {
            ((JTextField)this.cbFind.getEditor().getEditorComponent()).addActionListener(this.customActionListener);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.btnFind.removeActionListener(this.customActionListener);
        this.btnReplace.removeActionListener(this.customActionListener);
        this.btnReplaceAll.removeActionListener(this.customActionListener);
        this.btnReplaceFind.removeActionListener(this.customActionListener);
        this.rbForward.removeActionListener(this.customActionListener);
        this.rbBackward.removeActionListener(this.customActionListener);
        this.rbAll.removeActionListener(this.customActionListener);
        this.rbSelectedLines.removeActionListener(this.customActionListener);
        this.cbIncremental.removeActionListener(this.customActionListener);
        this.cbRegularExpressions.removeActionListener(this.customActionListener);
        this.cbFind.removeActionListener(this.customActionListener);
        if (this.cbFind.getEditor().getEditorComponent() instanceof JTextField) {
            ((JTextField)this.cbFind.getEditor().getEditorComponent()).removeActionListener(this.customActionListener);
        }
    }

    private void prepareReplaceManager() {
        if (this.manager == null) {
            this.manager = new FindReplaceManager();
        }
        this.manager.caseSensitive = this.cbCaseSensitive.isSelected();
        this.manager.forward = this.rbForward.isSelected();
        this.manager.motif = this.getMotif();
        this.manager.regularExpressions = this.cbRegularExpressions.isSelected();
        this.manager.scope_all = this.rbAll.isSelected();
        this.manager.wholeWord = this.cbWholeWord.isSelected();
        this.manager.wrapSearch = this.cbWrapSearch.isSelected();
    }

    private void initReplaceManager() {
        this.prepareReplaceManager();
        this.manager.init();
    }

    private char[] getMotif() {
        if (this.cbFind.getSelectedItem() == null) {
            return new char[0];
        }
        return ((JTextComponent)this.cbFind.getEditor().getEditorComponent()).getText().toCharArray();
    }

    public boolean find() {
        return this.find(-1);
    }

    private boolean find(int n) {
        return this.find(n, null);
    }

    private boolean find(int n, char[] cArray) {
        if (n == -1) {
            this.prepareReplaceManager();
        }
        this.manager.motifCaret = -1;
        this.oldSelectionStart = this.source.getSelectionStart();
        this.oldSelectionEnd = this.source.getSelectionEnd();
        int n2 = this.manager.nextSearch(this.source, cArray);
        if (n2 <= -1) {
            this.lbInfo.setText("String Not Found");
            if (n == -1) {
                this.manager.init();
            }
            this.btnReplace.setEnabled(false);
            this.btnReplaceFind.setEnabled(false);
            return false;
        }
        this.manager.caret = this.manager.nextCaret;
        if (n == -2) {
            this.selectMotifAt2(n2);
        } else {
            this.selectMotifAt(n2);
        }
        return true;
    }

    private void selectMotifAt(int n) {
        this.lbInfo.setText(null);
        this.giveFocusToSource();
        this.source.select(n, n + this.manager.getMotifLength());
        this.btnReplace.setEnabled(this.replaceMode);
        this.btnReplaceFind.setEnabled(this.replaceMode);
        this.addOneItem(this.cbFind, (String)this.cbFind.getSelectedItem());
    }

    private void selectMotifAt2(int n) {
        if (this.al == null) {
            this.al = new ArrayList();
        }
        this.al.add(new Point(n, n + this.manager.getMotifLength()));
    }

    private void addOneItem(JComboBox jComboBox, String string) {
        if (string == null || "".equals(string)) {
            return;
        }
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (!jComboBox.getItemAt(i).equals(string)) continue;
            return;
        }
        jComboBox.addItem(string);
    }

    public void replace() {
        if (this.source.getSelectionStart() < this.source.getSelectionEnd()) {
            int n = this.source.getSelectedText().length();
            String string = this.cbReplace.getSelectedItem() == null ? "" : (String)this.cbReplace.getSelectedItem();
            int n2 = this.manager.caret;
            this.source.replaceSelection(string);
            this.addOneItem(this.cbReplace, string);
            this.manager.init();
            this.manager.caret = n2 + (string.length() - n);
            this.oldSelectionEnd += string.length() - n;
            if (this.rbSelectedLines.isSelected() && this.oldSelectionStart > -1 && this.oldSelectionEnd > -1) {
                this.source.setSelectionStart(this.oldSelectionStart);
                this.source.setSelectionEnd(this.oldSelectionEnd);
            }
            this.btnReplace.setEnabled(false);
            this.btnReplaceFind.setEnabled(false);
        } else {
            this.btnReplace.setEnabled(false);
            this.btnReplaceFind.setEnabled(false);
        }
    }

    public void replaceAll() {
        this.prepareReplaceManager();
        int n = 0;
        this.manager.forward = true;
        this.manager.wrapSearch = false;
        this.manager.caret = this.rbSelectedLines.isSelected() ? -1 : 0;
        char[] cArray = this.source.getText().toCharArray();
        boolean bl = this.find(-2, cArray);
        while (bl) {
            ++n;
            bl = this.find(-2, cArray);
        }
        if (n == 0) {
            this.lbInfo.setText("String Not found");
        } else {
            boolean bl2 = true;
            if (this.al.size() > 2) {
                Point point = (Point)this.al.get(0);
                Point point2 = (Point)this.al.get(this.al.size() - 1);
                bl2 = point.x < point2.x;
            }
            int n2 = bl2 ? this.al.size() - 1 : 0;
            int n3 = bl2 ? 0 : this.al.size() - 1;
            int n4 = bl2 ? -1 : 1;
            String string = this.cbReplace.getSelectedItem() == null ? "" : (String)this.cbReplace.getSelectedItem();
            int n5 = this.al.size();
            for (int i = n2; i >= 0 && i < n5; i += n4) {
                Point point = (Point)this.al.get(i);
                this.source.select(point.x, point.y);
                this.source.replaceSelection(string);
            }
            this.al = null;
            this.addOneItem(this.cbReplace, (String)this.cbReplace.getSelectedItem());
            this.lbInfo.setText(n + " Match replaced");
        }
        if (n > 0 && this.rbSelectedLines.isSelected()) {
            this.rbAll.setSelected(true);
        }
    }

    public boolean replaceFind() {
        return this.replaceFind(-1);
    }

    private boolean replaceFind(int n) {
        return this.replaceFind(n, null);
    }

    private boolean replaceFind(int n, char[] cArray) {
        if (n != -2) {
            this.replace();
        }
        if (this.find(n, cArray)) {
            this.btnReplaceFind.setEnabled(true);
            return true;
        }
        return false;
    }

    private void giveFocusToSource() {
        Window window = SwingUtilities.getWindowAncestor(this.source);
        if (window != null) {
            window.toFront();
        }
        this.source.requestFocus();
    }

    private void giveFocusToFind() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Window window = SwingUtilities.getWindowAncestor(FindReplacePanel.this.cbFind);
                if (window != null) {
                    window.toFront();
                }
                FindReplacePanel.this.cbFind.getEditor().getEditorComponent().requestFocus();
            }
        });
    }

    public void dispose() {
        this.source = null;
    }

    class CustomReplacePlainDocument
    extends PlainDocument {
        CustomReplacePlainDocument() {
        }

        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            FindReplacePanel.this.btnReplaceAll.setEnabled(FindReplacePanel.this.documentFind.getLength() > 0);
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            FindReplacePanel.this.btnReplaceAll.setEnabled(FindReplacePanel.this.documentFind.getLength() > 0);
        }
    }

    class CustomFindPlainDocument
    extends PlainDocument {
        private int oldIncrementalCaret = -1;

        CustomFindPlainDocument() {
        }

        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            FindReplacePanel.this.btnFind.setEnabled(this.getLength() > 0);
            FindReplacePanel.this.btnReplaceAll.setEnabled(FindReplacePanel.this.documentFind.getLength() > 0 && FindReplacePanel.this.replaceMode);
            if (FindReplacePanel.this.cbIncremental.isSelected()) {
                this.backwardIncrementalFind();
            }
        }

        private void backwardIncrementalFind() {
            this.forwardIncrementalFind();
        }

        private void forwardIncrementalFind() {
            ((FindReplacePanel)FindReplacePanel.this).manager.caret = this.oldIncrementalCaret;
            ((FindReplacePanel)FindReplacePanel.this).manager.motifCaret = -1;
            boolean bl = FindReplacePanel.this.find(-1);
            if (bl) {
                FindReplacePanel.this.giveFocusToFind();
                this.oldIncrementalCaret = ((FindReplacePanel)FindReplacePanel.this).manager.forward ? ((FindReplacePanel)FindReplacePanel.this).manager.caret - ((FindReplacePanel)FindReplacePanel.this).manager.motif.length : ((FindReplacePanel)FindReplacePanel.this).manager.caret + ((FindReplacePanel)FindReplacePanel.this).manager.motif.length;
            }
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            FindReplacePanel.this.btnFind.setEnabled(this.getLength() > 0);
            FindReplacePanel.this.btnReplaceAll.setEnabled(FindReplacePanel.this.documentFind.getLength() > 0 && FindReplacePanel.this.replaceMode);
            if (FindReplacePanel.this.cbIncremental.isSelected()) {
                this.forwardIncrementalFind();
            }
        }
    }

    class CustomActionListener
    implements ActionListener {
        CustomActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == FindReplacePanel.this.btnFind || actionEvent.getSource() instanceof JTextField) {
                FindReplacePanel.this.find();
            } else if (actionEvent.getSource() == FindReplacePanel.this.btnReplace) {
                FindReplacePanel.this.replace();
            } else if (actionEvent.getSource() == FindReplacePanel.this.btnReplaceAll) {
                FindReplacePanel.this.replaceAll();
            } else if (actionEvent.getSource() == FindReplacePanel.this.btnReplaceFind) {
                FindReplacePanel.this.replaceFind();
            } else if (actionEvent.getSource() == FindReplacePanel.this.cbIncremental) {
                int n = ((JTextComponent)FindReplacePanel.this.cbReplace.getEditor().getEditorComponent()).getDocument().getLength();
                int n2 = ((JTextComponent)FindReplacePanel.this.cbFind.getEditor().getEditorComponent()).getDocument().getLength();
                FindReplacePanel.this.btnFind.setEnabled(n > 0);
                FindReplacePanel.this.btnReplace.setEnabled(n > 0 && n2 > 0);
                FindReplacePanel.this.btnReplaceFind.setEnabled(n > 0 && n2 > 0);
                FindReplacePanel.this.btnReplaceAll.setEnabled(n > 0 && n2 > 0 && FindReplacePanel.this.replaceMode);
                boolean bl = FindReplacePanel.this.cbIncremental.isSelected();
                FindReplacePanel.this.cbRegularExpressions.setEnabled(!bl);
            } else if (actionEvent.getSource() == FindReplacePanel.this.cbRegularExpressions) {
                boolean bl = FindReplacePanel.this.cbRegularExpressions.isSelected();
                FindReplacePanel.this.rbBackward.setEnabled(!bl);
                FindReplacePanel.this.rbForward.setEnabled(!bl);
                FindReplacePanel.this.cbIncremental.setEnabled(!bl);
                FindReplacePanel.this.cbWholeWord.setEnabled(!bl);
            } else {
                FindReplacePanel.this.prepareReplaceManager();
                FindReplacePanel.this.manager.init();
            }
        }
    }
}

