/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog;

import com.japisoft.framework.dialog.ButtonLayout;
import com.japisoft.framework.dialog.DialogComponent;
import com.japisoft.framework.dialog.DialogFooter;
import com.japisoft.framework.dialog.DialogManager;
import com.japisoft.framework.dialog.LeftOrientedButton;
import com.japisoft.framework.dialog.actions.DialogAction;
import com.japisoft.framework.dialog.actions.DialogActionModel;
import com.japisoft.framework.dialog.actions.DialogActionModelListener;
import com.japisoft.framework.dialog.actions.DialogActionProxy;
import com.japisoft.framework.dialog.actions.DialogVisibilityObserver;
import com.japisoft.framework.dialog.actions.ToggleActionTransformer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class BasicDialogFooter
extends JPanel
implements DialogFooter,
DialogActionModelListener {
    private DialogActionModel model;
    private DialogComponent target = null;

    public BasicDialogFooter() {
        this.init();
    }

    private void init() {
        this.setLayout(new ButtonLayout(5));
    }

    public void setModel(DialogActionModel dialogActionModel) {
        this.model = dialogActionModel;
    }

    public void dialogHidden() {
        for (int i = 0; i < this.model.getDialogActionCount(); ++i) {
            DialogAction dialogAction = this.model.getDialogActionAt(i);
            if (!(dialogAction instanceof DialogVisibilityObserver)) continue;
            ((DialogVisibilityObserver)((Object)dialogAction)).dialogHidden(this.target, this);
        }
    }

    public void dialogShown() {
        for (int i = 0; i < this.model.getDialogActionCount(); ++i) {
            DialogAction dialogAction = this.model.getDialogActionAt(i);
            if (!(dialogAction instanceof DialogVisibilityObserver)) continue;
            ((DialogVisibilityObserver)((Object)dialogAction)).dialogShown(this.target, this);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.prepareButtons();
        this.model.setModelListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.model.setModelListener(null);
    }

    public JComponent getView() {
        return this;
    }

    public void modelUpdated() {
        this.prepareButtons();
    }

    private void prepareButtons() {
        this.removeAll();
        DialogActionProxy dialogActionProxy = null;
        if (this.model == null) {
            throw new RuntimeException("Illegal DialogFooter usage, no model found");
        }
        for (int i = 0; i < this.model.getDialogActionCount(); ++i) {
            if (!this.model.getDialogActionAt(i).isForDialogFooter()) continue;
            dialogActionProxy = new DialogActionProxy(this.model.getDialogActionAt(i), this.target);
            AbstractButton abstractButton = (AbstractButton)this.add(this.getButtonForAction(dialogActionProxy, this.model.getDialogActionAt(i).isSpecial()));
            if (dialogActionProxy.getActionId() != DialogManager.getDefaultAction() || !(abstractButton instanceof JButton)) continue;
            this.getRootPane().setDefaultButton((JButton)abstractButton);
        }
        this.invalidate();
        this.validate();
    }

    private AbstractButton getButtonForAction(DialogActionProxy dialogActionProxy, boolean bl) {
        if (dialogActionProxy.delegate instanceof ToggleActionTransformer) {
            if (bl) {
                return new CustomToggleButton(dialogActionProxy);
            }
            return new JToggleButton(dialogActionProxy);
        }
        if (bl) {
            return new CustomButton(dialogActionProxy);
        }
        return new JButton(dialogActionProxy);
    }

    public void setDialogTarget(DialogComponent dialogComponent) {
        this.target = dialogComponent;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(Color.GRAY);
        graphics.drawLine(0, 1, this.getWidth(), 1);
        graphics.setColor(Color.WHITE);
        graphics.drawLine(0, 2, this.getWidth(), 2);
    }

    public boolean isDialogActionSelected(int n) {
        DialogAction dialogAction = this.model.getDialogActionForId(n);
        if (dialogAction == null) {
            return false;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            DialogAction dialogAction2;
            AbstractButton abstractButton;
            if (!(this.getComponent(i) instanceof AbstractButton) || !((abstractButton = (AbstractButton)this.getComponent(i)).getAction() instanceof DialogAction) || (dialogAction2 = (DialogAction)abstractButton.getAction()).getActionId() != n) continue;
            return abstractButton.isSelected();
        }
        return false;
    }

    public void setEnabled(int n, boolean bl) {
        DialogAction dialogAction = this.model.getDialogActionForId(n);
        if (dialogAction == null) {
            throw new RuntimeException("Unkown action " + n);
        }
        dialogAction.setEnabled(bl);
    }

    public void dispose() {
        this.model = null;
        this.target = null;
    }

    public void invokeAction(int n) {
        DialogAction dialogAction = this.model.getDialogActionForId(n);
        if (dialogAction == null) {
            throw new RuntimeException("Unkown action " + n);
        }
        dialogAction.actionPerformed(new ActionEvent(this.target, 0, null));
    }

    class CustomToggleButton
    extends JToggleButton
    implements LeftOrientedButton {
        public CustomToggleButton(Action action) {
            super(action);
        }
    }

    class CustomButton
    extends JButton
    implements LeftOrientedButton {
        public CustomButton(Action action) {
            super(action);
        }
    }
}

