/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog.help;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.preferences.Preferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class TipOfTheDayDialog
extends JDialog
implements ActionListener {
    JLabel lblTitleTip = new JLabel();
    JLabel lblImage = new JLabel();
    JCheckBox cbShow = new JCheckBox();
    JButton btnPreviousTip = new JButton();
    JButton btnNextTip = new JButton();
    JButton btnClose = new JButton();
    JEditorPane txtEditor = new JEditorPane();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JScrollPane scEditor = new JScrollPane(this.txtEditor);
    public static String DEF_TIPS_PATH = "tips/tip";
    int currentTip = 0;
    private ArrayList tips;

    public TipOfTheDayDialog(boolean bl) {
        super(ApplicationModel.MAIN_FRAME);
        try {
            this.init();
            this.setTitle("Tip of the day");
            this.initTips();
            if (this.tips.size() == 0) {
                this.txtEditor.setText("No TIP?");
            } else {
                int n = (int)(Math.random() * (double)this.tips.size());
                this.showTip(n);
            }
            this.cbShow.setSelected(bl);
            this.setModal(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.btnPreviousTip.addActionListener(this);
        this.btnNextTip.addActionListener(this);
        this.btnClose.addActionListener(this);
        this.cbShow.addActionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.btnPreviousTip.removeActionListener(this);
        this.btnNextTip.removeActionListener(this);
        this.btnClose.removeActionListener(this);
        this.cbShow.removeActionListener(this);
    }

    public boolean isAvailableForTheNextTime() {
        return this.cbShow.isSelected();
    }

    private void showTip(int n) {
        this.currentTip = n;
        URL uRL = (URL)this.tips.get(n);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string2 = bufferedReader.readLine();
            int n2 = string2.indexOf("<!--");
            int n3 = string2.lastIndexOf("-->");
            if (n2 > -1 && n3 > -1) {
                string2 = string2.substring(n2 + 4, n3);
            }
            this.lblTitleTip.setText(string2);
            StringWriter stringWriter = new StringWriter();
            while ((string = bufferedReader.readLine()) != null) {
                stringWriter.write(string);
                stringWriter.write(System.getProperty("line.separator"));
            }
            this.txtEditor.setContentType("text/html");
            this.txtEditor.setText(stringWriter.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initTips() {
        URL uRL;
        this.tips = new ArrayList();
        for (int i = 1; i < 30 && (uRL = ClassLoader.getSystemResource(DEF_TIPS_PATH + i + ".html")) != null; ++i) {
            this.tips.add(uRL);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnClose) {
            this.setVisible(false);
            this.dispose();
        } else if (actionEvent.getSource() == this.btnPreviousTip) {
            --this.currentTip;
            if (this.currentTip < 0) {
                this.currentTip = this.tips.size() - 1;
            }
            this.showTip(this.currentTip);
        } else if (actionEvent.getSource() == this.btnNextTip) {
            ++this.currentTip;
            if (this.currentTip > this.tips.size() - 1) {
                this.currentTip = 0;
            }
            this.showTip(this.currentTip);
        } else if (actionEvent.getSource() == this.cbShow) {
            Preferences.setRawPreference("interface", "tipOfTheDay", new Boolean(this.isAvailableForTheNextTime()));
        }
    }

    private void init() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.lblTitleTip.setFont(new Font("Dialog", 1, 16));
        this.lblImage.setIcon(new ImageIcon(ClassLoader.getSystemResource("images/help2.png")));
        this.cbShow.setText("Show \"Tip of the day\" after launching");
        this.btnPreviousTip.setText("Previous tip");
        this.btnNextTip.setText("Next tip");
        this.btnClose.setText("Close");
        this.txtEditor.setBackground(Color.WHITE);
        this.txtEditor.setText(null);
        this.getContentPane().add((Component)this.scEditor, new GridBagConstraints(1, 1, 5, 1, 1.0, 1.0, 10, 1, new Insets(0, 11, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.lblTitleTip, new GridBagConstraints(1, 0, 5, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.lblImage, new GridBagConstraints(0, 0, 1, 4, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.cbShow, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 11, 0, 46), 7, 0));
        this.getContentPane().add((Component)this.btnPreviousTip, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 29, 6, 0), 0, 0));
        this.getContentPane().add((Component)this.btnNextTip, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 0, 6, 0), 0, 0));
        this.getContentPane().add((Component)this.btnClose, new GridBagConstraints(4, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(8, 13, 6, 5), 0, 0));
    }
}

