/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.preferences;

import com.japisoft.framework.dialog.BasicOKCancelDialogComponent;
import com.japisoft.framework.dialog.DialogManager;
import com.japisoft.framework.dialog.actions.AbstractDialogAction;
import com.japisoft.framework.dialog.actions.DialogActionModel;
import com.japisoft.framework.preferences.FontDialog;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.preferences.TreeGroup;
import com.japisoft.framework.ui.toolkit.Toolkit;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class PreferencesDialog
extends BasicOKCancelDialogComponent
implements TreeSelectionListener {
    private Properties subGroup = null;
    private HashMap mapGroupTreeNode = null;
    private JTree treeGroup;
    private JPanel cardPanel;
    private CardLayout card;
    private JTable table;
    private HashMap models = null;

    public PreferencesDialog(Frame frame, URL uRL) {
        super(frame, "Preferences", "User preferences", "Update/Import preferences and restart the application. Press the 'enter' key for validating a preference change", null);
        try {
            if (uRL != null) {
                this.subGroup = new Properties();
                this.subGroup.load(uRL.openStream());
                this.mapGroupTreeNode = new HashMap();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.initUI();
    }

    public PreferencesDialog(Frame frame) {
        this(frame, (URL)null);
    }

    private void initUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.treeGroup = new TreeGroup();
        this.cardPanel = new JPanel();
        JSplitPane jSplitPane = new JSplitPane(1, new JScrollPane(this.treeGroup), this.cardPanel);
        jSplitPane.setDividerLocation(150);
        jPanel.add(jSplitPane);
        this.card = new CardLayout();
        this.cardPanel.setLayout(this.card);
        this.preparePreferences();
        this.prepareTree();
        this.setUI(jPanel);
        jPanel.setPreferredSize(new Dimension(600, 500));
    }

    protected DialogActionModel prepareActionModel() {
        DialogActionModel dialogActionModel = DialogManager.buildNewActionModel();
        dialogActionModel.addDialogAction(new ImportAction());
        dialogActionModel.addDialogAction(new ExportAction());
        dialogActionModel.addDialogAction(new RestoreAction());
        return dialogActionModel;
    }

    public void beforeShowing() {
        super.beforeShowing();
        this.treeGroup.addTreeSelectionListener(this);
    }

    public void beforeClosing() {
        super.beforeClosing();
        this.treeGroup.removeTreeSelectionListener(this);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        if (!defaultMutableTreeNode.isLeaf()) {
            return;
        }
        this.card.show(this.cardPanel, (String)defaultMutableTreeNode.getUserObject());
    }

    private void preparePreferences() {
        Properties properties = Preferences.getCurrentPreferences();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.endsWith(".value")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = string2 + "." + string3 + ".type";
            String string5 = properties.getProperty(string);
            try {
                int n = Integer.parseInt(properties.getProperty(string4));
                this.addValue(string2, string3, n, string5);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void prepareTree() {
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.createRoot());
        this.treeGroup.setModel(defaultTreeModel);
    }

    private TreeNode createRoot() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Preferences");
        if (this.models == null) {
            return defaultMutableTreeNode;
        }
        Set set = this.models.keySet();
        for (String string : set) {
            if (string.equalsIgnoreCase("system") || string.equalsIgnoreCase("dialog")) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
            if (this.mapGroupTreeNode != null && this.subGroup != null) {
                String string2 = this.subGroup.getProperty(string);
                if (string2 == null) {
                    string2 = "other";
                }
                if (!this.mapGroupTreeNode.containsKey(string2)) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
                    Toolkit.addNodeOrdering(defaultMutableTreeNode, defaultMutableTreeNode2);
                    this.mapGroupTreeNode.put(string2, defaultMutableTreeNode2);
                } else {
                    defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.mapGroupTreeNode.get(string2);
                }
            }
            Toolkit.addNodeOrdering(defaultMutableTreeNode2, new DefaultMutableTreeNode(string));
            this.addPanel(string, (DefaultTableModel)this.models.get(string));
        }
        return defaultMutableTreeNode;
    }

    private void addPanel(String string, DefaultTableModel defaultTableModel) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(string));
        this.table = new JTable();
        this.table.setModel(defaultTableModel);
        this.table.getColumnModel().getColumn(1).setCellRenderer(new ValueRenderer());
        this.table.getColumnModel().getColumn(1).setCellEditor(new ValueEditor());
        this.table.setSelectionBackground(this.table.getBackground());
        this.table.setSelectionForeground(this.table.getForeground());
        this.table.setSelectionMode(0);
        jPanel.setLayout(new BorderLayout());
        jPanel.add(new JScrollPane(this.table));
        this.cardPanel.add((Component)jPanel, string);
    }

    private void addValue(String string, String string2, int n, String string3) {
        DefaultTableModel defaultTableModel;
        if (this.models == null) {
            this.models = new HashMap();
        }
        if ((defaultTableModel = (DefaultTableModel)this.models.get(string)) == null) {
            defaultTableModel = new DefaultTableModel(new Object[]{"Name", "Value"}, 0){

                public boolean isCellEditable(int n, int n2) {
                    return n2 == 1;
                }
            };
            this.models.put(string, defaultTableModel);
        }
        boolean bl = false;
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            String string4 = (String)defaultTableModel.getValueAt(i, 0);
            if (string4.compareTo(string2) <= 0) continue;
            defaultTableModel.insertRow(i, new Object[]{string2, Preferences.getValueByType(n, string3)});
            bl = true;
            break;
        }
        if (!bl) {
            defaultTableModel.addRow(new Object[]{string2, Preferences.getValueByType(n, string3)});
        }
    }

    public void storePreferences() {
        if (this.models == null) {
            return;
        }
        for (String string : this.models.keySet()) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.models.get(string);
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                Preferences.setRawPreference(string, (String)defaultTableModel.getValueAt(i, 0), defaultTableModel.getValueAt(i, 1));
            }
        }
        Preferences.savePreferences();
    }

    class ImportAction
    extends AbstractDialogAction {
        public ImportAction() {
            super(11, false);
            this.putValue("SmallIcon", new ImageIcon(ClassLoader.getSystemResource("images/import1.png")));
            this.putValue("ShortDescription", "Import the preferences");
            this.setSpecial(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showOpenDialog(PreferencesDialog.this) == 0) {
                try {
                    Preferences.preferences.load(new FileInputStream(jFileChooser.getSelectedFile()));
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(PreferencesDialog.this, iOException.getMessage());
                }
            }
        }
    }

    class ExportAction
    extends AbstractDialogAction {
        public ExportAction() {
            super(10, false);
            this.putValue("SmallIcon", new ImageIcon(ClassLoader.getSystemResource("images/export1.png")));
            this.putValue("ShortDescription", "Export the preferences");
            this.setSpecial(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showSaveDialog(PreferencesDialog.this) == 0) {
                try {
                    Preferences.preferences.save(new FileOutputStream(jFileChooser.getSelectedFile()), null);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(PreferencesDialog.this, iOException.getMessage());
                }
            }
        }
    }

    class RestoreAction
    extends AbstractDialogAction {
        public RestoreAction() {
            super(12, false);
            this.putValue("SmallIcon", new ImageIcon(ClassLoader.getSystemResource("images/replace2.png")));
            this.putValue("ShortDescription", "Restore the default preferences");
            this.setSpecial(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JOptionPane.showConfirmDialog(PreferencesDialog.this, "Restore the default preferences and restart the application ?") == 0) {
                Preferences.cleanPreferences();
                PreferencesDialog.this.setLastAction(100);
                PreferencesDialog.this.setVisible(false);
            }
        }
    }

    class CharacterDocument
    extends PlainDocument {
        CharacterDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.getLength() > 0) {
                super.remove(0, 1);
            }
            if (string.length() == 1) {
                string = string.toUpperCase();
                super.insertString(n, string, attributeSet);
            }
        }
    }

    class IntegerDocument
    extends PlainDocument {
        IntegerDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }

    class ColorIcon
    implements Icon {
        public Color color;

        ColorIcon() {
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.color);
            graphics.fillRect(0, 0, 16, 16);
        }
    }

    class ValueRenderer
    extends DefaultTableCellRenderer {
        private JButton btnColor = new JButton("...");
        private JButton btnFont = new JButton("FONT");
        private JButton btnRectangle = new JButton();
        private JComboBox cbChoice = new JComboBox();
        private JLabel lbl = new JLabel();
        private ColorIcon colorIcon = new ColorIcon();

        ValueRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Color) {
                this.colorIcon.color = (Color)object;
                this.btnColor.setIcon(this.colorIcon);
                return this.btnColor;
            }
            if (object instanceof Font) {
                this.btnFont.setText("FONT");
                this.btnFont.setFont((Font)object);
                return this.btnFont;
            }
            if (object instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)object;
                this.btnRectangle.setText(rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height);
                return this.btnRectangle;
            }
            if (object instanceof String[]) {
                DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
                String[] stringArray = (String[])object;
                for (int i = 0; i < stringArray.length; ++i) {
                    defaultComboBoxModel.addElement(stringArray[i]);
                }
                this.cbChoice.setModel(defaultComboBoxModel);
                this.cbChoice.setSelectedIndex(0);
                return this.cbChoice;
            }
            this.lbl.setText(object.toString());
            return this.lbl;
        }
    }

    class ValueEditor
    extends AbstractCellEditor
    implements ActionListener,
    TableCellEditor {
        private JButton buttonColor = new JButton("...");
        private JButton buttonFont = new JButton("FONT");
        private JButton buttonRectangle = new JButton("...");
        private JTextField textFieldInteger = new JTextField();
        private JComboBox cbChoice = new JComboBox();
        private JComboBox cbBoolean = new JComboBox<String>(new String[]{"true", "false"});
        private IntegerDocument doci = new IntegerDocument();
        private CharacterDocument docc = new CharacterDocument();
        private JComponent comp = null;
        private int lastRow = -1;
        private int lastType = -1;
        private Object currentValue = null;

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            super.addCellEditorListener(cellEditorListener);
            this.buttonColor.addActionListener(this);
            this.buttonFont.addActionListener(this);
            this.buttonRectangle.addActionListener(this);
            this.textFieldInteger.addActionListener(this);
            this.cbChoice.addActionListener(this);
            this.cbBoolean.addActionListener(this);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            super.removeCellEditorListener(cellEditorListener);
            this.buttonColor.removeActionListener(this);
            this.buttonFont.removeActionListener(this);
            this.buttonRectangle.removeActionListener(this);
            this.textFieldInteger.removeActionListener(this);
            this.cbChoice.removeActionListener(this);
            this.cbBoolean.removeActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.buttonColor) {
                Color color = JColorChooser.showDialog(this.buttonColor, "Color", this.buttonColor.getBackground());
                if (color != null) {
                    this.buttonColor.setBackground(color);
                    this.currentValue = color;
                }
            } else if (actionEvent.getSource() == this.buttonFont) {
                FontDialog fontDialog = new FontDialog((Dialog)PreferencesDialog.this, this.buttonFont.getFont());
                fontDialog.setVisible(true);
                if (fontDialog.isOk()) {
                    fontDialog.dispose();
                    this.currentValue = fontDialog.getValue();
                    this.buttonFont.setFont((Font)this.currentValue);
                }
            } else if (actionEvent.getSource() == this.textFieldInteger) {
                try {
                    if (this.lastType == 0) {
                        this.currentValue = new Integer(this.textFieldInteger.getText());
                    } else if (this.lastType == 5) {
                        if (this.textFieldInteger.getText().length() > 0) {
                            this.currentValue = new Character(this.textFieldInteger.getText().charAt(0));
                        }
                    } else if (this.lastType == 6) {
                        this.currentValue = this.textFieldInteger.getText();
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (actionEvent.getSource() == this.buttonRectangle) {
                JDialog jDialog = new JDialog();
                jDialog.setModal(true);
                jDialog.setTitle("Choose location and size");
                jDialog.setBounds((Rectangle)this.currentValue);
                jDialog.setVisible(true);
                this.currentValue = jDialog.getBounds();
            } else if (actionEvent.getSource() == this.cbChoice) {
                String[] stringArray = (String[])this.currentValue;
                String string = (String)this.cbChoice.getSelectedItem();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(string)) continue;
                    String string2 = stringArray[0];
                    stringArray[0] = string;
                    stringArray[i] = string2;
                    break;
                }
                this.currentValue = stringArray;
            } else if (actionEvent.getSource() == this.cbBoolean) {
                this.currentValue = new Boolean("true".equals(this.cbBoolean.getSelectedItem()));
            }
            this.fireEditingStopped();
        }

        public Object getCellEditorValue() {
            return this.currentValue;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentValue = object;
            this.lastRow = n;
            if (object instanceof Color) {
                this.lastType = 1;
                this.buttonColor.setBackground((Color)object);
                return this.buttonColor;
            }
            if (object instanceof Integer) {
                this.lastType = 0;
                this.textFieldInteger.setDocument(this.doci);
                this.textFieldInteger.setText(object.toString());
                return this.textFieldInteger;
            }
            if (object instanceof Font) {
                this.lastType = 2;
                this.buttonFont.setFont((Font)object);
                return this.buttonFont;
            }
            if (object instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)object;
                this.buttonRectangle.setText(rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height);
                return this.buttonRectangle;
            }
            if (object instanceof String[]) {
                DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
                String[] stringArray = (String[])object;
                for (int i = 0; i < stringArray.length; ++i) {
                    defaultComboBoxModel.addElement(stringArray[i]);
                }
                this.cbChoice.setModel(defaultComboBoxModel);
                this.cbChoice.setSelectedIndex(0);
                return this.cbChoice;
            }
            if (object instanceof Character) {
                this.lastType = 5;
                this.textFieldInteger.setDocument(this.docc);
                this.textFieldInteger.setText(((Character)object).toString());
                return this.textFieldInteger;
            }
            if (object instanceof String) {
                this.lastType = 6;
                this.textFieldInteger.setDocument(new PlainDocument());
                this.textFieldInteger.setText(object.toString());
                return this.textFieldInteger;
            }
            if (object instanceof Boolean) {
                this.lastType = 7;
                this.cbBoolean.setSelectedItem(object.toString());
                return this.cbBoolean;
            }
            return null;
        }
    }
}

