/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.step;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.ApplicationStepAdapter;
import com.japisoft.framework.log.Logger;
import com.japisoft.framework.preferences.Preferences;
import java.util.ArrayList;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class LookAndFeelStep
extends ApplicationStepAdapter {
    private String defaultLookAndFeel;

    public LookAndFeelStep(String string) {
        this.defaultLookAndFeel = string;
    }

    public LookAndFeelStep() {
        this.defaultLookAndFeel = UIManager.getSystemLookAndFeelClassName();
    }

    public void start(String[] stringArray) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("DEFAULT");
        for (int i = 0; lookAndFeelInfoArray != null && i < lookAndFeelInfoArray.length; ++i) {
            arrayList.add(lookAndFeelInfoArray[i].getClassName());
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        String string = Preferences.getPreference("interface", "lookAndFeel", stringArray2)[0];
        LookAndFeel lookAndFeel = null;
        if ("DEFAULT".equals(string)) {
            if (ApplicationModel.MACOSX_MODE) {
                if (this.defaultLookAndFeel != null) {
                    arrayList.add(this.defaultLookAndFeel);
                }
                lookAndFeel = UIManager.getLookAndFeel();
            } else {
                string = this.defaultLookAndFeel;
            }
        }
        try {
            if (lookAndFeel == null) {
                lookAndFeel = (LookAndFeel)Class.forName(string).newInstance();
            }
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Throwable throwable) {
            Logger.addWarning("Can't use this lookAndFeel " + string);
        }
    }
}

