/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.wizard;

import com.japisoft.framework.wizard.DefaultWizardStepModel;
import com.japisoft.framework.wizard.DefaultWizardView;
import com.japisoft.framework.wizard.WizardListener;
import com.japisoft.framework.wizard.WizardStep;
import com.japisoft.framework.wizard.WizardStepContext;
import com.japisoft.framework.wizard.WizardStepModel;
import com.japisoft.framework.wizard.WizardView;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public class JWizard {
    public static int OK_ACTION = 0;
    public static int CANCEL_ACTION = 1;
    private WizardStepModel model;
    private ResourceBundle labels = null;
    private WizardView view;
    Icon image;
    private boolean numberedStep = true;
    private boolean wizardStepLabel = true;
    private int currentStep = 0;
    private int lastStep = -1;
    boolean preparedDialog = false;
    private Dimension dim = null;
    private Dimension dim2 = null;
    private Color colorbg = null;
    private int currentState = CANCEL_ACTION;
    private JDialog dialog = null;
    EventListenerList listeners = null;
    WizardStepContext currentContext = null;

    public JWizard() {
        if (UIManager.get("com.japisoft.jwizard.labelbg") == null) {
            UIManager.put("com.japisoft.jwizard.labelbg", Color.WHITE);
        }
        try {
            this.labels = ResourceBundle.getBundle("com/japisoft/framework/wizard/JWizard");
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("No resource bundle found");
        }
    }

    public void setWizardStepModel(WizardStepModel wizardStepModel) {
        this.model = wizardStepModel;
    }

    public WizardStepModel getWizardStepModel() {
        if (this.model == null) {
            this.model = new DefaultWizardStepModel(this);
        }
        return this.model;
    }

    public void setView(WizardView wizardView) {
        this.view = wizardView;
    }

    public WizardView getView() {
        if (this.view == null) {
            this.view = new DefaultWizardView(this);
        }
        return this.view;
    }

    public void setImage(Icon icon) {
        this.image = icon;
    }

    public Icon getImage() {
        if (this.image == null) {
            return UIManager.getIcon("com.japisoft.jwizard.image");
        }
        return this.image;
    }

    public boolean isNumberedStep() {
        return this.numberedStep;
    }

    public void setNumberedStep(boolean bl) {
        this.numberedStep = bl;
    }

    public void setWizardStepTitle(boolean bl) {
        this.wizardStepLabel = bl;
    }

    public boolean isWizardStepTitle() {
        return this.wizardStepLabel;
    }

    protected String getLabel(String string, String string2) {
        try {
            String string3;
            String string4 = string3 = this.labels != null ? this.labels.getString(string) : string2;
            if (string3 == null) {
                string3 = string2;
            }
            return string3;
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    void prepareWizards() {
        this.getView().updateView(this.getWizardStepModel());
        if (this.getWizardStepModel().getWizardStepCount() > 0) {
            this.startWizard(this.getWizardStepModel().getWizardStep(0));
        }
    }

    protected void startWizard(WizardStep wizardStep) {
        this.currentStep = this.getWizardStepModel().getWizardStepIndex(wizardStep);
        this.currentContext = new CustomWizardStepContext();
        this.activateCurrentStep();
    }

    private void stop(int n) {
        WizardStep wizardStep = this.getWizardStepModel().getWizardStep(n);
        this.notifyStopWizard(wizardStep);
        wizardStep.stop(this.currentContext);
        wizardStep.getStepView().stop(this.currentContext);
    }

    private boolean activateCurrentStep() {
        WizardStep wizardStep;
        if (this.lastStep != -1) {
            this.stop(this.lastStep);
        }
        if (!(wizardStep = this.getWizardStepModel().getWizardStep(this.currentStep)).canStart(this.currentContext)) {
            if (this.lastStep != -1) {
                this.currentStep = this.lastStep;
            }
            return false;
        }
        this.lastStep = this.currentStep;
        this.currentContext.acceptNext(false);
        this.currentContext.acceptPrevious(false);
        wizardStep.start(this.currentContext);
        wizardStep.getStepView().start(this.currentContext);
        this.notifyStartWizard(wizardStep);
        this.getView().activate(wizardStep);
        return true;
    }

    private void prepareDialog(JDialog jDialog) {
        this.preparedDialog = true;
        this.prepareWizards();
        jDialog.setDefaultCloseOperation(2);
        jDialog.getContentPane().add(this.getView().getView());
        jDialog.pack();
        jDialog.setModal(true);
    }

    public int show(Frame frame, String string) {
        this.dialog = new JDialog(frame, string);
        this.prepareDialog(this.dialog);
        this.dialog.setVisible(true);
        return this.currentState;
    }

    public int show(Dialog dialog, String string) {
        this.dialog = new JDialog(dialog, string);
        return this.show(this.dialog, true);
    }

    public int show(String string) {
        this.dialog = new JDialog((Frame)null, string);
        return this.show(this.dialog, true);
    }

    public int show(JDialog jDialog, boolean bl) {
        this.dialog = jDialog;
        if (bl) {
            this.prepareDialog(jDialog);
        }
        jDialog.setVisible(true);
        return this.currentState;
    }

    public void setViewPreferredSize(Dimension dimension) {
        this.dim = dimension;
    }

    public Dimension getViewPreferredSize() {
        if (this.dim == null) {
            this.dim = new Dimension(400, 200);
        }
        return this.dim;
    }

    public void setLabelsPreferredSize(Dimension dimension) {
        this.dim2 = dimension;
    }

    public Dimension getLabelsPreferredSize() {
        if (this.dim2 == null) {
            this.dim2 = new Dimension(100, 200);
        }
        return this.dim2;
    }

    public Color getStepLabelsBackground() {
        if (this.colorbg == null) {
            return UIManager.getColor("com.japisoft.jwizard.labelbg");
        }
        return this.colorbg;
    }

    public void setStepLabelsBackground(Color color) {
        this.colorbg = color;
    }

    void actionNext() {
        ++this.currentStep;
        this.activateCurrentStep();
    }

    void actionPrevious() {
        --this.currentStep;
        this.activateCurrentStep();
    }

    void actionOk() {
        this.currentState = OK_ACTION;
        this.stop(this.currentStep);
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.dialog = null;
    }

    void actionCancel() {
        this.currentState = CANCEL_ACTION;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.dialog = null;
    }

    public WizardStepContext getWizardContext() {
        return this.currentContext;
    }

    public void dispose() {
        this.currentContext = null;
        this.dialog = null;
    }

    public void addWizardListener(WizardListener wizardListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(WizardListener.class, wizardListener);
    }

    public void removeWizardListener(WizardListener wizardListener) {
        if (this.listeners != null) {
            this.listeners.remove(WizardListener.class, wizardListener);
        }
    }

    void notifyStartWizard(WizardStep wizardStep) {
        if (this.listeners != null) {
            EventListener[] eventListenerArray = this.listeners.getListeners(WizardListener.class);
            for (int i = 0; i < eventListenerArray.length; ++i) {
                ((WizardListener)eventListenerArray[i]).startWizardStep(wizardStep);
            }
        }
    }

    void notifyStopWizard(WizardStep wizardStep) {
        if (this.listeners != null) {
            EventListener[] eventListenerArray = this.listeners.getListeners(WizardListener.class);
            for (int i = 0; i < eventListenerArray.length; ++i) {
                ((WizardListener)eventListenerArray[i]).stopWizardStep(wizardStep);
            }
        }
    }

    class CustomWizardStepContext
    implements WizardStepContext {
        private Hashtable ht = null;

        CustomWizardStepContext() {
        }

        public void acceptNext(boolean bl) {
            JWizard.this.getView().setEnabledNextAction(bl);
        }

        public void goTo(WizardStep wizardStep) {
            JWizard.this.startWizard(wizardStep);
        }

        public void acceptPrevious(boolean bl) {
            JWizard.this.getView().setEnabledPreviousAction(bl);
        }

        public Object getSharedData(String string) {
            if (this.ht == null) {
                return null;
            }
            return this.ht.get(string);
        }

        public Object getSharedData(String string, Object object) {
            Object object2 = this.getSharedData(string);
            if (object2 == null) {
                return object;
            }
            return object2;
        }

        public WizardStep getNextWizardStep() {
            if (JWizard.this.currentStep + 1 < JWizard.this.getWizardStepModel().getWizardStepCount()) {
                return JWizard.this.getWizardStepModel().getWizardStep(JWizard.this.currentStep + 1);
            }
            return null;
        }

        public WizardStep getPreviousWizardStep() {
            if (JWizard.this.currentStep - 1 >= 0) {
                return JWizard.this.getWizardStepModel().getWizardStep(JWizard.this.currentStep - 1);
            }
            return null;
        }

        public JWizard getSource() {
            return JWizard.this;
        }

        public void setSharedData(String string, Object object) {
            if (this.ht == null) {
                this.ht = new Hashtable();
            }
            if (object == null) {
                this.ht.remove(string);
            } else {
                this.ht.put(string, object);
            }
        }
    }
}

