/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.treefilebrowser;

import com.japisoft.framework.ui.FastLabel;
import com.japisoft.treefilebrowser.FileFilter;
import com.japisoft.treefilebrowser.FileFilterListener;
import com.japisoft.treefilebrowser.FileFilterModel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class FileFilterCombo
extends JComboBox
implements ItemListener {
    private FileFilterListener listener;

    public FileFilterCombo() {
        this.setRenderer(new FileFilterRenderer());
    }

    public void setListener(FileFilterListener fileFilterListener) {
        this.listener = fileFilterListener;
    }

    public void addNotify() {
        super.addNotify();
        this.addItemListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeItemListener(this);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.listener != null) {
            this.listener.setActifFileFilter((FileFilter)itemEvent.getItem());
        }
    }

    void init(FileFilterModel fileFilterModel) {
        this.removeAllItems();
        for (int i = 0; i < fileFilterModel.getFileFilterCount(); ++i) {
            FileFilter fileFilter = fileFilterModel.getFileFilter(i);
            this.addItem(fileFilter);
        }
    }

    class FileFilterRenderer
    implements ListCellRenderer {
        FastLabel lbl = new FastLabel();

        FileFilterRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.lbl.setBackground(jList.getSelectionBackground());
                this.lbl.setForeground(jList.getSelectionForeground());
            } else {
                this.lbl.setBackground(jList.getBackground());
                this.lbl.setForeground(jList.getForeground());
            }
            FileFilter fileFilter = (FileFilter)object;
            this.lbl.setText(fileFilter.getDescription());
            this.lbl.setIcon(fileFilter.getIcon());
            return this.lbl;
        }
    }
}

