/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.component;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.app.toolkit.Toolkit;
import com.japisoft.framework.xml.grammar.GrammarNode;
import com.japisoft.framework.xml.grammar.GrammarText;
import com.japisoft.framework.xml.grammar.GrammarType;
import com.japisoft.xmlform.component.AbstractXMLFormComponent;
import com.japisoft.xmlform.component.ComponentContext;
import com.japisoft.xmlform.component.XMLFormLabelComponent;
import com.japisoft.xmlform.component.XMLFormSeparatorComponent;
import com.japisoft.xmlform.component.container.XMLFormContainer;
import com.japisoft.xmlform.component.editable.XMLEnumComponent;
import com.japisoft.xmlform.component.editable.XMLFormTextComponent;
import com.japisoft.xmlform.designer.XmlFormModel;
import com.japisoft.xmlform.designer.data.GrammarNodeTreeNode;
import com.japisoft.xmlform.designer.library.ComponentDescriptor;
import com.japisoft.xmlform.designer.library.ComponentDescriptorModel;
import java.awt.Dimension;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFormComponentFactory {
    private boolean editableMode = false;
    private ComponentContext context = null;

    public XMLFormComponentFactory(boolean bl, ComponentContext componentContext) {
        this.editableMode = bl;
        this.context = componentContext;
    }

    public XMLFormContainer newRootContainer() {
        XMLFormContainer xMLFormContainer = new XMLFormContainer(this.editableMode, this.context);
        xMLFormContainer.setTopComponent(true);
        return xMLFormContainer;
    }

    public AbstractXMLFormComponent newComponentFromTreeNode(GrammarNodeTreeNode grammarNodeTreeNode) {
        List<GrammarNode> list;
        GrammarNode grammarNode = grammarNodeTreeNode.getSource();
        GrammarType grammarType = grammarNode.getType();
        if (!"complex".equals(grammarType.getType()) && (list = grammarType.getValues()) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (GrammarNode stringArray : list) {
                if (!(stringArray instanceof GrammarText)) continue;
                arrayList.add(((GrammarText)stringArray).getValue());
            }
            if (arrayList.size() > 0) {
                XMLEnumComponent xMLEnumComponent = new XMLEnumComponent(true, this.context);
                String[] stringArray = new String[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                xMLEnumComponent.setValues(stringArray);
                return xMLEnumComponent;
            }
        }
        return this.newComponentFromTreeNode(grammarNodeTreeNode.toXPath());
    }

    public AbstractXMLFormComponent newComponentFromTreeNode(String string) {
        AbstractXMLFormComponent abstractXMLFormComponent = null;
        if (string.endsWith("text()") || string.contains("@")) {
            boolean bl = string.endsWith("text()");
            abstractXMLFormComponent = new XMLFormTextComponent(true, this.context, bl);
        } else {
            abstractXMLFormComponent = new XMLFormContainer(true, this.context);
        }
        return abstractXMLFormComponent;
    }

    public AbstractXMLFormComponent newComponentFromDescriptor(String string) {
        try {
            ComponentDescriptor componentDescriptor = ComponentDescriptorModel.getComponentDescriptor(string);
            if (componentDescriptor == null) {
                return null;
            }
            return componentDescriptor.create(true, this.context);
        }
        catch (Exception exception) {
            ApplicationModel.debug(exception);
            return null;
        }
    }

    public JButton newAddDeleteComponent() {
        JButton jButton = new JButton(Toolkit.getImageIcon("images/nav_down_blue.png"));
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setMargin(null);
        jButton.setPreferredSize(new Dimension(10, 10));
        return jButton;
    }

    public JMenuItem newAddMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Add a new item", Toolkit.getImageIcon("images/element_add.png"));
        jMenuItem.setActionCommand("add");
        return jMenuItem;
    }

    public JMenuItem newDeleteMenuItem() {
        JMenuItem jMenuItem = new JMenuItem("Delete this Item", Toolkit.getImageIcon("images/element_delete.png"));
        jMenuItem.setActionCommand("delete");
        return jMenuItem;
    }

    public AbstractXMLFormComponent newComponent(String string, HashMap<String, Object> hashMap, boolean bl, ComponentContext componentContext) throws Exception {
        AbstractXMLFormComponent abstractXMLFormComponent = null;
        if (XMLFormContainer.class.getName().equals(string)) {
            abstractXMLFormComponent = new XMLFormContainer(bl, componentContext);
        } else if (XMLFormTextComponent.class.getName().equals(string)) {
            boolean bl2 = false;
            if (hashMap != null && hashMap.containsKey("multiLine")) {
                bl2 = (Boolean)hashMap.get("multiLine");
            }
            abstractXMLFormComponent = new XMLFormTextComponent(bl, componentContext, bl2);
        } else if (XMLFormLabelComponent.class.getName().equals(string)) {
            abstractXMLFormComponent = new XMLFormLabelComponent(bl, componentContext);
        } else if (XMLFormSeparatorComponent.class.getName().equals(string)) {
            abstractXMLFormComponent = new XMLFormSeparatorComponent(bl, componentContext);
        } else if (XMLEnumComponent.class.getName().equals(string)) {
            abstractXMLFormComponent = new XMLEnumComponent(bl, componentContext);
        } else {
            throw new Exception("Unknown component " + string + "?");
        }
        if (hashMap != null) {
            for (String string2 : hashMap.keySet()) {
                String string3 = "set" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
                Object object = hashMap.get(string2);
                try {
                    Class<Object> clazz = object.getClass();
                    if (clazz == Boolean.class) {
                        clazz = Boolean.TYPE;
                    }
                    if (clazz == Integer.class) {
                        clazz = Integer.TYPE;
                    }
                    Method method = abstractXMLFormComponent.getClass().getMethod(string3, clazz);
                    method.invoke((Object)abstractXMLFormComponent, object);
                }
                catch (Exception exception) {
                    XmlFormModel.debug(exception);
                }
            }
        }
        return abstractXMLFormComponent;
    }
}

