/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.component.container;

import com.japisoft.xmlform.component.AbstractXMLFormComponent;
import com.japisoft.xmlform.component.ComponentContext;
import com.japisoft.xmlform.component.container.GridComponent;
import com.japisoft.xmlform.component.editable.XMLEditableComponent;
import com.japisoft.xmlform.designer.properties.PropertyDescriptor;
import com.japisoft.xmlform.designer.properties.PropertyDescriptorImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFormContainer
extends AbstractXMLFormComponent
implements Action {
    private GridComponent gc = null;
    private String schemaURI = null;
    private String formURI = null;
    private String title = null;

    public XMLFormContainer(boolean bl, ComponentContext componentContext) {
        super(bl, componentContext);
        this.gc = new GridComponent(bl, componentContext);
        super.add(this.gc);
        this.setPreferredSize(new Dimension(200, 200));
        if (!bl) {
            this.setBorder(new LineBorder(Color.GRAY));
        } else {
            this.getActionMap().put("delete", this);
            this.getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), "delete");
        }
    }

    public void setSchemaURI(String string) {
        this.schemaURI = string;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    public void setFormTemplateURI(String string) {
        this.formURI = string;
    }

    public String getFormTemplateURI() {
        return this.formURI;
    }

    @Override
    public Container getComponentContainer() {
        return this.gc;
    }

    @Override
    public Component add(Component component) {
        return this.gc.add(component);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.designMode) {
            this.gc.addMouseListener(this);
            this.gc.addMouseMotionListener(this);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.gc.removeMouseListener(this);
        this.gc.removeMouseMotionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        if ("fc:delete".equals(actionEvent.getActionCommand())) {
            this.context.action(1, null);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("ActionCommandKey".equals(string)) {
            return "fc:delete";
        }
        return null;
    }

    private void setTitleForeground(Color color) {
        if (this.label == null && this.title != null) {
            this.updateLabel(this.title);
        }
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        this.firePropertyChange("foreground", this.gc.getForeground(), color);
        this.gc.setForeground(color);
        this.setTitleForeground(color);
    }

    @Override
    public Color getForeground() {
        return this.gc.getForeground();
    }

    @Override
    public void setBackground(Color color) {
        this.firePropertyChange("background", this.gc.getBackground(), color);
        this.gc.setBackground(color);
    }

    private void setTitleFont(Font font) {
        if (this.label == null && this.title != null) {
            this.updateLabel(this.title);
        }
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    @Override
    public void setFont(Font font) {
        this.firePropertyChange("font", this.gc.getFont(), font);
        this.gc.setFont(font);
        this.setTitleFont(font);
    }

    @Override
    public Font getFont() {
        return this.gc.getFont();
    }

    @Override
    public Color getBackground() {
        return this.gc.getBackground();
    }

    public void setTitle(String string) {
        this.firePropertyChange("title", this.title, string);
        this.title = string;
        this.updateLabel(this.resolveTitle());
    }

    @Override
    protected String resolveTitle() {
        if (this.title == null) {
            return super.resolveTitle();
        }
        if (!this.designMode) {
            return " " + this.title;
        }
        return "<html><body> title : " + this.title + " - <i> xpath : " + this.xpath + "</i> </body></html>";
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void putValue(String string, Object object) {
    }

    @Override
    public void requestFocus() {
        Component component = this.getNearest(this.gc, null);
        if (component != null && component instanceof AbstractXMLFormComponent) {
            ((AbstractXMLFormComponent)component).requestFocus();
        }
    }

    public XMLEditableComponent getFirstEditableComponent() {
        int n = Integer.MAX_VALUE;
        AbstractXMLFormComponent abstractXMLFormComponent = null;
        for (int i = 0; i < this.gc.getComponentCount(); ++i) {
            Component component = this.gc.getComponent(i);
            if (!(component instanceof XMLFormContainer) && !(component instanceof XMLEditableComponent) || component.getY() >= n) continue;
            abstractXMLFormComponent = (AbstractXMLFormComponent)component;
            n = component.getY();
        }
        if (abstractXMLFormComponent instanceof XMLEditableComponent) {
            return (XMLEditableComponent)abstractXMLFormComponent;
        }
        if (abstractXMLFormComponent instanceof XMLFormContainer) {
            return ((XMLFormContainer)abstractXMLFormComponent).getFirstEditableComponent();
        }
        return null;
    }

    @Override
    protected void prepareProperties(ArrayList<PropertyDescriptor> arrayList) throws Exception {
        super.prepareProperties(arrayList);
        arrayList.add(new PropertyDescriptorImpl("title", String.class, this));
    }

    public void cut() {
        this.context.action(1, null);
    }
}

