/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.designer.properties.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;

public class FontChooser
extends JPanel
implements ListSelectionListener,
ActionListener {
    private Font currentFont = null;
    private JButton btnCancel;
    private JButton btnOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JList lstFont;
    private JList lstSize;
    private JList lstStyle;
    private JScrollPane spFont;
    private JScrollPane spPreview;
    private JScrollPane spSize;
    private JScrollPane spStyle;
    private JTextArea txtPreview;

    public FontChooser() {
        this.initComponents();
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.lstFont.setListData(stringArray);
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        for (int i = 8; i <= 72; i += 2) {
            defaultListModel.addElement(i);
        }
        this.lstSize.setModel(defaultListModel);
        defaultListModel = new DefaultListModel();
        defaultListModel.addElement("Plain");
        defaultListModel.addElement("Bold");
        defaultListModel.addElement("Italic");
        this.lstStyle.setModel(defaultListModel);
        this.lstStyle.setSelectedIndex(0);
        this.lstSize.setSelectedIndex(0);
        this.lstFont.setSelectedIndex(0);
    }

    public void addNotify() {
        super.addNotify();
        this.lstFont.addListSelectionListener(this);
        this.lstSize.addListSelectionListener(this);
        this.lstStyle.addListSelectionListener(this);
        this.btnOk.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.lstFont.removeListSelectionListener(this);
        this.lstSize.removeListSelectionListener(this);
        this.lstStyle.removeListSelectionListener(this);
        this.btnOk.removeActionListener(this);
        this.btnCancel.removeActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnCancel) {
            this.currentFont = null;
        }
        Window window = (Window)SwingUtilities.getRoot(this);
        window.setVisible(false);
    }

    public Font getFont() {
        return this.currentFont;
    }

    public void setFont(Font font) {
        this.currentFont = font;
        if (font != null) {
            if (this.lstFont == null) {
                return;
            }
            this.lstFont.setSelectedValue(font.getName(), true);
            this.lstSize.setSelectedValue(font.getSize(), true);
            if (font.getStyle() == 0) {
                this.lstStyle.setSelectedIndex(0);
            } else if (font.getStyle() == 1) {
                this.lstStyle.setSelectedIndex(1);
            } else {
                this.lstStyle.setSelectedIndex(2);
            }
            this.txtPreview.setFont(this.currentFont);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = 0;
        if ("Bold".equals(this.lstStyle.getSelectedValue())) {
            n = 1;
        } else if ("Italic".equals(this.lstStyle.getSelectedValue())) {
            n = 2;
        }
        this.currentFont = new Font((String)this.lstFont.getSelectedValue(), n, (Integer)this.lstSize.getSelectedValue());
        this.txtPreview.setFont(this.currentFont);
    }

    public static Font showFontChooser(Component component, String string, Font font) {
        Window window = (Window)SwingUtilities.getRoot(component);
        JDialog jDialog = null;
        jDialog = window instanceof Frame ? new JDialog((Frame)window) : new JDialog((Dialog)window);
        jDialog.setTitle(string);
        FontChooser fontChooser = new FontChooser();
        fontChooser.setFont(font);
        jDialog.add(fontChooser);
        jDialog.pack();
        jDialog.setModal(true);
        jDialog.setVisible(true);
        return fontChooser.getFont();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.spFont = new JScrollPane();
        this.lstFont = new JList();
        this.jLabel2 = new JLabel();
        this.spStyle = new JScrollPane();
        this.lstStyle = new JList();
        this.jLabel3 = new JLabel();
        this.spSize = new JScrollPane();
        this.lstSize = new JList();
        this.jSeparator1 = new JSeparator();
        this.jLabel4 = new JLabel();
        this.spPreview = new JScrollPane();
        this.txtPreview = new JTextArea();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.jLabel1.setText("Font");
        this.lstFont.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.spFont.setViewportView(this.lstFont);
        this.jLabel2.setText("Style");
        this.lstStyle.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.spStyle.setViewportView(this.lstStyle);
        this.jLabel3.setText("Size");
        this.lstSize.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.spSize.setViewportView(this.lstSize);
        this.jLabel4.setText("Preview");
        this.txtPreview.setColumns(20);
        this.txtPreview.setRows(5);
        this.txtPreview.setText("Your text");
        this.spPreview.setViewportView(this.txtPreview);
        this.btnOk.setText("Ok");
        this.btnCancel.setText("Cancel");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 400, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.spFont, -2, 158, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.spStyle, -2, 143, -2)).addPreferredGap(0, 17, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.spSize, -2, 64, -2))).add((Component)this.jLabel4).add((Component)this.spPreview, -1, 400, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.btnOk).add(12, 12, 12).add((Component)this.btnCancel))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.spSize).add((Component)this.spStyle).add((Component)this.spFont, -1, 166, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.spPreview, -2, 51, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnOk).add((Component)this.btnCancel)).addContainerGap()));
    }
}

