/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.action.xml;

import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.action.XMLAction;
import com.japisoft.xmlpad.dialog.DialogManager;
import com.japisoft.xmlpad.editor.XMLDocument;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class CommentAction
extends XMLAction {
    public static final String ID = CommentAction.class.getName();

    public boolean notifyAction() {
        String string = null;
        int n = this.editor.getCaretPosition();
        if (((XMLDocument)this.editor.getDocument()).isInsideTagExceptAttributeValue(n)) {
            JOptionPane.showMessageDialog(this.editor, "Can't insert a comment here !");
            return INVALID_ACTION;
        }
        int n2 = this.editor.getSelectionStart();
        int n3 = this.editor.getSelectionEnd();
        Integer[] integerArray = ((XMLDocument)this.editor.getDocument()).getCommentDelimiters(n);
        int n4 = -1;
        int n5 = -1;
        int n6 = 4;
        int n7 = 7;
        if (integerArray != null) {
            n4 = integerArray[0] + 4;
            n5 = integerArray[1] - 2;
            try {
                string = this.editor.getDocument().getText(n4, n5 - n4);
                if (!this.checkComment(string)) {
                    return !XMLAction.VALID_ACTION;
                }
            }
            catch (BadLocationException badLocationException) {}
        } else if (n2 < n3) {
            try {
                string = this.editor.getDocument().getText(n2, n3 - n2);
                if (!this.checkComment(string)) {
                    return !XMLAction.VALID_ACTION;
                }
                n4 = n2;
                n5 = n3;
                n6 = 0;
                n7 = 0;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        CommentPane commentPane = new CommentPane();
        commentPane.setText(string);
        if (DialogManager.showDialog(SwingUtilities.getWindowAncestor(this.container.getView()), "Comment", "Insert/Update", "Insert or update at the current selection of your XML comment\nMultiple lines can be used", null, commentPane) != 0) {
            return VALID_ACTION;
        }
        String string2 = commentPane.getText();
        if (string2 != null) {
            boolean bl = string2.length() == 0;
            string2 = "<!--" + string2 + "-->";
            if (string == null) {
                this.editor.insertText(string2);
            } else {
                try {
                    if (n4 != -1) {
                        this.editor.getDocument().remove(n4 - n6, n5 - n4 + n7);
                    }
                    if (!bl) {
                        this.editor.getDocument().insertString(n4 - n6, string2, null);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return VALID_ACTION;
    }

    private boolean checkComment(String string) {
        if (string.indexOf("<!--") > -1) {
            JOptionPane.showMessageDialog(this.container.getView(), XMLContainer.getLocalizedMessage("COMMENT_ERROR2", "Can't comment this selected text, you must remove the comments"), XMLContainer.getLocalizedMessage("ERROR", "Error"), 0);
            return false;
        }
        return true;
    }

    protected void notifyXMLContainer() {
        this.setEnabled(this.container.isEditable());
    }

    class CommentPane
    extends JPanel {
        private JTextArea text;

        public CommentPane() {
            this.init();
            this.setPreferredSize(new Dimension(400, 300));
        }

        void init() {
            this.setLayout(new BorderLayout());
            this.text = new JTextArea();
            this.add(new JScrollPane(this.text));
            this.text.setForeground(CommentAction.this.editor.getColorForComment());
            this.text.setBackground(CommentAction.this.editor.getBackground());
        }

        public void addNotify() {
            super.addNotify();
            this.text.requestFocus();
        }

        public void setText(String string) {
            this.text.setText(string);
        }

        public String getText() {
            return this.text.getText();
        }
    }
}

