/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.elementview.table;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.elementview.ElementView;
import com.japisoft.xmlpad.elementview.ElementViewContext;
import com.japisoft.xmlpad.elementview.table.FastTableCellRenderer;
import com.japisoft.xmlpad.helper.handler.AbstractHelperHandler;
import com.japisoft.xmlpad.helper.model.AttDescriptor;
import com.japisoft.xmlpad.helper.model.AttributeHelper;
import com.japisoft.xmlpad.helper.model.CommonDescriptorRenderer;
import com.japisoft.xmlpad.helper.model.Descriptor;
import com.japisoft.xmlpad.helper.model.TagHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TableElementView
extends JTable
implements ElementView {
    private XMLContainer container;
    private Font defaultFont = new Font(null, 0, 10);
    private FastTableCellRenderer renderer = null;
    private SimpleCellEditor editor = null;
    private ElementViewContext context = null;
    private SimpleNodeModel model = null;
    private boolean editable = true;
    boolean withError = false;
    TableModelEvent singleTableEvent = null;
    TagHelper tagHelper = null;
    AttributeHelper attributeHelper = null;

    public TableElementView(XMLContainer xMLContainer) {
        this.init();
        this.container = xMLContainer;
    }

    private void init() {
        this.setTableHeader(null);
    }

    public void setTextFont(Font font) {
        this.defaultFont = font;
    }

    public Font getTextFont() {
        return this.defaultFont;
    }

    public TableCellRenderer getDefaultRenderer(Class clazz) {
        if (this.renderer == null) {
            this.renderer = new FastTableCellRenderer();
        }
        return this.renderer;
    }

    public TableCellEditor getDefaultEditor(Class clazz) {
        if (this.editor == null) {
            this.editor = new SimpleCellEditor();
        }
        return this.editor;
    }

    public void init(ElementViewContext elementViewContext) {
        this.context = elementViewContext;
    }

    public JComponent getView() {
        return this;
    }

    public void updateView(SimpleNode simpleNode) {
        if (simpleNode != null && simpleNode.isText()) {
            simpleNode = simpleNode.getSimpleParent();
        }
        this.tagHelper = null;
        this.attributeHelper = null;
        if (this.editor != null) {
            this.editor.init();
        }
        if (this.model == null) {
            this.model = new SimpleNodeModel();
            this.setModel(this.model);
        }
        if (this.editor != null) {
            this.editor.cancelCellEditing();
        }
        this.model.update(simpleNode);
    }

    public boolean autoScroll() {
        return false;
    }

    public void dispose() {
        this.context = null;
        this.container = null;
        this.tagHelper = null;
        this.attributeHelper = null;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void initErrorProcessing() {
    }

    public void stopErrorProcessing() {
        if (this.renderer != null) {
            if (this.withError) {
                this.setEditable(false);
                this.renderer.setTextColor(Color.GRAY);
                if (this.getCellEditor() != null) {
                    this.getCellEditor().stopCellEditing();
                }
            } else {
                this.renderer.setTextColor(Color.BLACK);
                this.setEditable(true);
            }
            this.repaint();
        }
    }

    public void notifyError(Object object, boolean bl, String string, int n, int n2, int n3, String string2, boolean bl2) {
        this.withError = true;
    }

    public void notifyNoError(boolean bl) {
        this.withError = false;
    }

    private String normalized(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (string.charAt(i) == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (string.charAt(i) == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (string.charAt(i) == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            if (string.charAt(i) == '\n') {
                stringBuffer.append("&#A;");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    class SimpleNodeModel
    implements TableModel {
        ArrayList content = null;
        private int startingOffset = 0;
        private int stoppingOffset = 0;
        private boolean closed = false;
        private TableModelListener oneListener = null;

        public void update(SimpleNode simpleNode) {
            if (this.content == null) {
                this.content = new ArrayList();
            } else {
                this.content.removeAll(this.content);
            }
            if (simpleNode != null) {
                String string;
                this.closed = simpleNode.isClosedLeaf();
                this.startingOffset = simpleNode.getStartingOffset();
                this.stoppingOffset = simpleNode.getStoppingOffset();
                this.content.add(new String[]{"prefix", simpleNode.getNameSpacePrefix() != null ? simpleNode.getNameSpacePrefix() : ""});
                this.content.add(new String[]{"name", simpleNode.getContent()});
                if (simpleNode.getDefaultNamespace() != null) {
                    this.content.add(new String[]{"xmlns", simpleNode.getDefaultNamespace()});
                }
                Enumeration enumeration = simpleNode.getNameSpaceDeclaration();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    this.content.add(new String[]{"xmlns:" + string, simpleNode.getNameSpaceDeclarationURI(string)});
                }
                for (int i = 0; i < simpleNode.getViewAttributeCount(); ++i) {
                    string = simpleNode.getViewAttributeAt(i);
                    String string2 = simpleNode.getAttribute(string);
                    this.content.add(new String[]{string, string2});
                }
                this.content.add(new String[]{"", ""});
            }
            this.fireUpdate();
        }

        void fireUpdate() {
            if (this.oneListener != null) {
                if (TableElementView.this.singleTableEvent == null) {
                    TableElementView.this.singleTableEvent = new TableModelEvent(this);
                }
                this.oneListener.tableChanged(TableElementView.this.singleTableEvent);
            }
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            this.oneListener = tableModelListener;
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return String.class.getName();
        }

        public int getRowCount() {
            if (this.content == null) {
                return 0;
            }
            return this.content.size();
        }

        public Object getValueAt(int n, int n2) {
            return ((Object[])this.content.get(n))[n2];
        }

        public boolean isCellEditable(int n, int n2) {
            if (!TableElementView.this.editable) {
                return false;
            }
            if (TableElementView.this.context != null && !TableElementView.this.context.isEditable()) {
                return false;
            }
            if (n > 1) {
                return true;
            }
            return n2 == 1;
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.oneListener = null;
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2;
            String string;
            String string2;
            StringBuffer stringBuffer;
            Object[] objectArray;
            if (this.content == null) {
                this.content = new ArrayList();
            }
            if ((objectArray = (Object[])this.content.get(n)) == null) {
                objectArray = new Object[2];
                this.content.set(n, objectArray);
            }
            objectArray[n2] = object;
            if (!"".equals(object) && n == this.content.size() - 1) {
                this.content.add(new Object[]{"", ""});
                this.fireUpdate();
            }
            if ("".equals(object)) {
                stringBuffer = null;
                if (n2 == 0 && n < this.content.size() - 1) {
                    this.content.remove(n);
                    this.fireUpdate();
                }
            } else if (n == 1) {
                try {
                    SimpleNode simpleNode = (SimpleNode)TableElementView.this.container.getTree().getSelectionPath().getLastPathComponent();
                    simpleNode.setContent(object.toString());
                    TableElementView.this.container.getTree().repaint();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                int n3 = 0;
                n3 = object.toString().indexOf(":");
                if (n3 > -1) {
                    try {
                        string2 = object.toString();
                        String string3 = string2.substring(0, n3);
                        string = string2.substring(n3 + 1);
                        object2 = (Object[])this.content.get(n);
                        object2[1] = string;
                        Object[] objectArray2 = (Object[])this.content.get(0);
                        objectArray2[1] = string3;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if ("".equals(this.getValueAt(1, 1))) {
                return;
            }
            if ("".equals(this.getValueAt(n, 0)) || "".equals(this.getValueAt(n, 1))) {
                return;
            }
            stringBuffer = new StringBuffer("<");
            if (!"".equals(this.getValueAt(0, 1))) {
                stringBuffer.append(this.getValueAt(0, 1)).append(":");
            }
            stringBuffer.append(this.getValueAt(1, 1));
            string2 = stringBuffer.toString();
            for (int i = 2; i < this.content.size() - 1; ++i) {
                stringBuffer.append(" ");
                string = (String)this.getValueAt(i, 0);
                object2 = (String)this.getValueAt(i, 1);
                if ("".equals(string) || "".equals(object2)) continue;
                stringBuffer.append(string).append("=\"").append(TableElementView.this.normalized((String)object2)).append("\"");
            }
            if (this.closed) {
                stringBuffer.append("/>");
                TableElementView.this.context.update(stringBuffer.toString(), null, this.startingOffset, this.stoppingOffset);
            } else {
                stringBuffer.append(">");
                Point point = TableElementView.this.context.update(stringBuffer.toString(), "</" + string2.substring(1) + ">", this.startingOffset, this.stoppingOffset);
                if (point != null && point.y > 0) {
                    this.stoppingOffset = point.y;
                }
            }
        }
    }

    class SimpleCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JComboBox component = new JComboBox();
        JTextField component2 = new JTextField();
        private boolean combo = true;

        public SimpleCellEditor() {
            if (UIManager.get("xmlpad.helper.backgroundColor") != null) {
                this.component.setBackground(UIManager.getColor("xmlpad.helper.backgroundColor"));
            }
            if (UIManager.get("xmlpad.helper.foregroundColor") != null) {
                this.component.setForeground(UIManager.getColor("xmlpad.helper.foregroundColor"));
            }
            this.component.setRenderer(CommonDescriptorRenderer.getRenderer());
            this.component.setEditable(true);
            this.component.addActionListener(this);
            this.component2.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.fireEditingStopped();
        }

        private void disabledKnownAttributes() {
            if (this.component.getItemCount() <= 0 || !(this.component.getItemAt(0) instanceof AttDescriptor)) {
                return;
            }
            block0: for (int i = 0; i < this.component.getItemCount(); ++i) {
                AttDescriptor attDescriptor = (AttDescriptor)this.component.getItemAt(i);
                String string = attDescriptor.getName();
                attDescriptor.setEnabled(true);
                for (int j = 2; j < TableElementView.this.model.getRowCount(); ++j) {
                    if (!TableElementView.this.model.getValueAt(j, 0).equals(string)) continue;
                    attDescriptor.setEnabled(false);
                    continue block0;
                }
            }
        }

        private void prepareComboTag() {
            this.init();
            AbstractHelperHandler abstractHelperHandler = TableElementView.this.container.getHelperManager().getHelperHandler("schema-elements");
            if (abstractHelperHandler != null) {
                SimpleNode simpleNode = TableElementView.this.container.getCurrentElementNode().getSimpleParent();
                abstractHelperHandler.haveDescriptors(simpleNode, TableElementView.this.container.getDocument(), false, 0, null);
                Descriptor[] descriptorArray = abstractHelperHandler.resolveContentAssistant(simpleNode, TableElementView.this.container.getDocument(), false, 0, null);
                if (descriptorArray != null) {
                    for (int i = 0; i < descriptorArray.length; ++i) {
                        Descriptor descriptor = descriptorArray[i];
                        this.component.addItem(descriptor);
                    }
                }
            }
        }

        private void prepareComboAttribute() {
            Descriptor[] descriptorArray;
            this.init();
            AbstractHelperHandler abstractHelperHandler = TableElementView.this.container.getHelperManager().getHelperHandler("schema-attributes");
            if (abstractHelperHandler != null && TableElementView.this.container.getCurrentElementNode().getSimpleParent() != null && (descriptorArray = abstractHelperHandler.resolveContentAssistant(TableElementView.this.container.getCurrentElementNode().getSimpleParent(), TableElementView.this.container.getDocument(), false, 0, null)) != null) {
                for (int i = 0; i < descriptorArray.length; ++i) {
                    this.component.addItem(descriptorArray[i]);
                }
            }
        }

        public void init() {
            this.component.removeAllItems();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JComponent jComponent = this.component;
            if (n == 0) {
                jComponent = this.component2;
            }
            if (n == 1) {
                if (TableElementView.this.tagHelper == null) {
                    this.prepareComboTag();
                } else {
                    this.prepareComboTag();
                }
            } else if (n > 1) {
                this.prepareComboAttribute();
            }
            if (this.component.getItemCount() == 0 || n2 > 0 && n != 1) {
                jComponent = this.component2;
            }
            this.component2.setText(object.toString());
            this.selectDescriptorCombo(object.toString());
            this.combo = jComponent instanceof JComboBox;
            if (this.combo) {
                this.disabledKnownAttributes();
            }
            return jComponent;
        }

        private void selectDescriptorCombo(String string) {
            for (int i = 0; i < this.component.getItemCount(); ++i) {
                Descriptor descriptor = (Descriptor)this.component.getItemAt(i);
                if (!string.equals(descriptor.getName())) continue;
                this.component.setSelectedIndex(i);
                return;
            }
            this.component.setSelectedItem(string);
        }

        public Object getCellEditorValue() {
            if (this.combo) {
                if (this.component.getSelectedItem() instanceof Descriptor) {
                    return ((Descriptor)this.component.getSelectedItem()).getName();
                }
                return this.component.getEditor().getItem();
            }
            return this.component2.getText();
        }
    }
}

