/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.handler.schema.dtd;

import com.japisoft.dtdparser.node.ElementDTDNode;
import com.japisoft.dtdparser.node.RootDTDNode;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.helper.handler.schema.AbstractTagHandler;
import com.japisoft.xmlpad.helper.handler.schema.dtd.DTDTagDescriptor;
import com.japisoft.xmlpad.helper.handler.schema.dtd.DTDToSchemaNode;
import com.japisoft.xmlpad.helper.model.SchemaNodable;
import com.japisoft.xmlpad.helper.model.SchemaNode;
import com.japisoft.xmlpad.helper.model.TagDescriptor;

public class DTDTagHandler
extends AbstractTagHandler
implements SchemaNodable {
    private RootDTDNode root;
    private String rootElement;
    private SchemaNode schemaNode = null;

    public DTDTagHandler(String string, RootDTDNode rootDTDNode) {
        this.root = rootDTDNode;
        this.rootElement = string;
    }

    public void dispose() {
        super.dispose();
        this.root = null;
    }

    public TagDescriptor getTag(SimpleNode simpleNode) {
        if (simpleNode == null) {
            return null;
        }
        String string = simpleNode.getContent();
        ElementDTDNode elementDTDNode = this.root.getElementDeclaration(string);
        if (elementDTDNode != null) {
            return new DTDTagDescriptor(elementDTDNode);
        }
        return null;
    }

    protected void notifyLocation() {
        if (this.root == null) {
            return;
        }
        this.schemaNode = null;
        if (this.currentDocumentNode == null) {
            ElementDTDNode elementDTDNode;
            if (this.rootElement != null && (elementDTDNode = this.root.getElementDeclaration(this.rootElement)) != null) {
                this.addTagDescriptor(new DTDTagDescriptor(elementDTDNode));
            }
            return;
        }
        String string = this.currentDocumentNode.getContent();
        ElementDTDNode elementDTDNode = this.root.getElementDeclaration(string);
        if (elementDTDNode == null || elementDTDNode.isEmptyElement() || elementDTDNode.hasPCDATA()) {
            return;
        }
        this.schemaNode = new DTDToSchemaNode().getSchemaNode(elementDTDNode);
    }

    protected void completeContentForElementWithoutPrefix() {
        super.completeContentForElementWithoutPrefix();
        if (this.rootElement != null && this.rootElement.indexOf(":") > 0) {
            for (int i = 0; i < this.root.getDTDNodeCount(); ++i) {
                ElementDTDNode elementDTDNode;
                if (!this.root.getDTDNodeAt(i).isElement() || (elementDTDNode = (ElementDTDNode)this.root.getDTDNodeAt(i)).getName().indexOf(":") != -1) continue;
                this.addTagDescriptor(new DTDTagDescriptor(elementDTDNode));
            }
        }
    }

    public SchemaNode getSchemaNode() {
        return this.schemaNode;
    }
}

