/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.model;

import com.japisoft.xmlpad.helper.model.TagDescriptor;
import java.util.ArrayList;
import java.util.HashMap;

public class SchemaNode {
    public int type = 0;
    public TagDescriptor element = null;
    public ArrayList next = null;
    public boolean marked = false;
    public boolean marked2 = false;
    public String namespace = null;
    public SchemaNode parent = null;
    static int ID = 0;
    int id = ++ID;

    private SchemaNode() {
    }

    public SchemaNode(int n) {
        this();
        this.type = n;
    }

    private SchemaNode(SchemaNode schemaNode) {
        this();
        this.type = schemaNode.type;
        this.element = schemaNode.element;
    }

    public SchemaNode(TagDescriptor tagDescriptor) {
        this();
        this.element = tagDescriptor;
    }

    public void addNext(SchemaNode schemaNode) {
        if (this.next == null) {
            this.next = new ArrayList();
        }
        this.next.add(schemaNode);
        schemaNode.parent = this;
    }

    public void removeNext(SchemaNode schemaNode) {
        if (this.next != null) {
            this.next.remove(schemaNode);
        }
    }

    public SchemaNode nextSibling() {
        if (this.parent == null) {
            return null;
        }
        ArrayList arrayList = this.parent.next;
        int n = arrayList.indexOf(this);
        if (arrayList.size() > n + 1) {
            return (SchemaNode)arrayList.get(n + 1);
        }
        return null;
    }

    public SchemaNode getParent() {
        return this.parent;
    }

    public int getSchemaNodeCount() {
        if (this.next == null) {
            return 0;
        }
        return this.next.size();
    }

    public SchemaNode getSchemaNode(int n) {
        if (this.next == null) {
            return null;
        }
        return (SchemaNode)this.next.get(n);
    }

    public boolean isSigma() {
        return this.type == 1;
    }

    public boolean isRoot() {
        return this.type == 2;
    }

    public boolean isOpAND() {
        return this.type == 4;
    }

    public boolean isOpOR() {
        return this.type == 3;
    }

    public boolean isElement() {
        return this.type == 0;
    }

    public void dump() {
        this.dump(this, 0);
    }

    public String toString() {
        if (this.isElement()) {
            return "e(" + this.element.getName() + ")";
        }
        if (this.isOpOR()) {
            return "or(" + this.id + ")";
        }
        if (this.isOpAND()) {
            return "and(" + this.id + ")";
        }
        if (this.isSigma()) {
            return "?";
        }
        if (this.isRoot()) {
            return "R";
        }
        return super.toString();
    }

    private void dump(SchemaNode schemaNode, int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print("\t");
        }
        if (schemaNode.isElement()) {
            System.out.println(schemaNode);
            for (n2 = 0; n2 < schemaNode.getSchemaNodeCount(); ++n2) {
                if (schemaNode.getSchemaNode(n2) != schemaNode) {
                    this.dump(schemaNode.getSchemaNode(n2), n + 1);
                    continue;
                }
                this.dump(new SchemaNode(schemaNode), n + 1);
            }
        } else if (schemaNode.isOpAND()) {
            System.out.println(schemaNode);
            for (n2 = 0; n2 < schemaNode.getSchemaNodeCount(); ++n2) {
                if (schemaNode.getSchemaNode(n2) != schemaNode) {
                    this.dump(schemaNode.getSchemaNode(n2), n + 1);
                    continue;
                }
                this.dump(new SchemaNode(schemaNode), n + 1);
            }
        } else if (schemaNode.isOpOR()) {
            System.out.println(schemaNode);
            for (n2 = 0; n2 < schemaNode.getSchemaNodeCount(); ++n2) {
                if (schemaNode.getSchemaNode(n2) != schemaNode) {
                    this.dump(schemaNode.getSchemaNode(n2), n + 1);
                    continue;
                }
                this.dump(new SchemaNode(schemaNode), n + 1);
            }
        } else if (schemaNode.isRoot()) {
            System.out.println(schemaNode);
            for (n2 = 0; n2 < schemaNode.getSchemaNodeCount(); ++n2) {
                this.dump(schemaNode.getSchemaNode(n2), n + 1);
            }
        } else if (schemaNode.isSigma()) {
            System.out.println(schemaNode);
        }
    }

    public Object clone() {
        SchemaNode schemaNode = new SchemaNode(this);
        this.clone(this, schemaNode, new HashMap());
        return schemaNode;
    }

    private void clone(SchemaNode schemaNode, SchemaNode schemaNode2, HashMap hashMap) {
        for (int i = 0; i < schemaNode.getSchemaNodeCount(); ++i) {
            SchemaNode schemaNode3 = schemaNode.getSchemaNode(i);
            if (schemaNode3 == schemaNode) {
                schemaNode2.addNext(schemaNode2);
                continue;
            }
            if (hashMap.containsKey(schemaNode3)) {
                schemaNode2.addNext((SchemaNode)hashMap.get(schemaNode3));
                continue;
            }
            SchemaNode schemaNode4 = (SchemaNode)schemaNode3.clone();
            hashMap.put(schemaNode3, schemaNode4);
            schemaNode2.addNext(schemaNode4);
        }
    }
}

