/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.helper.model;

import com.japisoft.xmlpad.helper.model.AbstractDescriptor;
import com.japisoft.xmlpad.helper.model.AttDescriptor;
import java.util.ArrayList;

public class TagDescriptor
extends AbstractDescriptor {
    public String name;
    private String nameHelper;
    private AttDescriptor[] atts;
    public boolean empty;
    private boolean raw;
    private boolean enabled = true;
    private int maxOcc = -1;
    private int minOcc = -1;
    private boolean choice = false;
    public String namespace = null;
    private String endAddedPart;
    private ArrayList secondaryTagDescriptor = null;

    public TagDescriptor(String string, boolean bl) {
        this.name = string;
        this.empty = bl;
    }

    public TagDescriptor(String string, AttDescriptor[] attDescriptorArray, boolean bl) {
        this.name = string;
        this.atts = attDescriptorArray;
        this.empty = bl;
    }

    public TagDescriptor(String string, AttDescriptor[] attDescriptorArray, boolean bl, boolean bl2) {
        this.name = string;
        this.atts = attDescriptorArray;
        this.empty = bl;
        this.raw = bl2;
    }

    public TagDescriptor(String string, String string2, AttDescriptor[] attDescriptorArray, boolean bl, boolean bl2) {
        this.name = string;
        this.nameHelper = string2;
        this.atts = attDescriptorArray;
        this.empty = bl;
        this.raw = bl2;
    }

    public void setAttDescriptor(AttDescriptor[] attDescriptorArray) {
        this.atts = attDescriptorArray;
    }

    public void setEmpty(boolean bl) {
        this.empty = bl;
    }

    public void setMaxOcc(int n) {
        this.maxOcc = n;
    }

    public int getMacOcc() {
        return this.maxOcc;
    }

    public void setMinOcc(int n) {
        this.minOcc = n;
    }

    public int getMinOcc() {
        return this.minOcc;
    }

    public void setChoice(boolean bl) {
        this.choice = bl;
    }

    public boolean isChoice() {
        return this.choice;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNameHelper(String string) {
        this.nameHelper = string;
    }

    public String getNameForHelper() {
        if (this.nameHelper == null) {
            this.nameHelper = this.getName().replace('\u00a4', ' ');
            if (this.nameHelper.length() > 40) {
                this.nameHelper = this.nameHelper.substring(0, 40) + "...";
            }
        }
        return this.nameHelper;
    }

    public AttDescriptor[] getRequiredAtt() {
        return this.atts;
    }

    public AttDescriptor[] getAtts() {
        return this.atts;
    }

    public void addAttDescriptor(AttDescriptor attDescriptor) {
        if (this.atts == null) {
            this.atts = new AttDescriptor[]{attDescriptor};
        } else {
            AttDescriptor[] attDescriptorArray = this.atts;
            this.atts = new AttDescriptor[attDescriptorArray.length + 1];
            System.arraycopy(attDescriptorArray, 0, this.atts, 0, attDescriptorArray.length);
            this.atts[attDescriptorArray.length] = attDescriptor;
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        for (int i = 0; i < this.getSynonymousTagDescriptorCount(); ++i) {
            this.getSynonymousTagDescriptor(i).setEnabled(bl);
        }
    }

    public String getStartingTag() {
        StringBuffer stringBuffer = new StringBuffer("<");
        stringBuffer.append(this.name);
        if (this.atts != null) {
            for (int i = 0; i < this.atts.length; ++i) {
                if (!this.atts[i].isRequired()) continue;
                stringBuffer.append(" ");
                stringBuffer.append(this.atts[i].getName());
                stringBuffer.append("=\"");
                stringBuffer.append(this.atts[i].getDefaultValue());
                stringBuffer.append("\"");
            }
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String getEndingTag() {
        StringBuffer stringBuffer = new StringBuffer("</").append(this.name).append(">");
        return stringBuffer.toString();
    }

    public void setEndAddedPart(String string) {
        this.endAddedPart = string;
    }

    public String toExternalForm() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.addedPart != null) {
            stringBuffer.append(this.addedPart);
        }
        stringBuffer.append(this.name);
        boolean bl = false;
        if (!this.raw) {
            if (this.atts != null) {
                for (int i = 0; i < this.atts.length; ++i) {
                    if (!this.atts[i].isRequired()) continue;
                    stringBuffer.append(" ");
                    stringBuffer.append(this.atts[i].getName());
                    stringBuffer.append("=\"");
                    if (!bl) {
                        bl = true;
                        stringBuffer.append("\u00a4");
                    }
                    stringBuffer.append(this.atts[i].getDefaultValue());
                    stringBuffer.append("\"");
                }
            }
            if (this.empty) {
                stringBuffer.append("/>");
            } else {
                stringBuffer.append(">");
                if (!bl) {
                    stringBuffer.append("\u00a4");
                }
                stringBuffer.append("</").append(this.endAddedPart == null ? "" : this.endAddedPart).append(this.name).append(">");
            }
        }
        return stringBuffer.toString();
    }

    public String getBuiltTag() {
        return "<" + this.toExternalForm();
    }

    public String toString() {
        return this.getNameForHelper();
    }

    public boolean equals(Object object) {
        if (object instanceof TagDescriptor) {
            TagDescriptor tagDescriptor = (TagDescriptor)object;
            return tagDescriptor.toString() != null && tagDescriptor.toString().equals(this.toString());
        }
        return super.equals(object);
    }

    public void addSynonymousTagDescriptor(TagDescriptor tagDescriptor) {
        if (this.secondaryTagDescriptor == null) {
            this.secondaryTagDescriptor = new ArrayList();
        }
        this.secondaryTagDescriptor.add(tagDescriptor);
    }

    public int getSynonymousTagDescriptorCount() {
        if (this.secondaryTagDescriptor == null) {
            return 0;
        }
        return this.secondaryTagDescriptor.size();
    }

    public TagDescriptor getSynonymousTagDescriptor(int n) {
        if (this.secondaryTagDescriptor != null) {
            return (TagDescriptor)this.secondaryTagDescriptor.get(n);
        }
        return null;
    }
}

