/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.toolkit;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xpath.NodeSet;
import com.japisoft.xpath.XPath;
import com.japisoft.xpath.XPathException;
import com.japisoft.xpath.kit.FastParserKit;
import java.util.ArrayList;

public class XPathHandler {
    private ArrayList l;
    private int index = -1;
    private XMLContainer container;
    Object res;

    public XPathHandler(XMLContainer xMLContainer, String string, boolean bl) throws XPathException {
        this.container = xMLContainer;
        SimpleNode simpleNode = null;
        if (!bl) {
            simpleNode = xMLContainer.getRootNode();
        } else {
            simpleNode = xMLContainer.getCurrentNode();
            if (simpleNode == null) {
                simpleNode = xMLContainer.getRootNode();
            }
        }
        if (simpleNode == null) {
            throw new XPathException("No document", 0);
        }
        XPath xPath = new XPath(new FastParserKit());
        xPath.setXPathExpression(string);
        xPath.setReferenceNode(simpleNode);
        this.res = xPath.resolve();
        if (this.res instanceof NodeSet) {
            NodeSet nodeSet = (NodeSet)this.res;
            this.l = new ArrayList();
            for (int i = 0; i < nodeSet.size(); ++i) {
                SimpleNode simpleNode2 = (SimpleNode)nodeSet.get(i);
                if (simpleNode2.getType() == 3 && nodeSet.size() == 1) {
                    this.res = simpleNode2;
                    return;
                }
                this.l.add(simpleNode2);
            }
            xMLContainer.getEditor().highlightNodes(this.l);
            this.selectNext();
        }
    }

    public boolean isResultNodesType() {
        return this.res instanceof NodeSet;
    }

    public boolean isAttributeType() {
        return this.res instanceof SimpleNode;
    }

    public String getAttributeValue() {
        if (this.res instanceof SimpleNode) {
            SimpleNode simpleNode = (SimpleNode)this.res;
            String string = simpleNode.getNodeContent();
            SimpleNode simpleNode2 = simpleNode.getSimpleParent();
            return simpleNode2.getAttribute(string);
        }
        return null;
    }

    public Object getRawResult() {
        return this.res;
    }

    public boolean hasResultNodes() {
        return this.l.size() > 0;
    }

    public boolean selectNext() {
        if (this.l.size() > 0 && this.index + 1 < this.l.size()) {
            ++this.index;
            SimpleNode simpleNode = (SimpleNode)this.l.get(this.index);
            int n = simpleNode.getStartingLine();
            this.container.getEditor().highlightLine(n);
            return this.index + 1 < this.l.size();
        }
        return false;
    }

    public boolean selectPrevious() {
        if (this.index > 0) {
            --this.index;
            SimpleNode simpleNode = (SimpleNode)this.l.get(this.index);
            int n = simpleNode.getStartingLine();
            this.container.getEditor().highlightLine(n);
            return this.index > 0;
        }
        return false;
    }
}

