/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.tree.renderer;

import com.japisoft.fastparser.swing.SwingNode;
import com.japisoft.framework.ui.ImageIconProxy;
import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.SharedProperties;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.tree.renderer.DefaultRenderer;
import com.japisoft.xmlpad.tree.renderer.NamespaceRenderer;
import com.japisoft.xmlpad.tree.renderer.NodeRenderer;
import com.japisoft.xmlpad.tree.renderer.PrefixRenderer;
import com.japisoft.xmlpad.tree.renderer.QualifiedRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class FastTreeRenderer
implements TreeCellRenderer {
    private TreeLabel tl;
    private ImageIcon i0;
    private ImageIconProxy i1;
    private ImageIconProxy i2;
    private int mode = 0;
    private XMLContainer container = null;
    Color defaultBackgroundSelectionColor;
    Color defaultBackgroundColor;
    private Font defaultFont = new Font(null, 0, 12);
    private Color defaultTextColor = Color.BLACK;
    private Color defaultTextAttributeColor = Color.GRAY;
    private Color defaultSelectionColor = Color.GRAY;
    private String errorMessage;
    private boolean dashUnderline = false;
    Color dashUnderlineColor = Color.BLACK;
    private SwingNode sn;
    private NodeRenderer currentRenderer = null;

    public FastTreeRenderer(XMLContainer xMLContainer) {
        this.container = xMLContainer;
        this.tl = new TreeLabel();
        try {
            this.i0 = SharedProperties.getBugLittleIcon();
            this.i1 = new ImageIconProxy(new ImageIcon(this.getClass().getResource("element.png")), 1, 1, this.i0);
            this.i2 = new ImageIconProxy(new ImageIcon(this.getClass().getResource("text.png")));
        }
        catch (Throwable throwable) {
            Debug.debug(throwable);
        }
        this.defaultTextColor = UIManager.getColor("Tree.textForeground");
        this.defaultBackgroundSelectionColor = UIManager.getColor("Tree.selectionBackground");
        this.defaultBackgroundColor = UIManager.getColor("Tree.textBackground");
        this.defaultSelectionColor = UIManager.getColor("Tree.selectionForeground");
        this.initUI();
        this.currentRenderer = new DefaultRenderer(this.i1, this.i2, this.tl);
    }

    public NodeRenderer getNodeRenderer() {
        return this.currentRenderer;
    }

    public void setAttribute(String string, String string2) {
        this.currentRenderer.setAttribute(string, string2);
    }

    public JComponent getInnerComponent() {
        return this.tl;
    }

    public void setRenderingMode(int n) {
        this.mode = n;
        switch (n) {
            case 0: {
                this.currentRenderer = new DefaultRenderer(this.i1, this.i2, this.tl);
                break;
            }
            case 1: {
                this.currentRenderer = new PrefixRenderer(this.i1, this.i2, this.tl);
                break;
            }
            case 2: {
                this.currentRenderer = new NamespaceRenderer(this.i1, this.i2, this.tl);
                break;
            }
            case 3: {
                this.currentRenderer = new QualifiedRenderer(this.i1, this.i2, this.tl);
            }
        }
    }

    private void initUI() {
        Color color;
        Icon icon;
        String string = "xmlpad.tree.";
        Font font = UIManager.getFont(string + "font");
        if (font != null) {
            this.setTextFont(font);
        }
        if ((icon = UIManager.getIcon(string + "elementIcon")) != null && icon instanceof ImageIcon) {
            this.setElementIcon((ImageIcon)icon);
        }
        if ((icon = UIManager.getIcon(string + "textIcon")) != null && icon instanceof ImageIcon) {
            this.setTextIcon((ImageIcon)icon);
        }
        if ((color = UIManager.getColor(string + "textColor")) != null) {
            this.setTextColor(color);
            this.defaultSelectionColor = color.brighter().brighter();
        }
        if ((color = UIManager.getColor(string + "selectionColor")) != null) {
            this.setSelectionColor(color);
            this.setDashUnderlineColor(color);
        }
    }

    public void setElementIcon(ImageIcon imageIcon) {
        this.i1 = imageIcon != null ? new ImageIconProxy(imageIcon, 1, 1, this.i0) : null;
    }

    public void setTextIcon(ImageIcon imageIcon) {
        this.i2 = imageIcon != null ? new ImageIconProxy(imageIcon) : null;
    }

    public void setTextFont(Font font) {
        this.defaultFont = font;
        this.tl.setFont(font);
    }

    public void setTextColor(Color color) {
        this.defaultTextColor = color;
    }

    public void setSelectionColor(Color color) {
        this.defaultSelectionColor = color;
    }

    public void activateError(String string) {
        this.errorMessage = string;
        this.tl.setToolTipText(string);
    }

    public void setDashUnderlineMode(boolean bl) {
        this.dashUnderline = bl;
    }

    public boolean isDashUnderlineMode() {
        return this.dashUnderline;
    }

    public void setDashUnderlineColor(Color color) {
        this.dashUnderlineColor = color;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.tl.setColor(this.defaultTextColor);
        if (object instanceof SwingNode) {
            Color color;
            String string;
            this.sn = (SwingNode)object;
            if (this.i1 != null) {
                boolean bl5 = this.i1.activeOverringImage = this.sn.errorMessage != null;
            }
            if ((string = this.sn.getNameSpacePrefix()) != null && this.container != null && (color = this.container.getEditor().getColorForPrefix(string)) != null) {
                this.tl.setColor(color);
            }
            this.currentRenderer.prepare(this.sn, bl);
        } else {
            this.tl.setContent(object.toString(), null, false, this.i2);
        }
        return this.tl;
    }

    public void dispose() {
        this.container = null;
    }

    final class TreeLabel
    extends JComponent {
        private String content;
        private String sub_content;
        private boolean selected;
        private Dimension d = new Dimension(100, 20);
        private int textY;
        private int fmHeight;
        FontMetrics fm;
        private Color fg = null;
        private ImageIcon ii = null;
        private int deltaSubcontent = 0;

        public TreeLabel() {
            this.setFont(FastTreeRenderer.this.defaultFont);
        }

        public void setColor(Color color) {
            this.fg = color;
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.fm = this.getFontMetrics(FastTreeRenderer.this.defaultFont);
            this.fmHeight = this.fm.getHeight() + 2;
            this.textY = this.fm.getAscent();
        }

        public Dimension getPreferredSize() {
            return this.d;
        }

        public boolean isDoubleBuffered() {
            return false;
        }

        public void invalidate() {
        }

        public void validate() {
        }

        public void repaint() {
        }

        public void setContent(String string, String string2, boolean bl, ImageIcon imageIcon) {
            if (string == null) {
                string = "?";
            }
            this.content = string;
            this.sub_content = string2;
            this.selected = bl;
            this.ii = imageIcon;
            int n = 0;
            n = this.fm.stringWidth(string);
            if (string2 != null) {
                if (string2.length() > SharedProperties.VISIBLE_TREENODE_TEXTE) {
                    this.sub_content = string2.substring(0, SharedProperties.VISIBLE_TREENODE_TEXTE) + "...";
                }
                this.deltaSubcontent = n += this.fm.stringWidth(" ");
                n += this.fm.stringWidth(this.sub_content);
            }
            if (imageIcon != null) {
                n = n + 2 + imageIcon.getIconWidth();
            }
            if (bl) {
                n += 6;
            }
            this.d = new Dimension(n + 2, this.fmHeight + 2);
        }

        public void paintComponent(Graphics graphics) {
            int n = 1;
            if (this.ii != null) {
                this.ii.paintIcon(this, graphics, 0, 0);
                n += this.ii.getIconWidth() + 2;
            }
            if (this.selected) {
                if (!FastTreeRenderer.this.isDashUnderlineMode()) {
                    graphics.setColor(FastTreeRenderer.this.defaultBackgroundSelectionColor);
                    graphics.fillRect(n, 0, this.d.width - n, this.d.height);
                    graphics.setColor(FastTreeRenderer.this.defaultSelectionColor);
                } else {
                    graphics.setColor(FastTreeRenderer.this.dashUnderlineColor);
                    int n2 = 1;
                    while ((double)n2 < this.d.getWidth()) {
                        graphics.drawLine(n2, (int)this.d.getHeight() - 1, n2 + 2, (int)this.d.getHeight() - 1);
                        n2 += 4;
                    }
                    graphics.setColor(this.fg);
                }
            } else {
                graphics.setColor(this.fg);
            }
            graphics.drawString(this.content, n, this.textY);
            if (this.sub_content != null) {
                graphics.setColor(FastTreeRenderer.this.defaultTextAttributeColor);
                graphics.drawString(this.sub_content, n + this.deltaSubcontent, this.textY);
            }
        }
    }
}

