/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.AbstractRandomAccessStreamContent;
import org.apache.commons.vfs.provider.ftp.FtpFileObject;
import org.apache.commons.vfs.util.RandomAccessMode;

class FtpRandomAccessContent
extends AbstractRandomAccessStreamContent {
    private final FtpFileObject fileObject;
    protected long filePointer = 0L;
    private DataInputStream dis = null;
    private FtpFileObject.FtpInputStream mis = null;

    FtpRandomAccessContent(FtpFileObject ftpFileObject, RandomAccessMode randomAccessMode) {
        super(randomAccessMode);
        this.fileObject = ftpFileObject;
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long l) throws IOException {
        if (l == this.filePointer) {
            return;
        }
        if (l < 0L) {
            throw new FileSystemException("vfs.provider/random-access-invalid-position.error", new Object[]{new Long(l)});
        }
        if (this.dis != null) {
            this.close();
        }
        this.filePointer = l;
    }

    protected DataInputStream getDataInputStream() throws IOException {
        if (this.dis != null) {
            return this.dis;
        }
        this.mis = this.fileObject.getInputStream(this.filePointer);
        this.dis = new DataInputStream(new FilterInputStream(this.mis){

            public int read() throws IOException {
                int n = super.read();
                if (n > -1) {
                    ++FtpRandomAccessContent.this.filePointer;
                }
                return n;
            }

            public int read(byte[] byArray) throws IOException {
                int n = super.read(byArray);
                if (n > -1) {
                    FtpRandomAccessContent.this.filePointer += (long)n;
                }
                return n;
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = super.read(byArray, n, n2);
                if (n3 > -1) {
                    FtpRandomAccessContent.this.filePointer += (long)n3;
                }
                return n3;
            }

            public void close() throws IOException {
                FtpRandomAccessContent.this.close();
            }
        });
        return this.dis;
    }

    public void close() throws IOException {
        if (this.dis != null) {
            this.mis.abort();
            DataInputStream dataInputStream = this.dis;
            this.dis = null;
            dataInputStream.close();
            this.mis = null;
        }
    }

    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }
}

