/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.jar;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.jar.JarFileObject;
import org.apache.commons.vfs.provider.jar.JarFileProvider;
import org.apache.commons.vfs.provider.zip.ZipFileObject;
import org.apache.commons.vfs.provider.zip.ZipFileSystem;

public class JarFileSystem
extends ZipFileSystem {
    private Attributes attributes;

    protected JarFileSystem(FileName fileName, FileObject fileObject, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(fileName, fileObject, fileSystemOptions);
    }

    protected ZipFile createZipFile(File file) throws FileSystemException {
        try {
            return new JarFile(file);
        }
        catch (IOException iOException) {
            throw new FileSystemException("vfs.provider.jar/open-jar-file.error", file, (Throwable)iOException);
        }
    }

    protected ZipFileObject createZipFileObject(FileName fileName, ZipEntry zipEntry) throws FileSystemException {
        return new JarFileObject(fileName, zipEntry, this, true);
    }

    protected void addCapabilities(Collection collection) {
        collection.addAll(JarFileProvider.capabilities);
    }

    Attributes getAttributes() throws IOException {
        if (this.attributes == null) {
            Manifest manifest = ((JarFile)this.getZipFile()).getManifest();
            if (manifest == null) {
                this.attributes = new Attributes(1);
            } else {
                this.attributes = manifest.getMainAttributes();
                if (this.attributes == null) {
                    this.attributes = new Attributes(1);
                }
            }
        }
        return this.attributes;
    }

    Object getAttribute(Attributes.Name name) throws FileSystemException {
        try {
            Attributes attributes = this.getAttributes();
            String string = attributes.getValue(name);
            return string;
        }
        catch (IOException iOException) {
            throw new FileSystemException(name.toString(), iOException);
        }
    }

    Attributes.Name lookupName(String string) {
        if (Attributes.Name.CLASS_PATH.equals(string)) {
            return Attributes.Name.CLASS_PATH;
        }
        if (Attributes.Name.CONTENT_TYPE.equals(string)) {
            return Attributes.Name.CONTENT_TYPE;
        }
        if (Attributes.Name.EXTENSION_INSTALLATION.equals(string)) {
            return Attributes.Name.EXTENSION_INSTALLATION;
        }
        if (Attributes.Name.EXTENSION_LIST.equals(string)) {
            return Attributes.Name.EXTENSION_LIST;
        }
        if (Attributes.Name.EXTENSION_NAME.equals(string)) {
            return Attributes.Name.EXTENSION_NAME;
        }
        if (Attributes.Name.IMPLEMENTATION_TITLE.equals(string)) {
            return Attributes.Name.IMPLEMENTATION_TITLE;
        }
        if (Attributes.Name.IMPLEMENTATION_URL.equals(string)) {
            return Attributes.Name.IMPLEMENTATION_URL;
        }
        if (Attributes.Name.IMPLEMENTATION_VENDOR.equals(string)) {
            return Attributes.Name.IMPLEMENTATION_VENDOR;
        }
        if (Attributes.Name.IMPLEMENTATION_VENDOR_ID.equals(string)) {
            return Attributes.Name.IMPLEMENTATION_VENDOR_ID;
        }
        if (Attributes.Name.IMPLEMENTATION_VERSION.equals(string)) {
            return Attributes.Name.IMPLEMENTATION_VENDOR;
        }
        if (Attributes.Name.MAIN_CLASS.equals(string)) {
            return Attributes.Name.MAIN_CLASS;
        }
        if (Attributes.Name.MANIFEST_VERSION.equals(string)) {
            return Attributes.Name.MANIFEST_VERSION;
        }
        if (Attributes.Name.SEALED.equals(string)) {
            return Attributes.Name.SEALED;
        }
        if (Attributes.Name.SIGNATURE_VERSION.equals(string)) {
            return Attributes.Name.SIGNATURE_VERSION;
        }
        if (Attributes.Name.SPECIFICATION_TITLE.equals(string)) {
            return Attributes.Name.SPECIFICATION_TITLE;
        }
        if (Attributes.Name.SPECIFICATION_VENDOR.equals(string)) {
            return Attributes.Name.SPECIFICATION_VENDOR;
        }
        if (Attributes.Name.SPECIFICATION_VERSION.equals(string)) {
            return Attributes.Name.SPECIFICATION_VERSION;
        }
        return new Attributes.Name(string);
    }

    public Object getAttribute(String string) throws FileSystemException {
        Attributes.Name name = this.lookupName(string);
        return this.getAttribute(name);
    }

    protected ZipFile getZipFile() throws FileSystemException {
        return super.getZipFile();
    }
}

