/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import java.io.File;
import java.io.FilePermission;
import java.util.Collection;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs.provider.local.LocalFile;

public class LocalFileSystem
extends AbstractFileSystem
implements FileSystem {
    private final String rootFile;

    public LocalFileSystem(FileName fileName, String string, FileSystemOptions fileSystemOptions) {
        super(fileName, null, fileSystemOptions);
        this.rootFile = string;
    }

    protected FileObject createFile(FileName fileName) throws FileSystemException {
        return new LocalFile(this, this.rootFile, fileName);
    }

    protected void addCapabilities(Collection collection) {
        collection.addAll(DefaultLocalFileProvider.capabilities);
    }

    protected File doReplicateFile(FileObject fileObject, FileSelector fileSelector) throws Exception {
        LocalFile localFile = (LocalFile)fileObject;
        File file = localFile.getLocalFile();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            FilePermission filePermission = new FilePermission(file.getAbsolutePath(), "read");
            securityManager.checkPermission(filePermission);
        }
        return file;
    }
}

