/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeDesignator;
import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import org.exist.client.xacml.AttributeHandler;
import org.exist.security.xacml.XACMLConstants;

public class ModuleAttributeHandler
implements AttributeHandler {
    public void filterFunctions(Set functions, AttributeDesignator attribute) {
        URI id = attribute.getId();
        if (id.equals(XACMLConstants.MODULE_CATEGORY_ATTRIBUTE)) {
            ArrayList<String> retain = new ArrayList<String>(2);
            retain.add("=");
            retain.add("equals");
            functions.retainAll(retain);
        } else if (id.equals(XACMLConstants.SOURCE_KEY_ATTRIBUTE) || id.equals(XACMLConstants.MODULE_NS_ATTRIBUTE) || id.equals(XACMLConstants.SOURCE_TYPE_ATTRIBUTE)) {
            // empty if block
        }
    }

    public boolean getAllowedValues(Set values, AttributeDesignator attribute) {
        URI id = attribute.getId();
        if (id.equals(XACMLConstants.MODULE_CATEGORY_ATTRIBUTE)) {
            values.add("main");
            values.add("external library");
            values.add("internal library");
            return false;
        }
        if (id.equals(XACMLConstants.SOURCE_KEY_ATTRIBUTE)) {
            return true;
        }
        if (id.equals(XACMLConstants.SOURCE_TYPE_ATTRIBUTE)) {
            values.add("File");
            values.add("Database");
            values.add("Class");
            values.add("Classloader");
            values.add("URL");
            values.add("String");
            values.add("Cocoon");
            return false;
        }
        if (id.equals(XACMLConstants.MODULE_NS_ATTRIBUTE)) {
            values.add("http://www.w3.org/2005/xpath-functions");
            this.addInternal(values, 0);
            return true;
        }
        return true;
    }

    private void addInternal(Set values, int index) {
    }

    public void checkUserValue(AttributeValue value, AttributeDesignator attribute) throws ParsingException {
    }
}

