/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;

public class Copy
extends AbstractWebDAVMethod {
    public Copy(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl resource = null;
        try {
            URI uri;
            XmldbURI destPath;
            block22: {
                broker = this.pool.get(user);
                collection = broker.openCollection(path, 0);
                if (collection == null) {
                    XmldbURI docUri = path.lastSegment();
                    XmldbURI collUri = path.removeLastSegment();
                    collection = broker.openCollection(collUri, 0);
                    if (collection == null) {
                        LOG.debug((Object)("No resource or collection found for path: " + path));
                        response.sendError(404, "No resource or collection found");
                        return;
                    }
                    resource = collection.getDocumentWithLock(broker, docUri, 0);
                    if (resource == null) {
                        LOG.debug((Object)("No resource found for path: " + path));
                        response.sendError(404, "No resource or collection found");
                        return;
                    }
                }
                String destination = request.getHeader("Destination");
                destPath = null;
                uri = new URI(destination);
                String host = uri.getHost();
                int port = uri.getPort();
                if (host.equals(request.getServerName()) && port == request.getServerPort()) break block22;
                response.sendError(501, "Copying to a different server is not yet implemented");
                return;
            }
            try {
                String tempDestPath = uri.getPath();
                if (tempDestPath.startsWith(request.getContextPath())) {
                    tempDestPath = tempDestPath.substring(request.getContextPath().length());
                }
                if (tempDestPath.startsWith(request.getServletPath())) {
                    tempDestPath = tempDestPath.substring(request.getServletPath().length());
                }
                destPath = XmldbURI.create(tempDestPath);
            }
            catch (URISyntaxException e) {
                response.sendError(400, "Malformed URL in destination header");
            }
            if (resource != null) {
                this.copyResource(user, broker, request, response, collection, resource, destPath);
            } else {
                this.copyCollection(user, broker, request, response, collection, destPath);
            }
        }
        catch (EXistException e) {
            LOG.error((Object)e);
            response.sendError(500, e.getMessage());
        }
        catch (LockException e) {
            LOG.debug((Object)e.getMessage());
            response.sendError(423, e.getMessage());
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            if (resource != null) {
                resource.getUpdateLock().release(0);
            }
            this.pool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(User user, DBBroker broker, HttpServletRequest request, HttpServletResponse response, Collection sourceCollection, DocumentImpl resource, XmldbURI destination) throws ServletException, IOException {
        XmldbURI newResourceName = destination.lastSegment();
        if (newResourceName == null) {
            response.sendError(400, "Bad destination: " + destination);
            return;
        }
        destination = destination.removeLastSegment();
        boolean replaced = false;
        Collection destCollection = null;
        TransactionManager transact = broker.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            destCollection = broker.openCollection(destination, 1);
            if (destCollection == null) {
                transact.abort(transaction);
                response.sendError(409, "Destination collection not found");
                return;
            }
            DocumentImpl oldDoc = destCollection.getDocument(broker, newResourceName);
            if (oldDoc != null) {
                boolean overwrite = this.overwrite(request);
                if (!overwrite) {
                    transact.abort(transaction);
                    response.sendError(412, "Destination resource exists and overwrite is not allowed");
                    return;
                }
                replaced = true;
            }
            broker.copyXMLResource(transaction, resource, destCollection, newResourceName);
            transact.commit(transaction);
            if (replaced) {
                response.setStatus(204);
            } else {
                response.setStatus(201);
            }
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            response.sendError(403, e.getMessage());
        }
        catch (LockException e) {
            transact.abort(transaction);
            response.sendError(500, e.getMessage());
        }
        catch (TransactionException e) {
            transact.abort(transaction);
            response.sendError(500, e.getMessage());
        }
        finally {
            if (destCollection != null) {
                destCollection.release(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyCollection(User user, DBBroker broker, HttpServletRequest request, HttpServletResponse response, Collection collection, XmldbURI destination) throws ServletException, IOException {
        XmldbURI newCollectionName = destination.lastSegment();
        if (newCollectionName == null) {
            response.sendError(400, "Bad destination: " + destination);
            return;
        }
        destination = destination.lastSegment();
        boolean replaced = false;
        Collection destCollection = null;
        TransactionManager transact = broker.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            destCollection = broker.openCollection(destination, 1);
            if (destCollection == null) {
                transact.abort(transaction);
                response.sendError(409, "Destination collection not found");
                return;
            }
            if (destCollection.hasChildCollection(newCollectionName)) {
                boolean overwrite = this.overwrite(request);
                if (!overwrite) {
                    transact.abort(transaction);
                    response.sendError(412, "Destination collection exists and overwrite is not allowed");
                    return;
                }
                replaced = true;
            }
            broker.copyCollection(transaction, collection, destCollection, newCollectionName);
            transact.commit(transaction);
            if (replaced) {
                response.setStatus(204);
            } else {
                response.setStatus(201);
            }
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            response.sendError(403, e.getMessage());
        }
        catch (LockException e) {
            transact.abort(transaction);
            response.sendError(500, e.getMessage());
        }
        catch (TransactionException e) {
            transact.abort(transaction);
            response.sendError(500, e.getMessage());
        }
        finally {
            if (destCollection != null) {
                destCollection.release(1);
            }
        }
    }

    private boolean overwrite(HttpServletRequest request) {
        String header = request.getHeader("Overwrite");
        if (header == null) {
            return false;
        }
        return header.equals("T");
    }
}

