/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.exist.storage.BrokerPool;
import org.exist.storage.io.ExistIOException;
import org.exist.util.Configuration;
import org.exist.validation.GrammarPool;
import org.exist.validation.ValidationContentHandler;
import org.exist.validation.ValidationReport;
import org.exist.validation.XmlLibraryChecker;
import org.exist.validation.resolver.AnyUriResolver;
import org.exist.validation.resolver.SearchResourceResolver;
import org.exist.validation.resolver.eXistXMLCatalogResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Validator {
    private static final Logger logger = Logger.getLogger((Class)Validator.class);
    private BrokerPool brokerPool = null;
    private GrammarPool grammarPool = null;
    private Configuration config = null;
    private eXistXMLCatalogResolver systemCatalogResolver = null;

    public Validator(BrokerPool pool) {
        logger.info((Object)"Initializing Validator.");
        if (this.brokerPool == null) {
            this.brokerPool = pool;
        }
        this.config = this.brokerPool.getConfiguration();
        StringBuffer xmlLibMessage = new StringBuffer();
        if (!XmlLibraryChecker.hasValidParser(xmlLibMessage)) {
            logger.error((Object)xmlLibMessage);
        }
        this.grammarPool = (GrammarPool)this.config.getProperty("validation.grammar_pool");
        this.systemCatalogResolver = (eXistXMLCatalogResolver)((Object)this.config.getProperty("validation.resolver"));
    }

    public ValidationReport validate(InputStream is) {
        return this.validate(new InputStreamReader(is), null);
    }

    public ValidationReport validate(InputStream is, String grammarPath) {
        return this.validate(new InputStreamReader(is), grammarPath);
    }

    public ValidationReport validate(Reader reader) {
        return this.validate(reader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidationReport validate(Reader reader, String grammarPath) {
        logger.debug((Object)"Start validation.");
        if (grammarPath != null && grammarPath.startsWith("/")) {
            grammarPath = "xmldb:exist://" + grammarPath;
        }
        ValidationReport report = new ValidationReport();
        ValidationContentHandler handler = new ValidationContentHandler();
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setValidating(true);
        saxFactory.setNamespaceAware(true);
        try {
            InputSource source = new InputSource(reader);
            SAXParser saxParser = saxFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", this.grammarPool);
            xmlReader.setFeature("http://xml.org/sax/features/validation", true);
            xmlReader.setFeature("http://apache.org/xml/features/validation/dynamic", false);
            xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            if (grammarPath == null) {
                logger.debug((Object)"Validation using system catalog.");
                xmlReader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", (Object)this.systemCatalogResolver);
            } else if (grammarPath.endsWith(".xml")) {
                logger.debug((Object)("Validation using user specified catalog '" + grammarPath + "'."));
                eXistXMLCatalogResolver resolver = new eXistXMLCatalogResolver();
                resolver.setCatalogList(new String[]{grammarPath});
                xmlReader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", (Object)resolver);
            } else if (grammarPath.endsWith("/")) {
                logger.debug((Object)("Validation using searched grammar, start from '" + grammarPath + "'."));
                SearchResourceResolver resolver = new SearchResourceResolver(grammarPath, this.brokerPool);
                xmlReader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", resolver);
            } else {
                logger.debug((Object)("Validation using specified grammar '" + grammarPath + "'."));
                AnyUriResolver resolver = new AnyUriResolver(grammarPath);
                xmlReader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", resolver);
            }
            xmlReader.setErrorHandler(report);
            xmlReader.setContentHandler(handler);
            logger.debug((Object)"Validation started.");
            report.start();
            xmlReader.parse(source);
            logger.debug((Object)"Validation stopped.");
            report.stop();
            report.setNamespaceUri(handler.getNamespaceUri());
            if (!report.isValid()) {
                logger.debug((Object)"Document is not valid.");
            }
        }
        catch (ExistIOException ex) {
            logger.error((Object)ex.getCause());
            report.setThrowable(ex.getCause());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            report.setThrowable(ex);
        }
        finally {
            report.stop();
            logger.debug((Object)("Validation performed in " + report.getValidationDuration() + " msec."));
        }
        return report;
    }
}

